/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;

@BugPattern(name="MustBeClosedChecker", summary="Invocations of methods or constructors annotated with @MustBeClosed must occur within the resource variable initializer of a try-with-resources statement, or the return statement of another method annotated with @MustBeClosed.", explanation="Methods or constructors annotated with @MustBeClosed require that the returned resource is closed. This is enforced by checking that invocations occur within the resource variable initializer of a try-with-resources statement.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class MustBeClosedChecker
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final Matcher<Tree> HAS_MUST_BE_CLOSED_ANNOTATION = Matchers.hasAnnotation((String)MustBeClosed.class.getCanonicalName());
    private static final Matcher<MethodTree> METHOD_RETURNS_AUTO_CLOSEABLE_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.methodIsConstructor()), Matchers.methodReturns((Matcher)Matchers.isSubtypeOf((String)"java.lang.AutoCloseable"))});
    private static final Matcher<MethodTree> AUTO_CLOSEABLE_CONSTRUCTOR_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsConstructor(), Matchers.enclosingClass((Matcher)Matchers.isSubtypeOf((String)"java.lang.AutoCloseable"))});

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!HAS_MUST_BE_CLOSED_ANNOTATION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        boolean isAConstructor = Matchers.methodIsConstructor().matches((Tree)tree, state);
        if (isAConstructor && !AUTO_CLOSEABLE_CONSTRUCTOR_MATCHER.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("MustBeClosed should only annotate constructors of AutoCloseables.").build();
        }
        if (!isAConstructor && !METHOD_RETURNS_AUTO_CLOSEABLE_MATCHER.matches((Tree)tree, state)) {
            return this.buildDescription(tree).setMessage("MustBeClosed should only annotate methods that return an AutoCloseable.").build();
        }
        return Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol msym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (msym == null) {
            return Description.NO_MATCH;
        }
        String methodName = ((Name)msym.getSimpleName()).toString();
        return this.matchNewClassOrMethodInvocation(methodName, tree, state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return this.matchNewClassOrMethodInvocation("Constructor", tree, state);
    }

    private Description matchNewClassOrMethodInvocation(String name, Tree tree, VisitorState state) {
        if (!HAS_MUST_BE_CLOSED_ANNOTATION.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        String errorMessage = String.format("%s must be called within the resource variable initializer of a try-with-resources statement.", name);
        MethodTree callerMethodTree = MustBeClosedChecker.enclosingMethod(state);
        if (state.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.RETURN && callerMethodTree != null) {
            if (HAS_MUST_BE_CLOSED_ANNOTATION.matches((Tree)callerMethodTree, state)) {
                return Description.NO_MATCH;
            }
            return this.buildDescription(tree).addFix((Fix)SuggestedFix.builder().prefixWith((Tree)callerMethodTree, "@MustBeClosed\n").addImport(MustBeClosed.class.getCanonicalName()).build()).setMessage(errorMessage).build();
        }
        if (!this.inTWR(state)) {
            return this.buildDescription(tree).setMessage(errorMessage).build();
        }
        return Description.NO_MATCH;
    }

    @Nullable
    private static MethodTree enclosingMethod(VisitorState state) {
        for (Tree node : state.getPath().getParentPath()) {
            switch (node.getKind()) {
                case LAMBDA_EXPRESSION: 
                case NEW_CLASS: {
                    return null;
                }
                case METHOD: {
                    return (MethodTree)node;
                }
            }
        }
        return null;
    }

    private boolean inTWR(VisitorState state) {
        TreePath path = state.getPath().getParentPath();
        while (path.getLeaf().getKind() == Tree.Kind.CONDITIONAL_EXPRESSION) {
            path = path.getParentPath();
        }
        Symbol sym = ASTHelpers.getSymbol((Tree)path.getLeaf());
        return sym != null && sym.getKind() == ElementKind.RESOURCE_VARIABLE;
    }
}

