/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.CharMatcher;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.SuppressPackageLocation;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.net.URI;

@BugPattern(name="PackageLocation", summary="Package names should match the directory they are declared in", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION, suppressibility=BugPattern.Suppressibility.CUSTOM_ANNOTATION, documentSuppression=false, customSuppressionAnnotations={SuppressPackageLocation.class})
public class PackageLocation
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final CharMatcher DOT_MATCHER = CharMatcher.is((char)'.');

    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        String expectedSuffix;
        if (state.isAndroidCompatible()) {
            return Description.NO_MATCH;
        }
        if (tree.getPackageName() == null) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Tree)tree.getPackage(), SuppressPackageLocation.class, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        String packageName = tree.getPackageName().toString();
        String actualFileName = ASTHelpers.getFileNameFromUri((URI)tree.getSourceFile().toUri());
        if (actualFileName == null) {
            return Description.NO_MATCH;
        }
        String actualPath = actualFileName.substring(0, actualFileName.lastIndexOf(47));
        if (actualPath.endsWith(expectedSuffix = "/" + DOT_MATCHER.replaceFrom((CharSequence)packageName, '/'))) {
            return Description.NO_MATCH;
        }
        String message = String.format("Expected package %s to be declared in a directory ending with %s, instead found %s", packageName, expectedSuffix, actualPath);
        return this.buildDescription(tree.getPackageName()).setMessage(message).build();
    }
}

