/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.DCTree;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;

@BugPattern(name="MissingSummary", summary="A summary line is required on public/protected Javadocs.", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"}, linkType=BugPattern.LinkType.CUSTOM, link="http://google.github.io/styleguide/javaguide.html#s7.2-summary-fragment", providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, documentSuppression=false)
public final class MissingSummary
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final String CONSIDER_USING_MESSAGE = "A summary fragment is required; consider using the value of the @%s block as a summary fragment instead.";

    public Description matchClass(ClassTree classTree, VisitorState state) {
        return this.handle(Utils.getDocTreePath(state), state);
    }

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        return this.handle(Utils.getDocTreePath(state), state);
    }

    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        return this.handle(Utils.getDocTreePath(state), state);
    }

    private Description handle(@Nullable DocTreePath docTreePath, VisitorState state) {
        if (docTreePath == null) {
            return Description.NO_MATCH;
        }
        if (!MissingSummary.requiresJavadoc(docTreePath.getTreePath().getLeaf(), state)) {
            return Description.NO_MATCH;
        }
        List<? extends DocTree> firstSentence = docTreePath.getDocComment().getFirstSentence();
        if (!firstSentence.isEmpty()) {
            return Description.NO_MATCH;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)docTreePath.getTreePath().getLeaf());
        if (symbol == null) {
            return Description.NO_MATCH;
        }
        if (symbol.isConstructor()) {
            return Description.NO_MATCH;
        }
        ReturnTree returnTree = MissingSummary.findFirst(docTreePath, ReturnTree.class);
        if (returnTree != null) {
            return this.generateReturnFix(docTreePath, returnTree, state);
        }
        SeeTree seeTree = MissingSummary.findFirst(docTreePath, SeeTree.class);
        if (seeTree != null) {
            return this.generateSeeFix(docTreePath, seeTree, state);
        }
        Set<Modifier> modifiers = symbol.getModifiers();
        if (!modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PROTECTED)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Symbol)symbol, (String)"java.lang.Override", (VisitorState)state) || ASTHelpers.hasAnnotation((Symbol)symbol, (String)"java.lang.Deprecated", (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(Utils.diagnosticPosition(docTreePath, state)).build();
    }

    private Description generateReturnFix(DocTreePath docTreePath, ReturnTree returnTree, VisitorState state) {
        int pos = ((DCTree.DCDocComment)docTreePath.getDocComment()).comment.getSourcePos(0);
        String description = returnTree.toString().replaceAll("^@return ", "");
        SuggestedFix fix = SuggestedFix.builder().merge(Utils.replace(returnTree, "", state)).replace(pos, pos, String.format("Returns %s%s\n", MissingSummary.lowerFirstLetter(description), description.endsWith(".") ? "" : ".")).build();
        return this.buildDescription(Utils.diagnosticPosition(docTreePath, state)).setMessage(String.format(CONSIDER_USING_MESSAGE, "return")).addFix((Fix)fix).build();
    }

    private Description generateSeeFix(DocTreePath docTreePath, SeeTree seeTree, VisitorState state) {
        int pos = ((DCTree.DCDocComment)docTreePath.getDocComment()).comment.getSourcePos(0);
        SuggestedFix fix = SuggestedFix.builder().merge(Utils.replace(seeTree, "", state)).replace(pos, pos, String.format("See {@link %s}.\n", seeTree.getReference().stream().map(Object::toString).collect(Collectors.joining(" ")))).build();
        return this.buildDescription(Utils.diagnosticPosition(docTreePath, state)).setMessage(String.format(CONSIDER_USING_MESSAGE, "see")).addFix((Fix)fix).build();
    }

    @Nullable
    private static <T> T findFirst(DocTreePath docTreePath, final Class<T> clazz) {
        return new DocTreeScanner<T, Void>(){

            @Override
            public T scan(DocTree docTree, Void unused) {
                if (clazz.isInstance(docTree)) {
                    return clazz.cast(docTree);
                }
                return super.scan(docTree, null);
            }
        }.scan(docTreePath.getLeaf(), null);
    }

    private static String lowerFirstLetter(String description) {
        return Character.toLowerCase(description.charAt(0)) + description.substring(1);
    }

    private static boolean requiresJavadoc(Tree tree, VisitorState state) {
        if (state.errorProneOptions().isTestOnlyTarget()) {
            return false;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (symbol instanceof Symbol.MethodSymbol && !ASTHelpers.findSuperMethods((Symbol.MethodSymbol)((Symbol.MethodSymbol)symbol), (Types)state.getTypes()).isEmpty()) {
            return false;
        }
        return symbol != null && (symbol.getModifiers().contains((Object)Modifier.PUBLIC) || symbol.getModifiers().contains((Object)Modifier.PROTECTED));
    }
}

