/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="DurationFrom", summary="Duration.from(Duration) returns itself; from(Period) throws a runtime exception.", explanation="Duration.from(TemporalAmount) will always throw a UnsupportedTemporalTypeException when passed a Period and return itself when passed a Duration.", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public final class DurationFrom
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> DURATION_FROM = Matchers.staticMethod().onClass("java.time.Duration").named("from");
    private static final Matcher<Tree> DURATION = Matchers.isSameType((String)"java.time.Duration");
    private static final Matcher<Tree> PERIOD = Matchers.isSameType((String)"java.time.Period");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (DURATION_FROM.matches((Tree)tree, state)) {
            ExpressionTree arg0 = tree.getArguments().get(0);
            if (PERIOD.matches((Tree)arg0, state)) {
                return this.describeMatch(tree);
            }
            if (DURATION.matches((Tree)arg0, state)) {
                return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)state.getSourceForNode((Tree)arg0)));
            }
        }
        return Description.NO_MATCH;
    }
}

