/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.Annotation;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Comment;
import lombok.ast.CompilationUnit;
import lombok.ast.Identifier;
import lombok.ast.JavadocContainer;
import lombok.ast.ListAccessor;
import lombok.ast.Node;
import lombok.ast.PackageDeclarationTemplate;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;

public class PackageDeclaration
extends AbstractNode
implements JavadocContainer {
    private AbstractNode javadoc = null;
    ListAccessor<Annotation, PackageDeclaration> annotations = ListAccessor.of(this, Annotation.class, "PackageDeclaration.annotations");
    ListAccessor<Identifier, PackageDeclaration> parts = ListAccessor.of(this, Identifier.class, "PackageDeclaration.parts");

    public CompilationUnit upToCompilationUnit() {
        if (!(this.getParent() instanceof CompilationUnit)) {
            return null;
        }
        CompilationUnit out = (CompilationUnit)this.getParent();
        if (out.rawPackageDeclaration() != this) {
            return null;
        }
        return out;
    }

    @Override
    public Comment astJavadoc() {
        if (!(this.javadoc instanceof Comment)) {
            return null;
        }
        return (Comment)this.javadoc;
    }

    @Override
    public PackageDeclaration astJavadoc(Comment javadoc) {
        return this.rawJavadoc(javadoc);
    }

    @Override
    public Node rawJavadoc() {
        return this.javadoc;
    }

    @Override
    public PackageDeclaration rawJavadoc(Node javadoc) {
        if (javadoc == this.javadoc) {
            return this;
        }
        if (javadoc != null) {
            this.adopt((AbstractNode)javadoc);
        }
        if (this.javadoc != null) {
            this.disown(this.javadoc);
        }
        this.javadoc = (AbstractNode)javadoc;
        return this;
    }

    public RawListAccessor<Annotation, PackageDeclaration> rawAnnotations() {
        return this.annotations.asRaw();
    }

    public StrictListAccessor<Annotation, PackageDeclaration> astAnnotations() {
        return this.annotations.asStrict();
    }

    public RawListAccessor<Identifier, PackageDeclaration> rawParts() {
        return this.parts.asRaw();
    }

    public StrictListAccessor<Identifier, PackageDeclaration> astParts() {
        return this.parts.asStrict();
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.javadoc != null) {
            result.add(this.javadoc);
        }
        result.addAll(this.annotations.backingList());
        result.addAll(this.parts.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.javadoc == original) {
            this.rawJavadoc(replacement);
            return true;
        }
        if (this.rawAnnotations().replace(original, replacement)) {
            return true;
        }
        return this.rawParts().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        if (this.javadoc == child) {
            this.disown((AbstractNode)child);
            this.javadoc = null;
            return true;
        }
        if (this.rawAnnotations().remove(child)) {
            return true;
        }
        return this.rawParts().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitPackageDeclaration(this)) {
            return;
        }
        if (this.javadoc != null) {
            this.javadoc.accept(visitor);
        }
        for (AbstractNode child : this.annotations.asIterable()) {
            child.accept(visitor);
        }
        for (AbstractNode child : this.parts.asIterable()) {
            child.accept(visitor);
        }
        visitor.afterVisitPackageDeclaration(this);
        visitor.endVisit(this);
    }

    @Override
    public PackageDeclaration copy() {
        PackageDeclaration result = new PackageDeclaration();
        if (this.javadoc != null) {
            result.rawJavadoc(this.javadoc.copy());
        }
        for (AbstractNode n : this.annotations.backingList()) {
            result.rawAnnotations().addToEnd(n == null ? null : n.copy());
        }
        for (AbstractNode n : this.parts.backingList()) {
            result.rawParts().addToEnd(n == null ? null : n.copy());
        }
        return result;
    }

    public String getPackageName() {
        return PackageDeclarationTemplate.getPackageName(this);
    }
}

