/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.jvm.ModuleNameReader;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class ModuleFinder {
    protected static final Context.Key<ModuleFinder> moduleFinderKey = new Context.Key();
    private final Log log;
    private final Symtab syms;
    private final Names names;
    private final ClassFinder classFinder;
    private final JavaFileManager fileManager;
    private final JCDiagnostic.Factory diags;
    private ModuleNameReader moduleNameReader;
    public ModuleNameFromSourceReader moduleNameFromSourceReader;
    ModuleLocationIterator moduleLocationIterator = new ModuleLocationIterator();

    public static ModuleFinder instance(Context context) {
        ModuleFinder moduleFinder = context.get(moduleFinderKey);
        if (moduleFinder == null) {
            moduleFinder = new ModuleFinder(context);
        }
        return moduleFinder;
    }

    protected ModuleFinder(Context context) {
        context.put(moduleFinderKey, this);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.log = Log.instance(context);
        this.classFinder = ClassFinder.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
    }

    public Symbol.ModuleSymbol findModule(Name name) {
        return this.findModule(this.syms.enterModule(name));
    }

    public Symbol.ModuleSymbol findModule(Symbol.ModuleSymbol moduleSymbol) {
        List<Symbol.ModuleSymbol> list;
        if (moduleSymbol.kind != Kinds.Kind.ERR && moduleSymbol.sourceLocation == null && moduleSymbol.classLocation == null && (list = this.scanModulePath(moduleSymbol)).isEmpty()) {
            moduleSymbol.kind = Kinds.Kind.ERR;
        }
        if (moduleSymbol.kind != Kinds.Kind.ERR && moduleSymbol.module_info.sourcefile == null && moduleSymbol.module_info.classfile == null) {
            this.findModuleInfo(moduleSymbol);
        }
        return moduleSymbol;
    }

    public List<Symbol.ModuleSymbol> findAllModules() {
        List<Symbol.ModuleSymbol> list = this.scanModulePath(null);
        for (Symbol.ModuleSymbol moduleSymbol : list) {
            if (moduleSymbol.kind == Kinds.Kind.ERR || moduleSymbol.module_info.sourcefile != null || moduleSymbol.module_info.classfile != null) continue;
            this.findModuleInfo(moduleSymbol);
        }
        return list;
    }

    public Symbol.ModuleSymbol findSingleModule() {
        try {
            JavaFileObject javaFileObject = this.getModuleInfoFromLocation(StandardLocation.SOURCE_PATH, JavaFileObject.Kind.SOURCE);
            JavaFileObject javaFileObject2 = this.getModuleInfoFromLocation(StandardLocation.CLASS_OUTPUT, JavaFileObject.Kind.CLASS);
            JavaFileObject javaFileObject3 = javaFileObject == null ? javaFileObject2 : (javaFileObject2 == null ? javaFileObject : this.classFinder.preferredFileObject(javaFileObject, javaFileObject2));
            Symbol.ModuleSymbol moduleSymbol = javaFileObject3 == null ? this.syms.unnamedModule : this.readModule(javaFileObject3);
            if (moduleSymbol.patchLocation == null) {
                moduleSymbol.classLocation = StandardLocation.CLASS_OUTPUT;
            } else {
                moduleSymbol.patchOutputLocation = StandardLocation.CLASS_OUTPUT;
            }
            return moduleSymbol;
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    private Symbol.ModuleSymbol readModule(JavaFileObject javaFileObject) throws IOException {
        Name name;
        switch (javaFileObject.getKind()) {
            case SOURCE: {
                name = this.moduleNameFromSourceReader.readModuleName(javaFileObject);
                if (name != null) break;
                JCDiagnostic jCDiagnostic = this.diags.fragment("file.does.not.contain.module", new Object[0]);
                Symbol.ClassSymbol classSymbol = this.syms.defineClass(this.names.module_info, this.syms.errModule);
                throw new ClassFinder.BadClassFile(classSymbol, javaFileObject, jCDiagnostic, this.diags);
            }
            case CLASS: {
                try {
                    name = this.names.fromString(this.readModuleName(javaFileObject));
                }
                catch (ModuleNameReader.BadClassFile | IOException exception) {
                    name = this.names.error;
                }
                break;
            }
            default: {
                Assert.error();
                name = this.names.error;
            }
        }
        Symbol.ModuleSymbol moduleSymbol = this.syms.enterModule(name);
        moduleSymbol.module_info.classfile = javaFileObject;
        if (this.fileManager.hasLocation(StandardLocation.PATCH_MODULE_PATH) && name != this.names.error) {
            moduleSymbol.patchLocation = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.PATCH_MODULE_PATH, name.toString());
            if (moduleSymbol.patchLocation != null) {
                JavaFileObject javaFileObject2 = this.getModuleInfoFromLocation(StandardLocation.CLASS_OUTPUT, JavaFileObject.Kind.CLASS);
                javaFileObject2 = this.preferredFileObject(this.getModuleInfoFromLocation(moduleSymbol.patchLocation, JavaFileObject.Kind.CLASS), javaFileObject2);
                javaFileObject2 = this.preferredFileObject(this.getModuleInfoFromLocation(moduleSymbol.patchLocation, JavaFileObject.Kind.SOURCE), javaFileObject2);
                if (javaFileObject2 != null) {
                    moduleSymbol.module_info.classfile = javaFileObject2;
                }
            }
        }
        moduleSymbol.completer = Symbol.Completer.NULL_COMPLETER;
        this.classFinder.fillIn(moduleSymbol.module_info);
        return moduleSymbol;
    }

    private String readModuleName(JavaFileObject javaFileObject) throws IOException, ModuleNameReader.BadClassFile {
        if (this.moduleNameReader == null) {
            this.moduleNameReader = new ModuleNameReader();
        }
        return this.moduleNameReader.readModuleName(javaFileObject);
    }

    private JavaFileObject getModuleInfoFromLocation(JavaFileManager.Location location, JavaFileObject.Kind kind) throws IOException {
        if (location == null || !this.fileManager.hasLocation(location)) {
            return null;
        }
        return this.fileManager.getJavaFileForInput(location, this.names.module_info.toString(), kind);
    }

    private List<Symbol.ModuleSymbol> scanModulePath(Symbol.ModuleSymbol moduleSymbol) {
        ListBuffer<Symbol.ModuleSymbol> listBuffer = new ListBuffer<Symbol.ModuleSymbol>();
        HashMap<Name, JavaFileManager.Location> hashMap = new HashMap<Name, JavaFileManager.Location>();
        boolean bl = this.fileManager.hasLocation(StandardLocation.MODULE_SOURCE_PATH);
        while (this.moduleLocationIterator.hasNext()) {
            Object object = this.moduleLocationIterator.next();
            hashMap.clear();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                JavaFileManager.Location location = (JavaFileManager.Location)iterator.next();
                try {
                    Name name = this.names.fromString(this.fileManager.inferModuleName(location));
                    if (hashMap.put(name, location) == null) {
                        Symbol.ModuleSymbol moduleSymbol2 = this.syms.enterModule(name);
                        if (moduleSymbol2.sourceLocation != null || moduleSymbol2.classLocation != null) continue;
                        if (this.fileManager.hasLocation(StandardLocation.PATCH_MODULE_PATH) && moduleSymbol2.patchLocation == null) {
                            moduleSymbol2.patchLocation = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.PATCH_MODULE_PATH, moduleSymbol2.name.toString());
                            if (moduleSymbol2.patchLocation != null && bl && this.fileManager.hasLocation(StandardLocation.CLASS_OUTPUT)) {
                                moduleSymbol2.patchOutputLocation = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, moduleSymbol2.name.toString());
                            }
                        }
                        if (this.moduleLocationIterator.outer == StandardLocation.MODULE_SOURCE_PATH) {
                            moduleSymbol2.sourceLocation = location;
                            if (this.fileManager.hasLocation(StandardLocation.CLASS_OUTPUT)) {
                                moduleSymbol2.classLocation = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, moduleSymbol2.name.toString());
                            }
                        } else {
                            moduleSymbol2.classLocation = location;
                        }
                        if (this.moduleLocationIterator.outer == StandardLocation.SYSTEM_MODULES || this.moduleLocationIterator.outer == StandardLocation.UPGRADE_MODULE_PATH) {
                            moduleSymbol2.flags_field |= 0x20000000000000L;
                        }
                        if (moduleSymbol != null && (moduleSymbol != moduleSymbol2 || moduleSymbol2.sourceLocation == null && moduleSymbol2.classLocation == null)) continue;
                        listBuffer.add(moduleSymbol2);
                        continue;
                    }
                    this.log.error(CompilerProperties.Errors.DuplicateModuleOnPath(this.getDescription(this.moduleLocationIterator.outer), name));
                }
                catch (IOException iOException) {}
            }
            if (moduleSymbol == null || !listBuffer.nonEmpty()) continue;
            return listBuffer.toList();
        }
        return listBuffer.toList();
    }

    private void findModuleInfo(final Symbol.ModuleSymbol moduleSymbol) {
        try {
            JavaFileObject javaFileObject = this.getModuleInfoFromLocation(moduleSymbol.patchOutputLocation, JavaFileObject.Kind.CLASS);
            javaFileObject = this.preferredFileObject(this.getModuleInfoFromLocation(moduleSymbol.patchLocation, JavaFileObject.Kind.CLASS), javaFileObject);
            javaFileObject = this.preferredFileObject(this.getModuleInfoFromLocation(moduleSymbol.patchLocation, JavaFileObject.Kind.SOURCE), javaFileObject);
            if (javaFileObject == null) {
                javaFileObject = this.getModuleInfoFromLocation(moduleSymbol.classLocation, JavaFileObject.Kind.CLASS);
                javaFileObject = this.preferredFileObject(this.getModuleInfoFromLocation(moduleSymbol.sourceLocation, JavaFileObject.Kind.SOURCE), javaFileObject);
            }
            if (javaFileObject == null) {
                String string;
                String string2 = string = moduleSymbol.sourceLocation == null && moduleSymbol.classLocation != null ? this.fileManager.inferModuleName(moduleSymbol.classLocation) : null;
                if (string != null) {
                    moduleSymbol.module_info.classfile = null;
                    moduleSymbol.flags_field |= 0x10000000000000L;
                } else {
                    moduleSymbol.kind = Kinds.Kind.ERR;
                }
            } else {
                moduleSymbol.module_info.classfile = javaFileObject;
                moduleSymbol.module_info.completer = new Symbol.Completer(){

                    @Override
                    public void complete(Symbol symbol) throws Symbol.CompletionFailure {
                        ModuleFinder.this.classFinder.fillIn(moduleSymbol.module_info);
                    }

                    public String toString() {
                        return "ModuleInfoCompleter";
                    }
                };
            }
        }
        catch (IOException iOException) {
            moduleSymbol.kind = Kinds.Kind.ERR;
        }
    }

    private JavaFileObject preferredFileObject(JavaFileObject javaFileObject, JavaFileObject javaFileObject2) {
        if (javaFileObject == null) {
            return javaFileObject2;
        }
        if (javaFileObject2 == null) {
            return javaFileObject;
        }
        return this.classFinder.preferredFileObject(javaFileObject, javaFileObject2);
    }

    JCDiagnostic.Fragment getDescription(StandardLocation standardLocation) {
        switch (standardLocation) {
            case MODULE_PATH: {
                return CompilerProperties.Fragments.LocnModule_path;
            }
            case MODULE_SOURCE_PATH: {
                return CompilerProperties.Fragments.LocnModule_source_path;
            }
            case SYSTEM_MODULES: {
                return CompilerProperties.Fragments.LocnSystem_modules;
            }
            case UPGRADE_MODULE_PATH: {
                return CompilerProperties.Fragments.LocnUpgrade_module_path;
            }
        }
        throw new AssertionError();
    }

    public static interface ModuleNameFromSourceReader {
        public Name readModuleName(JavaFileObject var1);
    }

    class ModuleLocationIterator
    implements Iterator<Set<JavaFileManager.Location>> {
        StandardLocation outer;
        Set<JavaFileManager.Location> next = null;
        Iterator<StandardLocation> outerIter = Arrays.asList(StandardLocation.MODULE_SOURCE_PATH, StandardLocation.UPGRADE_MODULE_PATH, StandardLocation.SYSTEM_MODULES, StandardLocation.MODULE_PATH).iterator();
        Iterator<Set<JavaFileManager.Location>> innerIter = null;

        ModuleLocationIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                while (this.innerIter == null || !this.innerIter.hasNext()) {
                    if (this.outerIter.hasNext()) {
                        this.outer = this.outerIter.next();
                        try {
                            this.innerIter = ModuleFinder.this.fileManager.listLocationsForModules(this.outer).iterator();
                        }
                        catch (IOException iOException) {
                            System.err.println("error listing module locations for " + this.outer + ": " + iOException);
                        }
                        continue;
                    }
                    return false;
                }
                if (!this.innerIter.hasNext()) continue;
                this.next = this.innerIter.next();
            }
            return true;
        }

        @Override
        public Set<JavaFileManager.Location> next() {
            this.hasNext();
            if (this.next != null) {
                Set<JavaFileManager.Location> set = this.next;
                this.next = null;
                return set;
            }
            throw new NoSuchElementException();
        }
    }
}

