/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.io.Serializable;

@BugPattern(name="NoFunctionalReturnType", summary="Instead of returning a functional type, return the actual type that the returned function would return and use lambdas at use site.", explanation="Returning the actual type that the returned function would return instead of a functional type creates a more versatile method", severity=BugPattern.SeverityLevel.WARNING)
public final class NoFunctionalReturnType
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<MethodTree> FUNCTIONAL_RETURN_TYPE = Matchers.methodReturns((Matcher & Serializable)(tree, state) -> ASTHelpers.getType((Tree)tree).tsym.packge().fullname.contentEquals("java.util.function"));

    public Description matchMethod(MethodTree tree, VisitorState state) {
        return FUNCTIONAL_RETURN_TYPE.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

