/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.options;

import com.sun.tools.sjavac.Module;
import com.sun.tools.sjavac.ProblemException;
import com.sun.tools.sjavac.Source;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SourceLocation {
    private Path path;
    List<String> includes;
    List<String> excludes;

    public SourceLocation(Path path, List<String> includes, List<String> excludes) {
        this.path = path;
        this.includes = includes;
        this.excludes = excludes;
    }

    public void findSourceFiles(Set<String> suffixes, Map<String, Source> foundFiles, Map<String, Module> foundModules, Module currentModule, boolean permitSourcesInDefaultPackage, boolean inLinksrc) throws IOException {
        try {
            Source.scanRoot(this.path.toFile(), suffixes, this.excludes, this.includes, foundFiles, foundModules, currentModule, permitSourcesInDefaultPackage, false, inLinksrc);
        }
        catch (ProblemException e) {
            e.printStackTrace();
        }
    }

    public Path getPath() {
        return this.path;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public String toString() {
        return String.format("%s[\"%s\", includes: %s, excludes: %s]", this.getClass().getSimpleName(), this.path, this.includes, this.excludes);
    }
}

