/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import javax.lang.model.element.Name;

@BugPattern(name="VarTypeName", summary="`var` should not be used as a type name.", severity=BugPattern.SeverityLevel.ERROR)
public class VarTypeName
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.TypeParameterTreeMatcher {
    public Description matchClass(ClassTree tree, VisitorState state) {
        return this.check(tree, tree.getSimpleName());
    }

    public Description matchTypeParameter(TypeParameterTree tree, VisitorState state) {
        return this.check(tree, tree.getName());
    }

    private Description check(Tree tree, Name name) {
        return name.contentEquals("var") ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

