/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.cfg;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.StringJoiner;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.analysis.AbstractValue;
import org.checkerframework.shaded.dataflow.analysis.Analysis;
import org.checkerframework.shaded.dataflow.analysis.Store;
import org.checkerframework.shaded.dataflow.analysis.TransferFunction;
import org.checkerframework.shaded.dataflow.analysis.TransferInput;
import org.checkerframework.shaded.dataflow.cfg.CFGVisualizer;
import org.checkerframework.shaded.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.shaded.dataflow.cfg.block.Block;
import org.checkerframework.shaded.dataflow.cfg.block.ConditionalBlock;
import org.checkerframework.shaded.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.shaded.dataflow.cfg.block.RegularBlock;
import org.checkerframework.shaded.dataflow.cfg.block.SingleSuccessorBlock;
import org.checkerframework.shaded.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.shaded.dataflow.cfg.node.Node;

public abstract class AbstractCFGVisualizer<A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>>
implements CFGVisualizer<A, S, T> {
    protected boolean verbose;
    protected final String lineSeparator = System.lineSeparator();
    protected final String storeEntryIndent = "  ";

    @Override
    public void init(Map<String, Object> args) {
        Object verb = args.get("verbose");
        this.verbose = verb != null && (verb instanceof String ? Boolean.parseBoolean((String)verb) : (Boolean)verb != false);
    }

    protected String visualizeGraph(ControlFlowGraph cfg, Block entry, @Nullable Analysis<A, S, T> analysis) {
        return this.visualizeGraphHeader() + this.visualizeGraphWithoutHeaderAndFooter(cfg, entry, analysis) + this.visualizeGraphFooter();
    }

    protected String visualizeGraphWithoutHeaderAndFooter(ControlFlowGraph cfg, Block entry, @Nullable Analysis<A, S, T> analysis) {
        HashSet<Block> visited = new HashSet<Block>();
        StringBuilder sbGraph = new StringBuilder();
        ArrayDeque<Block> workList = new ArrayDeque<Block>();
        Block cur = entry;
        visited.add(entry);
        while (cur != null) {
            this.handleSuccessorsHelper(cur, visited, workList, sbGraph);
            cur = (Block)workList.poll();
        }
        sbGraph.append(this.visualizeNodes(visited, cfg, analysis));
        return sbGraph.toString();
    }

    protected void handleSuccessorsHelper(Block cur, Set<Block> visited, Queue<Block> workList, StringBuilder sbGraph) {
        if (cur.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
            ConditionalBlock ccur = (ConditionalBlock)cur;
            Block thenSuccessor = ccur.getThenSuccessor();
            sbGraph.append(this.addEdge(ccur.getId(), thenSuccessor.getId(), ccur.getThenFlowRule().toString()));
            this.addBlock(thenSuccessor, visited, workList);
            Block elseSuccessor = ccur.getElseSuccessor();
            sbGraph.append(this.addEdge(ccur.getId(), elseSuccessor.getId(), ccur.getElseFlowRule().toString()));
            this.addBlock(elseSuccessor, visited, workList);
        } else {
            SingleSuccessorBlock sscur = (SingleSuccessorBlock)cur;
            Block succ = sscur.getSuccessor();
            if (succ != null) {
                sbGraph.append(this.addEdge(cur.getId(), succ.getId(), sscur.getFlowRule().name()));
                this.addBlock(succ, visited, workList);
            }
        }
        if (cur.getType() == Block.BlockType.EXCEPTION_BLOCK) {
            ExceptionBlock ecur = (ExceptionBlock)cur;
            for (Map.Entry<TypeMirror, Set<Block>> e : ecur.getExceptionalSuccessors().entrySet()) {
                TypeMirror cause = e.getKey();
                String exception = cause.toString();
                if (exception.startsWith("java.lang.")) {
                    exception = exception.replace("java.lang.", "");
                }
                for (Block b : e.getValue()) {
                    sbGraph.append(this.addEdge(cur.getId(), b.getId(), exception));
                    this.addBlock(b, visited, workList);
                }
            }
        }
    }

    protected void addBlock(Block b, Set<Block> visited, Queue<Block> workList) {
        if (!visited.contains(b)) {
            visited.add(b);
            workList.add(b);
        }
    }

    protected String visualizeBlockHelper(Block bb, @Nullable Analysis<A, S, T> analysis, String escapeString) {
        StringBuilder sbBlock = new StringBuilder();
        sbBlock.append(this.loopOverBlockContents(bb, analysis, escapeString));
        boolean centered = false;
        if (sbBlock.length() == 0) {
            if (bb.getType() == Block.BlockType.SPECIAL_BLOCK) {
                sbBlock.append(this.visualizeSpecialBlock((SpecialBlock)bb));
                centered = true;
            } else {
                return "";
            }
        }
        if (analysis != null) {
            Node lastNode;
            sbBlock.insert(0, this.visualizeBlockTransferInput(bb, analysis));
            if (this.verbose && (lastNode = this.getLastNode(bb)) != null) {
                S store = analysis.getResult().getStoreAfter(lastNode);
                StringBuilder sbStore = new StringBuilder();
                sbStore.append(escapeString).append("~~~~~~~~~").append(escapeString);
                sbStore.append("After: ");
                if (store != null) {
                    sbStore.append(this.visualizeStore(store));
                } else {
                    sbStore.append("null store");
                }
                sbBlock.append((CharSequence)sbStore);
            }
        }
        if (!centered) {
            sbBlock.append(escapeString);
        }
        return sbBlock.toString();
    }

    protected String loopOverBlockContents(Block bb, @Nullable Analysis<A, S, T> analysis, String separator) {
        List<Node> contents = this.addBlockContent(bb);
        StringJoiner sjBlockContents = new StringJoiner(separator);
        for (Node t : contents) {
            sjBlockContents.add(this.visualizeBlockNode(t, analysis));
        }
        return sjBlockContents.toString();
    }

    protected List<Node> addBlockContent(Block bb) {
        switch (bb.getType()) {
            case REGULAR_BLOCK: {
                return ((RegularBlock)bb).getContents();
            }
            case EXCEPTION_BLOCK: {
                return Collections.singletonList(((ExceptionBlock)bb).getNode());
            }
            case CONDITIONAL_BLOCK: {
                return Collections.emptyList();
            }
            case SPECIAL_BLOCK: {
                return Collections.emptyList();
            }
        }
        throw new Error("Unrecognized basic block type: " + (Object)((Object)bb.getType()));
    }

    protected String visualizeBlockTransferInputHelper(Block bb, Analysis<A, S, T> analysis, String escapeString) {
        assert (analysis != null) : "analysis should be non-null when visualizing the transfer input of a block.";
        TransferInput<A, S> input = analysis.getInput(bb);
        assert (input != null) : "@AssumeAssertion(nullness): well-behaved analysis";
        StringBuilder sbStore = new StringBuilder();
        sbStore.append("Before: ");
        if (!input.containsTwoStores()) {
            S regularStore = input.getRegularStore();
            sbStore.append(this.visualizeStore(regularStore));
        } else {
            S thenStore = input.getThenStore();
            sbStore.append("then=");
            sbStore.append(this.visualizeStore(thenStore));
            S elseStore = input.getElseStore();
            sbStore.append(", else=");
            sbStore.append(this.visualizeStore(elseStore));
        }
        sbStore.append(escapeString).append("~~~~~~~~~").append(escapeString);
        return sbStore.toString();
    }

    protected String visualizeSpecialBlockHelper(SpecialBlock sbb, String separator) {
        switch (sbb.getSpecialType()) {
            case ENTRY: {
                return "<entry>" + separator;
            }
            case EXIT: {
                return "<exit>" + separator;
            }
            case EXCEPTIONAL_EXIT: {
                return "<exceptional-exit>" + separator;
            }
        }
        return "";
    }

    protected @Nullable Node getLastNode(Block bb) {
        switch (bb.getType()) {
            case REGULAR_BLOCK: {
                List<Node> blockContents = ((RegularBlock)bb).getContents();
                return blockContents.get(blockContents.size() - 1);
            }
            case EXCEPTION_BLOCK: {
                return ((ExceptionBlock)bb).getNode();
            }
        }
        return null;
    }

    protected IdentityHashMap<Block, List<Integer>> getProcessOrder(ControlFlowGraph cfg) {
        IdentityHashMap<Block, List<Integer>> depthFirstOrder = new IdentityHashMap<Block, List<Integer>>();
        int count = 1;
        for (Block b : cfg.getDepthFirstOrderedBlocks()) {
            depthFirstOrder.computeIfAbsent(b, k -> new ArrayList());
            depthFirstOrder.get(b).add(count++);
        }
        return depthFirstOrder;
    }

    @Override
    public String visualizeStore(S store) {
        return store.visualize(this);
    }

    protected abstract String visualizeNodes(Set<Block> var1, ControlFlowGraph var2, @Nullable Analysis<A, S, T> var3);

    protected abstract String addEdge(long var1, long var3, String var5);

    protected abstract String visualizeGraphHeader();

    protected abstract String visualizeGraphFooter();

    protected String getProcessOrderSimpleString(List<Integer> order) {
        return "Process order: " + order.toString().replaceAll("[\\[\\]]", "");
    }

    protected String getNodeSimpleName(Node t) {
        String name = t.getClass().getSimpleName();
        return name.replace("Node", "");
    }
}

