/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.bound;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.model.TurbineElementType;
import java.lang.annotation.RetentionPolicy;
import java.util.EnumSet;

public class AnnotationMetadata {
    public static final ImmutableSet<TurbineElementType> DEFAULT_TARGETS = AnnotationMetadata.getDefaultElements();
    private final RetentionPolicy retention;
    private final ImmutableSet<TurbineElementType> target;
    private final ClassSymbol repeatable;

    private static ImmutableSet<TurbineElementType> getDefaultElements() {
        EnumSet<TurbineElementType> values = EnumSet.allOf(TurbineElementType.class);
        values.remove((Object)TurbineElementType.TYPE_PARAMETER);
        values.remove((Object)TurbineElementType.TYPE_USE);
        return ImmutableSet.copyOf(values);
    }

    public AnnotationMetadata(RetentionPolicy retention, ImmutableSet<TurbineElementType> annotationTarget, ClassSymbol repeatable) {
        this.retention = (RetentionPolicy)((Object)MoreObjects.firstNonNull((Object)((Object)retention), (Object)((Object)RetentionPolicy.CLASS)));
        this.target = (ImmutableSet)MoreObjects.firstNonNull(annotationTarget, DEFAULT_TARGETS);
        this.repeatable = repeatable;
    }

    public RetentionPolicy retention() {
        return this.retention;
    }

    public ImmutableSet<TurbineElementType> target() {
        return this.target;
    }

    public ClassSymbol repeatable() {
        return this.repeatable;
    }
}

