/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.util.Map;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MapRemoveEntryTester<K, V>
extends AbstractMapTester<K, V> {
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_supportedPresent() {
        MapRemoveEntryTester.assertTrue((boolean)this.getMap().remove(this.k0(), this.v0()));
        this.expectMissing((Map.Entry)this.e0());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemove_supportedPresentKeyWrongValue() {
        MapRemoveEntryTester.assertFalse((boolean)this.getMap().remove(this.k0(), this.v3()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemove_supportedWrongKeyPresentValue() {
        MapRemoveEntryTester.assertFalse((boolean)this.getMap().remove(this.k3(), this.v0()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testRemove_supportedAbsentKeyAbsentValue() {
        MapRemoveEntryTester.assertFalse((boolean)this.getMap().remove(this.k3(), this.v3()));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE}, absent={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testRemove_nullKeyQueriesUnsupported() {
        try {
            MapRemoveEntryTester.assertFalse((boolean)this.getMap().remove(null, this.v3()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE}, absent={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testRemove_nullValueQueriesUnsupported() {
        try {
            MapRemoveEntryTester.assertFalse((boolean)this.getMap().remove(this.k3(), null));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testRemove_unsupportedPresent() {
        try {
            this.getMap().remove(this.k0(), this.v0());
            MapRemoveEntryTester.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    public void testRemove_unsupportedAbsent() {
        try {
            MapRemoveEntryTester.assertFalse((boolean)this.getMap().remove(this.k0(), this.v3()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }
}

