/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Lists;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Iterator;

@BugPattern(name="IterableAndIterator", summary="Class should not implement both `Iterable` and `Iterator`", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class IterableAndIterator
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String ITERABLE = Iterable.class.getCanonicalName();
    private static final String ITERATOR = Iterator.class.getCanonicalName();
    private static final Matcher<Tree> ITERABLE_MATCHER = Matchers.isSubtypeOf((String)ITERABLE);
    private static final Matcher<Tree> ITERATOR_MATCHER = Matchers.isSubtypeOf((String)ITERATOR);
    private static final Matcher<Tree> ITERABLE_AND_ITERATOR_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{ITERABLE_MATCHER, ITERATOR_MATCHER});

    private boolean matchAnySuperType(ClassTree tree, VisitorState state) {
        ArrayList superTypes = Lists.newArrayList(tree.getImplementsClause());
        Tree superClass = tree.getExtendsClause();
        if (superClass != null) {
            superTypes.add(superClass);
        }
        return superTypes.stream().anyMatch(superType -> ITERABLE_AND_ITERATOR_MATCHER.matches(superType, state));
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (ITERABLE_AND_ITERATOR_MATCHER.matches((Tree)tree, state)) {
            if (this.matchAnySuperType(tree, state)) {
                return Description.NO_MATCH;
            }
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

