/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.bugpatterns.AutoValue_ChainedAssertionLosesContext_FactoryMethodName;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.ImplementAssertionWithChaining;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;

@BugPattern(name="ChainedAssertionLosesContext", summary="Inside a Subject, use check(...) instead of assert*() to preserve user-supplied messages and other settings.", severity=BugPattern.SeverityLevel.WARNING)
public final class ChainedAssertionLosesContext
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String TRUTH_CLASS = "com.google.common.truth.Truth";
    private static final String PROTO_TRUTH_CLASS = "com.google.common.truth.extensions.proto.ProtoTruth";
    private static final String SUBJECT_CLASS = "com.google.common.truth.Subject";
    private static final String SUBJECT_FACTORY_CLASS = "com.google.common.truth.Subject.Factory";
    private static final String CUSTOM_SUBJECT_BUILDER_FACTORY_CLASS = "com.google.common.truth.CustomSubjectBuilder.Factory";
    private static final Matcher<ExpressionTree> STANDARD_ASSERT_THAT = Matchers.staticMethod().onClass("com.google.common.truth.Truth").named("assertThat");
    private static final Matcher<ExpressionTree> ANY_ASSERT_THAT = Matchers.staticMethod().anyClass().named("assertThat");
    private static final Matcher<ExpressionTree> ASSERT_ABOUT = Matchers.staticMethod().onClass("com.google.common.truth.Truth").named("assertAbout");
    private static final Matcher<ExpressionTree> ASSERT_WITH_MESSAGE = Matchers.staticMethod().onClass("com.google.common.truth.Truth").named("assertWithMessage");
    private static final Matcher<ExpressionTree> ASSERT = Matchers.staticMethod().onClass("com.google.common.truth.Truth").named("assert_");
    private static final Matcher<ExpressionTree> SUBJECT_BUILDER_THAT = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("com.google.common.truth.CustomSubjectBuilder").named("that"), Matchers.instanceMethod().onDescendantOf("com.google.common.truth.SimpleSubjectBuilder").named("that"), Matchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("that")});
    private static final Matcher<ExpressionTree> WITH_MESSAGE_OR_ABOUT = Matchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").namedAnyOf(new String[]{"withMessage", "about"});
    private static final Supplier<Type> COM_GOOGLE_COMMON_TRUTH_SUBJECT = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString(SUBJECT_CLASS));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!ChainedAssertionLosesContext.inInstanceMethodOfSubjectImplementation(state)) {
            return Description.NO_MATCH;
        }
        if (STANDARD_ASSERT_THAT.matches((Tree)tree, state)) {
            String checkDescription = ImplementAssertionWithChaining.makeCheckDescription((ExpressionTree)Iterables.getOnlyElement(tree.getArguments()), state);
            if (checkDescription == null) {
                return Description.NO_MATCH;
            }
            return this.replace(tree.getMethodSelect(), "check(%s).that", checkDescription);
        }
        if (ANY_ASSERT_THAT.matches((Tree)tree, state)) {
            FactoryMethodName factory = ChainedAssertionLosesContext.tryFindFactory(tree, state);
            if (factory == null) {
                return Description.NO_MATCH;
            }
            if (tree.getArguments().size() != 1) {
                return Description.NO_MATCH;
            }
            String checkDescription = ImplementAssertionWithChaining.makeCheckDescription((ExpressionTree)Iterables.getOnlyElement(tree.getArguments()), state);
            if (checkDescription == null) {
                return Description.NO_MATCH;
            }
            return this.describeMatch(tree, (Fix)SuggestedFix.builder().addStaticImport(factory.clazz() + "." + factory.method()).replace((Tree)tree.getMethodSelect(), String.format("check(%s).about(%s()).that", checkDescription, factory.method())).build());
        }
        if (ASSERT_ABOUT.matches((Tree)tree, state)) {
            String checkDescription = ChainedAssertionLosesContext.findThatCallAndMakeCheckDescription(state);
            if (checkDescription == null) {
                return Description.NO_MATCH;
            }
            return this.replace(tree.getMethodSelect(), "check(%s).about", checkDescription);
        }
        if (ASSERT_WITH_MESSAGE.matches((Tree)tree, state)) {
            String checkDescription = ChainedAssertionLosesContext.findThatCallAndMakeCheckDescription(state);
            if (checkDescription == null) {
                return Description.NO_MATCH;
            }
            return this.replace(tree.getMethodSelect(), "check(%s).withMessage", checkDescription);
        }
        if (ASSERT.matches((Tree)tree, state)) {
            String checkDescription = ChainedAssertionLosesContext.findThatCallAndMakeCheckDescription(state);
            if (checkDescription == null) {
                return Description.NO_MATCH;
            }
            return this.replace(tree, "check(%s)", checkDescription);
        }
        return Description.NO_MATCH;
    }

    @Nullable
    static MethodInvocationTree findThatCall(VisitorState state) {
        Tree leaf;
        MethodInvocationTree maybeThatCall;
        TreePath path = state.getPath();
        do {
            if ((leaf = (path = path.getParentPath().getParentPath()).getLeaf()).getKind() == Tree.Kind.METHOD_INVOCATION) continue;
            return null;
        } while (WITH_MESSAGE_OR_ABOUT.matches((Tree)(maybeThatCall = (MethodInvocationTree)leaf), state));
        if (SUBJECT_BUILDER_THAT.matches((Tree)maybeThatCall, state)) {
            return maybeThatCall;
        }
        return null;
    }

    @FormatMethod
    private Description replace(Tree tree, String format, Object ... args) {
        return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)String.format(format, args)));
    }

    @Nullable
    private static FactoryMethodName tryFindFactory(MethodInvocationTree assertThatCall, VisitorState state) {
        Symbol.MethodSymbol assertThatSymbol = ASTHelpers.getSymbol((MethodInvocationTree)assertThatCall);
        if (assertThatSymbol == null) {
            return null;
        }
        if (assertThatSymbol.owner.getQualifiedName().contentEquals(PROTO_TRUTH_CLASS)) {
            return FactoryMethodName.create(PROTO_TRUTH_CLASS, "protos");
        }
        ImmutableSet factories = (ImmutableSet)Stream.concat(assertThatSymbol.owner.getEnclosedElements().stream(), assertThatSymbol.getReturnType().asElement().getEnclosedElements().stream()).filter(s -> s instanceof Symbol.MethodSymbol).map(s -> (Symbol.MethodSymbol)s).filter(s -> ChainedAssertionLosesContext.returns(s, SUBJECT_FACTORY_CLASS, state) || ChainedAssertionLosesContext.returns(s, CUSTOM_SUBJECT_BUILDER_FACTORY_CLASS, state)).collect(ImmutableSet.toImmutableSet());
        return factories.size() == 1 ? FactoryMethodName.tryCreate((Symbol.MethodSymbol)Iterables.getOnlyElement((Iterable)factories)) : null;
    }

    private static boolean returns(Symbol.MethodSymbol symbol, String returnType, VisitorState state) {
        return ASTHelpers.isSubtype((Type)symbol.getReturnType(), (Type)state.getTypeFromString(returnType), (VisitorState)state);
    }

    private static boolean inInstanceMethodOfSubjectImplementation(VisitorState state) {
        TreePath pathToEnclosingMethod = state.findPathToEnclosing(new Class[]{MethodTree.class});
        if (pathToEnclosingMethod == null) {
            return false;
        }
        MethodTree enclosingMethod = (MethodTree)pathToEnclosingMethod.getLeaf();
        if (enclosingMethod.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
            return false;
        }
        Tree enclosingClass = pathToEnclosingMethod.getParentPath().getLeaf();
        if (enclosingClass == null || enclosingClass.getKind() != Tree.Kind.CLASS) {
            return false;
        }
        return ASTHelpers.isSubtype((Type)ASTHelpers.getDeclaredSymbol((Tree)enclosingClass).type, (Type)((Type)COM_GOOGLE_COMMON_TRUTH_SUBJECT.get(state)), (VisitorState)state);
    }

    @Nullable
    private static String findThatCallAndMakeCheckDescription(VisitorState state) {
        MethodInvocationTree thatCall = ChainedAssertionLosesContext.findThatCall(state);
        if (thatCall == null) {
            return null;
        }
        return ImplementAssertionWithChaining.makeCheckDescription((ExpressionTree)Iterables.getOnlyElement(thatCall.getArguments()), state);
    }

    @AutoValue
    static abstract class FactoryMethodName {
        FactoryMethodName() {
        }

        static FactoryMethodName create(String clazz, String method) {
            return new AutoValue_ChainedAssertionLosesContext_FactoryMethodName(clazz, method);
        }

        @Nullable
        static FactoryMethodName tryCreate(Symbol.MethodSymbol symbol) {
            return symbol.params.isEmpty() ? FactoryMethodName.create(symbol.owner.getQualifiedName().toString(), ((Name)symbol.getSimpleName()).toString()) : null;
        }

        abstract String clazz();

        abstract String method();
    }
}

