/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.apply;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.patch.Patch;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.errorprone.apply.FileDestination;
import com.google.errorprone.apply.SourceFile;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class PatchFileDestination
implements FileDestination {
    private static final Splitter LINE_SPLITTER = Splitter.on((char)'\n');
    private final Path baseDir;
    private final Path rootPath;
    private final Map<URI, String> diffByFile = new TreeMap<URI, String>();

    public PatchFileDestination(Path baseDir, Path rootPath) {
        this.baseDir = baseDir;
        this.rootPath = rootPath;
    }

    @Override
    public void writeFile(SourceFile update) throws IOException {
        String newSource;
        Path sourceFilePath = this.rootPath.resolve(update.getPath());
        String oldSource = new String(Files.readAllBytes(sourceFilePath), StandardCharsets.UTF_8);
        if (!oldSource.equals(newSource = update.getSourceText())) {
            List originalLines = LINE_SPLITTER.splitToList((CharSequence)oldSource);
            Patch diff = null;
            try {
                diff = DiffUtils.diff((List)originalLines, (List)LINE_SPLITTER.splitToList((CharSequence)newSource));
            }
            catch (DiffException e) {
                throw new AssertionError("DiffUtils.diff should not fail", e);
            }
            String relativePath = this.baseDir.relativize(sourceFilePath).toString();
            List unifiedDiff = UnifiedDiffUtils.generateUnifiedDiff((String)relativePath, (String)relativePath, (List)originalLines, (Patch)diff, (int)2);
            String diffString = Joiner.on((String)"\n").join((Iterable)unifiedDiff) + "\n";
            this.diffByFile.put(sourceFilePath.toUri(), diffString);
        }
    }

    public String patchFile(URI uri) {
        return this.diffByFile.remove(uri);
    }

    @Override
    public void flush() throws IOException {
    }
}

