/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.extensions.proto.AutoValue_UnknownFieldDescriptor;
import com.google.protobuf.UnknownFieldSet;
import java.util.List;

@AutoValue
abstract class UnknownFieldDescriptor {
    UnknownFieldDescriptor() {
    }

    static UnknownFieldDescriptor create(int fieldNumber, Type type) {
        return new AutoValue_UnknownFieldDescriptor(fieldNumber, type);
    }

    abstract int fieldNumber();

    abstract Type type();

    static ImmutableList<UnknownFieldDescriptor> descriptors(int fieldNumber, UnknownFieldSet.Field field) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Type type : Type.all()) {
            if (type.getValues(field).isEmpty()) continue;
            builder.add((Object)UnknownFieldDescriptor.create(fieldNumber, type));
        }
        return builder.build();
    }

    static enum Type {
        VARINT(0){

            @Override
            public List<?> getValues(UnknownFieldSet.Field field) {
                return field.getVarintList();
            }
        }
        ,
        FIXED32(5){

            @Override
            public List<?> getValues(UnknownFieldSet.Field field) {
                return field.getFixed32List();
            }
        }
        ,
        FIXED64(1){

            @Override
            public List<?> getValues(UnknownFieldSet.Field field) {
                return field.getFixed64List();
            }
        }
        ,
        LENGTH_DELIMITED(2){

            @Override
            public List<?> getValues(UnknownFieldSet.Field field) {
                return field.getLengthDelimitedList();
            }
        }
        ,
        GROUP(3){

            @Override
            public List<?> getValues(UnknownFieldSet.Field field) {
                return field.getGroupList();
            }
        };

        private static final ImmutableList<Type> TYPES;
        private final int wireType;

        static ImmutableList<Type> all() {
            return TYPES;
        }

        private Type(int wireType) {
            this.wireType = wireType;
        }

        abstract List<?> getValues(UnknownFieldSet.Field var1);

        final int wireType() {
            return this.wireType;
        }

        static {
            TYPES = ImmutableList.copyOf((Object[])Type.values());
        }
    }
}

