/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

@BugPattern(name="ForOverride", summary="Method annotated @ForOverride must be protected or package-private and only invoked from declaring class, or from an override of the method", severity=BugPattern.SeverityLevel.ERROR)
public class ForOverrideChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MethodTreeMatcher {
    private static final String FOR_OVERRIDE = "com.google.errorprone.annotations.ForOverride";
    private static final String MESSAGE_BASE = "Method annotated @ForOverride ";

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol currentMethodSymbol;
        MethodTree currentMethod;
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        Type currentClass = ForOverrideChecker.getOutermostClass(state);
        if (method.isStatic() || method.isConstructor() || currentClass == null) {
            return Description.NO_MATCH;
        }
        if (ForOverrideChecker.isSuperCall(currentClass, tree, state) && (currentMethod = ForOverrideChecker.findDirectMethod(state.getPath())) != null && currentMethod.getName().equals(method.name) && (currentMethodSymbol = ASTHelpers.getSymbol((MethodTree)currentMethod)).overrides(method, (Symbol.TypeSymbol)method.owner, state.getTypes(), true)) {
            return Description.NO_MATCH;
        }
        ImmutableList<Symbol.MethodSymbol> overriddenMethods = ForOverrideChecker.getOverriddenMethods(state, method);
        for (Symbol overriddenMethod : overriddenMethods) {
            TypeMirror declaringClass = ASTHelpers.outermostClass((Symbol)overriddenMethod).asType();
            if (ASTHelpers.isSameType((Type)declaringClass, (Type)currentClass, (VisitorState)state)) continue;
            String customMessage = "Method annotated @ForOverride must not be invoked directly (except by the declaring class, " + (Type)declaringClass + ")";
            return this.buildDescription(tree).setMessage(customMessage).build();
        }
        return Description.NO_MATCH;
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        ImmutableList<Symbol.MethodSymbol> overriddenMethods;
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodTree)tree);
        if (method.isStatic() || method.isConstructor()) {
            return Description.NO_MATCH;
        }
        if ((method.getModifiers().contains((Object)Modifier.PUBLIC) || method.getModifiers().contains((Object)Modifier.PRIVATE)) && !(overriddenMethods = ForOverrideChecker.getOverriddenMethods(state, method)).isEmpty()) {
            Symbol.MethodSymbol nearestForOverrideMethod = (Symbol.MethodSymbol)overriddenMethods.get(0);
            Object customMessage = "must have protected or package-private visibility";
            customMessage = nearestForOverrideMethod.equals(method) ? MESSAGE_BASE + (String)customMessage : String.format("Method overrides @ForOverride method %s.%s, so it %s", nearestForOverrideMethod.enclClass(), nearestForOverrideMethod, customMessage);
            return this.buildDescription(tree).setMessage((String)customMessage).build();
        }
        return Description.NO_MATCH;
    }

    @Nullable
    private static MethodTree findDirectMethod(TreePath path) {
        while ((path = path.getParentPath()) != null) {
            Tree leaf = path.getLeaf();
            if (leaf instanceof MethodTree) {
                return (MethodTree)leaf;
            }
            if (!(leaf instanceof ClassTree)) continue;
            return null;
        }
        return null;
    }

    private static boolean isSuperCall(Type type, MethodInvocationTree tree, VisitorState state) {
        if (tree.getMethodSelect().getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree select = (MemberSelectTree)tree.getMethodSelect();
            if (select.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                IdentifierTree ident = (IdentifierTree)select.getExpression();
                return ident.getName().contentEquals("super");
            }
            if (select.getExpression().getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree subSelect = (MemberSelectTree)select.getExpression();
                return subSelect.getIdentifier().contentEquals("super") && ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)subSelect.getExpression()), (Type)type, (VisitorState)state);
            }
        }
        return false;
    }

    private static ImmutableList<Symbol.MethodSymbol> getOverriddenMethods(VisitorState state, Symbol.MethodSymbol method) {
        if (method.isStatic()) {
            throw new IllegalArgumentException("getOverriddenMethods may not be called on a static method");
        }
        return (ImmutableList)Stream.concat(Stream.of(method), ASTHelpers.streamSuperMethods((Symbol.MethodSymbol)method, (Types)state.getTypes())).filter(member -> ASTHelpers.hasAnnotation((Symbol)member, (String)FOR_OVERRIDE, (VisitorState)state)).collect(ImmutableList.toImmutableList());
    }

    @Nullable
    private static Type getOutermostClass(VisitorState state) {
        return Streams.findLast(Streams.stream((Iterable)state.getPath()).filter(t -> t instanceof ClassTree).map(t -> ASTHelpers.getType((Tree)t))).orElse(null);
    }
}

