/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.scanner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.SuppressionInfo;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Suppressible;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

@CheckReturnValue
public class Scanner
extends TreePathScanner<Void, VisitorState> {
    private SuppressionInfo currentSuppressions = SuppressionInfo.EMPTY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void scan(TreePath path, VisitorState state) {
        SuppressionInfo prevSuppressionInfo = this.updateSuppressions(path.getLeaf(), state);
        try {
            Void void_ = (Void)super.scan(path, state);
            return void_;
        }
        finally {
            this.currentSuppressions = prevSuppressionInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void scan(Tree tree, VisitorState state) {
        if (tree == null) {
            return null;
        }
        SuppressionInfo prevSuppressionInfo = this.updateSuppressions(tree, state);
        try {
            Void void_ = (Void)super.scan(tree, state);
            return void_;
        }
        finally {
            this.currentSuppressions = prevSuppressionInfo;
        }
    }

    private SuppressionInfo updateSuppressions(Tree tree, VisitorState state) {
        SuppressionInfo prevSuppressionInfo = this.currentSuppressions;
        if (tree instanceof CompilationUnitTree) {
            this.currentSuppressions = this.currentSuppressions.forCompilationUnit((CompilationUnitTree)tree, state);
        } else {
            Symbol sym = ASTHelpers.getDeclaredSymbol(tree);
            if (sym != null) {
                this.currentSuppressions = this.currentSuppressions.withExtendedSuppressions(sym, state, this.getCustomSuppressionAnnotations(state));
            }
        }
        return prevSuppressionInfo;
    }

    protected SuppressionInfo.SuppressedState isSuppressed(Suppressible suppressible, ErrorProneOptions errorProneOptions, VisitorState state) {
        boolean suppressedInGeneratedCode = errorProneOptions.disableWarningsInGeneratedCode() && this.severityMap().get(suppressible.canonicalName()) != BugPattern.SeverityLevel.ERROR;
        return this.currentSuppressions.suppressedState(suppressible, suppressedInGeneratedCode, state);
    }

    protected Set<? extends Name> getCustomSuppressionAnnotations(VisitorState state) {
        return ImmutableSet.of();
    }

    protected void reportMatch(Description description, VisitorState state) {
        Preconditions.checkNotNull((Object)description, (Object)"Use Description.NO_MATCH to denote an absent finding.");
        state.reportMatch(description);
    }

    protected void handleError(Suppressible s, Throwable t) {
    }

    public Map<String, BugPattern.SeverityLevel> severityMap() {
        return Collections.emptyMap();
    }
}

