/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ConstantExpressions;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ForkJoinTask;
import javax.inject.Inject;

@BugPattern(summary="Return value of methods returning Future must be checked. Ignoring returned Futures suppresses exceptions thrown from the code that completes the Future.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"}, documentSuppression=false)
public final class FutureReturnValueIgnored
extends AbstractReturnValueIgnored
implements BugChecker.ReturnTreeMatcher {
    private static final Matcher<ExpressionTree> IGNORED_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf(ForkJoinTask.class.getName()).named("fork").withNoParameters(), MethodMatchers.instanceMethod().onDescendantOf(CompletionService.class.getName()).named("submit"), MethodMatchers.instanceMethod().onDescendantOf("com.intellij.openapi.application.Application").named("executeOnPooledThread"), MethodMatchers.instanceMethod().onDescendantOf("io.netty.util.concurrent.Future").namedAnyOf(new String[]{"addListener", "addListeners", "removeListener", "removeListeners", "sync", "syncUninterruptibly", "await", "awaitUninterruptibly"}), MethodMatchers.instanceMethod().onDescendantOf("io.netty.util.concurrent.Promise").namedAnyOf(new String[]{"setSuccess", "setFailure"}), MethodMatchers.instanceMethod().onExactClass("java.util.concurrent.CompletableFuture").namedAnyOf(new String[]{"exceptionally", "completeAsync", "orTimeout", "completeOnTimeout"})});
    private static final Matcher<ExpressionTree> MATCHER = new Matcher<ExpressionTree>(){

        public boolean matches(ExpressionTree tree, VisitorState state) {
            Type futureType = (Type)JAVA_UTIL_CONCURRENT_FUTURE.get(state);
            if (futureType == null) {
                return false;
            }
            Symbol untypedSymbol = ASTHelpers.getSymbol((Tree)tree);
            if (!(untypedSymbol instanceof Symbol.MethodSymbol)) {
                Type resultType = ASTHelpers.getResultType((ExpressionTree)tree);
                return resultType != null && ASTHelpers.isSubtype((Type)ASTHelpers.getUpperBound((Type)resultType, (Types)state.getTypes()), (Type)futureType, (VisitorState)state);
            }
            Symbol.MethodSymbol sym = (Symbol.MethodSymbol)untypedSymbol;
            if (ASTHelpers.hasAnnotation((Symbol)sym, CanIgnoreReturnValue.class, (VisitorState)state)) {
                return false;
            }
            for (Symbol.MethodSymbol superSym : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)sym, (Types)state.getTypes())) {
                if (!ASTHelpers.hasAnnotation((Symbol)superSym, CanIgnoreReturnValue.class, (VisitorState)state) || !ASTHelpers.isSubtype((Type)ASTHelpers.getUpperBound((Type)superSym.getReturnType(), (Types)state.getTypes()), (Type)futureType, (VisitorState)state)) continue;
                return false;
            }
            if (IGNORED_METHODS.matches((Tree)tree, state)) {
                return false;
            }
            Type returnType = sym.getReturnType();
            return ASTHelpers.isSubtype((Type)ASTHelpers.getUpperBound((Type)returnType, (Types)state.getTypes()), (Type)futureType, (VisitorState)state);
        }
    };
    private final Supplier<Type> futureType = Suppliers.typeFromString((String)"java.util.concurrent.Future");
    private static final Supplier<Type> JAVA_UTIL_CONCURRENT_FUTURE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.util.concurrent.Future"));

    @Inject
    FutureReturnValueIgnored(ConstantExpressions constantExpressions) {
        super(constantExpressions);
    }

    public Matcher<ExpressionTree> specializedMatcher() {
        return MATCHER;
    }

    @Override
    protected Optional<Type> lostType(VisitorState state) {
        return Optional.ofNullable((Type)this.futureType.get(state));
    }

    @Override
    protected String lostTypeMessage(String returnedType, String declaredReturnType) {
        return String.format("Returning %s from method that returns %s. Errors from the returned future may be ignored.", returnedType, declaredReturnType);
    }
}

