/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionUtil;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;

public class CompactCodeAttributeComposer
extends SimplifiedVisitor
implements AttributeVisitor {
    private final ConstantPoolEditor constantPoolEditor;
    private final CodeAttributeComposer codeAttributeComposer;

    public CompactCodeAttributeComposer(ProgramClass targetClass) {
        this(targetClass, false, false, true);
    }

    public CompactCodeAttributeComposer(ProgramClass targetClass, boolean allowExternalBranchTargets, boolean allowExternalExceptionHandlers, boolean shrinkInstructions) {
        this.constantPoolEditor = new ConstantPoolEditor(targetClass);
        this.codeAttributeComposer = new CodeAttributeComposer(allowExternalBranchTargets, allowExternalExceptionHandlers, shrinkInstructions);
    }

    public CompactCodeAttributeComposer reset() {
        this.codeAttributeComposer.reset();
        return this;
    }

    public CompactCodeAttributeComposer beginCodeFragment(int maximumCodeFragmentLength) {
        this.codeAttributeComposer.beginCodeFragment(maximumCodeFragmentLength);
        return this;
    }

    public CompactCodeAttributeComposer appendInstruction(int oldInstructionOffset, Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(oldInstructionOffset, instruction);
        return this;
    }

    public CompactCodeAttributeComposer appendLabel(int oldInstructionOffset) {
        this.codeAttributeComposer.appendLabel(oldInstructionOffset);
        return this;
    }

    public CompactCodeAttributeComposer appendInstructions(Instruction[] instructions) {
        this.codeAttributeComposer.appendInstructions(instructions);
        return this;
    }

    public CompactCodeAttributeComposer appendInstruction(Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(instruction);
        return this;
    }

    public CompactCodeAttributeComposer appendException(ExceptionInfo exceptionInfo) {
        this.codeAttributeComposer.appendException(exceptionInfo);
        return this;
    }

    public int insertLineNumber(LineNumberInfo lineNumberInfo) {
        return this.codeAttributeComposer.insertLineNumber(lineNumberInfo);
    }

    public int insertLineNumber(int minimumIndex, LineNumberInfo lineNumberInfo) {
        return this.codeAttributeComposer.insertLineNumber(minimumIndex, lineNumberInfo);
    }

    public CompactCodeAttributeComposer appendLineNumber(LineNumberInfo lineNumberInfo) {
        this.codeAttributeComposer.appendLineNumber(lineNumberInfo);
        return this;
    }

    public CompactCodeAttributeComposer endCodeFragment() {
        this.codeAttributeComposer.endCodeFragment();
        return this;
    }

    public CompactCodeAttributeComposer nop() {
        return this.add(new SimpleInstruction(0));
    }

    public CompactCodeAttributeComposer aconst_null() {
        return this.add(new SimpleInstruction(1));
    }

    public CompactCodeAttributeComposer iconst(int constant) {
        return this.add(new SimpleInstruction(3, constant));
    }

    public CompactCodeAttributeComposer iconst_m1() {
        return this.add(new SimpleInstruction(2));
    }

    public CompactCodeAttributeComposer iconst_0() {
        return this.add(new SimpleInstruction(3));
    }

    public CompactCodeAttributeComposer iconst_1() {
        return this.add(new SimpleInstruction(4));
    }

    public CompactCodeAttributeComposer iconst_2() {
        return this.add(new SimpleInstruction(5));
    }

    public CompactCodeAttributeComposer iconst_3() {
        return this.add(new SimpleInstruction(6));
    }

    public CompactCodeAttributeComposer iconst_4() {
        return this.add(new SimpleInstruction(7));
    }

    public CompactCodeAttributeComposer iconst_5() {
        return this.add(new SimpleInstruction(8));
    }

    public CompactCodeAttributeComposer lconst(int constant) {
        return this.add(new SimpleInstruction(9, constant));
    }

    public CompactCodeAttributeComposer lconst_0() {
        return this.add(new SimpleInstruction(9));
    }

    public CompactCodeAttributeComposer lconst_1() {
        return this.add(new SimpleInstruction(10));
    }

    public CompactCodeAttributeComposer fconst(int constant) {
        return this.add(new SimpleInstruction(11, constant));
    }

    public CompactCodeAttributeComposer fconst_0() {
        return this.add(new SimpleInstruction(11));
    }

    public CompactCodeAttributeComposer fconst_1() {
        return this.add(new SimpleInstruction(12));
    }

    public CompactCodeAttributeComposer fconst_2() {
        return this.add(new SimpleInstruction(13));
    }

    public CompactCodeAttributeComposer dconst(int constant) {
        return this.add(new SimpleInstruction(14, constant));
    }

    public CompactCodeAttributeComposer dconst_0() {
        return this.add(new SimpleInstruction(14));
    }

    public CompactCodeAttributeComposer dconst_1() {
        return this.add(new SimpleInstruction(15));
    }

    public CompactCodeAttributeComposer bipush(int constant) {
        return this.add(new SimpleInstruction(16, constant));
    }

    public CompactCodeAttributeComposer sipush(int constant) {
        return this.add(new SimpleInstruction(17, constant));
    }

    public CompactCodeAttributeComposer ldc(int value) {
        return this.ldc_(this.constantPoolEditor.addIntegerConstant(value));
    }

    public CompactCodeAttributeComposer ldc(float value) {
        return this.ldc_(this.constantPoolEditor.addFloatConstant(value));
    }

    public CompactCodeAttributeComposer ldc(String string) {
        return this.ldc(string, null, null);
    }

    public CompactCodeAttributeComposer ldc(Object primitiveArray) {
        return this.ldc_(this.constantPoolEditor.addPrimitiveArrayConstant(primitiveArray));
    }

    public CompactCodeAttributeComposer ldc(String string, Clazz referencedClass, Method referencedMember) {
        return this.ldc_(this.constantPoolEditor.addStringConstant(string, referencedClass, referencedMember));
    }

    public CompactCodeAttributeComposer ldc(String className, Clazz referencedClass) {
        return this.ldc_(this.constantPoolEditor.addClassConstant(className, referencedClass));
    }

    public CompactCodeAttributeComposer ldc_(int constantIndex) {
        return this.add(new ConstantInstruction(18, constantIndex));
    }

    public CompactCodeAttributeComposer ldc_w(int value) {
        return this.ldc_w_(this.constantPoolEditor.addIntegerConstant(value));
    }

    public CompactCodeAttributeComposer ldc_w(float value) {
        return this.ldc_w_(this.constantPoolEditor.addFloatConstant(value));
    }

    public CompactCodeAttributeComposer ldc_w(String string) {
        return this.ldc_w(string, null, null);
    }

    public CompactCodeAttributeComposer ldc_w(String string, Clazz referencedClass, Method referencedMember) {
        return this.ldc_w_(this.constantPoolEditor.addStringConstant(string, referencedClass, referencedMember));
    }

    public CompactCodeAttributeComposer ldc_w(String className, Clazz referencedClass) {
        return this.ldc_w_(this.constantPoolEditor.addClassConstant(className, referencedClass));
    }

    public CompactCodeAttributeComposer ldc_w_(int constantIndex) {
        return this.add(new ConstantInstruction(19, constantIndex));
    }

    public CompactCodeAttributeComposer ldc2_w(long value) {
        return this.ldc2_w(this.constantPoolEditor.addLongConstant(value));
    }

    public CompactCodeAttributeComposer ldc2_w(double value) {
        return this.ldc2_w(this.constantPoolEditor.addDoubleConstant(value));
    }

    public CompactCodeAttributeComposer ldc2_w(int constantIndex) {
        return this.add(new ConstantInstruction(20, constantIndex));
    }

    public CompactCodeAttributeComposer iload(int variableIndex) {
        return this.add(new VariableInstruction(21, variableIndex));
    }

    public CompactCodeAttributeComposer lload(int variableIndex) {
        return this.add(new VariableInstruction(22, variableIndex));
    }

    public CompactCodeAttributeComposer fload(int variableIndex) {
        return this.add(new VariableInstruction(23, variableIndex));
    }

    public CompactCodeAttributeComposer dload(int variableIndex) {
        return this.add(new VariableInstruction(24, variableIndex));
    }

    public CompactCodeAttributeComposer aload(int variableIndex) {
        return this.add(new VariableInstruction(25, variableIndex));
    }

    public CompactCodeAttributeComposer iload_0() {
        return this.add(new VariableInstruction(26));
    }

    public CompactCodeAttributeComposer iload_1() {
        return this.add(new VariableInstruction(27));
    }

    public CompactCodeAttributeComposer iload_2() {
        return this.add(new VariableInstruction(28));
    }

    public CompactCodeAttributeComposer iload_3() {
        return this.add(new VariableInstruction(29));
    }

    public CompactCodeAttributeComposer lload_0() {
        return this.add(new VariableInstruction(30));
    }

    public CompactCodeAttributeComposer lload_1() {
        return this.add(new VariableInstruction(31));
    }

    public CompactCodeAttributeComposer lload_2() {
        return this.add(new VariableInstruction(32));
    }

    public CompactCodeAttributeComposer lload_3() {
        return this.add(new VariableInstruction(33));
    }

    public CompactCodeAttributeComposer fload_0() {
        return this.add(new VariableInstruction(34));
    }

    public CompactCodeAttributeComposer fload_1() {
        return this.add(new VariableInstruction(35));
    }

    public CompactCodeAttributeComposer fload_2() {
        return this.add(new VariableInstruction(36));
    }

    public CompactCodeAttributeComposer fload_3() {
        return this.add(new VariableInstruction(37));
    }

    public CompactCodeAttributeComposer dload_0() {
        return this.add(new VariableInstruction(38));
    }

    public CompactCodeAttributeComposer dload_1() {
        return this.add(new VariableInstruction(39));
    }

    public CompactCodeAttributeComposer dload_2() {
        return this.add(new VariableInstruction(40));
    }

    public CompactCodeAttributeComposer dload_3() {
        return this.add(new VariableInstruction(41));
    }

    public CompactCodeAttributeComposer aload_0() {
        return this.add(new VariableInstruction(42));
    }

    public CompactCodeAttributeComposer aload_1() {
        return this.add(new VariableInstruction(43));
    }

    public CompactCodeAttributeComposer aload_2() {
        return this.add(new VariableInstruction(44));
    }

    public CompactCodeAttributeComposer aload_3() {
        return this.add(new VariableInstruction(45));
    }

    public CompactCodeAttributeComposer iaload() {
        return this.add(new SimpleInstruction(46));
    }

    public CompactCodeAttributeComposer laload() {
        return this.add(new SimpleInstruction(47));
    }

    public CompactCodeAttributeComposer faload() {
        return this.add(new SimpleInstruction(48));
    }

    public CompactCodeAttributeComposer daload() {
        return this.add(new SimpleInstruction(49));
    }

    public CompactCodeAttributeComposer aaload() {
        return this.add(new SimpleInstruction(50));
    }

    public CompactCodeAttributeComposer baload() {
        return this.add(new SimpleInstruction(51));
    }

    public CompactCodeAttributeComposer caload() {
        return this.add(new SimpleInstruction(52));
    }

    public CompactCodeAttributeComposer saload() {
        return this.add(new SimpleInstruction(53));
    }

    public CompactCodeAttributeComposer istore(int variableIndex) {
        return this.add(new VariableInstruction(54, variableIndex));
    }

    public CompactCodeAttributeComposer lstore(int variableIndex) {
        return this.add(new VariableInstruction(55, variableIndex));
    }

    public CompactCodeAttributeComposer fstore(int variableIndex) {
        return this.add(new VariableInstruction(56, variableIndex));
    }

    public CompactCodeAttributeComposer dstore(int variableIndex) {
        return this.add(new VariableInstruction(57, variableIndex));
    }

    public CompactCodeAttributeComposer astore(int variableIndex) {
        return this.add(new VariableInstruction(58, variableIndex));
    }

    public CompactCodeAttributeComposer istore_0() {
        return this.add(new VariableInstruction(59));
    }

    public CompactCodeAttributeComposer istore_1() {
        return this.add(new VariableInstruction(60));
    }

    public CompactCodeAttributeComposer istore_2() {
        return this.add(new VariableInstruction(61));
    }

    public CompactCodeAttributeComposer istore_3() {
        return this.add(new VariableInstruction(62));
    }

    public CompactCodeAttributeComposer lstore_0() {
        return this.add(new VariableInstruction(63));
    }

    public CompactCodeAttributeComposer lstore_1() {
        return this.add(new VariableInstruction(64));
    }

    public CompactCodeAttributeComposer lstore_2() {
        return this.add(new VariableInstruction(65));
    }

    public CompactCodeAttributeComposer lstore_3() {
        return this.add(new VariableInstruction(66));
    }

    public CompactCodeAttributeComposer fstore_0() {
        return this.add(new VariableInstruction(67));
    }

    public CompactCodeAttributeComposer fstore_1() {
        return this.add(new VariableInstruction(68));
    }

    public CompactCodeAttributeComposer fstore_2() {
        return this.add(new VariableInstruction(69));
    }

    public CompactCodeAttributeComposer fstore_3() {
        return this.add(new VariableInstruction(70));
    }

    public CompactCodeAttributeComposer dstore_0() {
        return this.add(new VariableInstruction(71));
    }

    public CompactCodeAttributeComposer dstore_1() {
        return this.add(new VariableInstruction(72));
    }

    public CompactCodeAttributeComposer dstore_2() {
        return this.add(new VariableInstruction(73));
    }

    public CompactCodeAttributeComposer dstore_3() {
        return this.add(new VariableInstruction(74));
    }

    public CompactCodeAttributeComposer astore_0() {
        return this.add(new VariableInstruction(75));
    }

    public CompactCodeAttributeComposer astore_1() {
        return this.add(new VariableInstruction(76));
    }

    public CompactCodeAttributeComposer astore_2() {
        return this.add(new VariableInstruction(77));
    }

    public CompactCodeAttributeComposer astore_3() {
        return this.add(new VariableInstruction(78));
    }

    public CompactCodeAttributeComposer iastore() {
        return this.add(new SimpleInstruction(79));
    }

    public CompactCodeAttributeComposer lastore() {
        return this.add(new SimpleInstruction(80));
    }

    public CompactCodeAttributeComposer fastore() {
        return this.add(new SimpleInstruction(81));
    }

    public CompactCodeAttributeComposer dastore() {
        return this.add(new SimpleInstruction(82));
    }

    public CompactCodeAttributeComposer aastore() {
        return this.add(new SimpleInstruction(83));
    }

    public CompactCodeAttributeComposer bastore() {
        return this.add(new SimpleInstruction(84));
    }

    public CompactCodeAttributeComposer castore() {
        return this.add(new SimpleInstruction(85));
    }

    public CompactCodeAttributeComposer sastore() {
        return this.add(new SimpleInstruction(86));
    }

    public CompactCodeAttributeComposer pop() {
        return this.add(new SimpleInstruction(87));
    }

    public CompactCodeAttributeComposer pop2() {
        return this.add(new SimpleInstruction(88));
    }

    public CompactCodeAttributeComposer dup() {
        return this.add(new SimpleInstruction(89));
    }

    public CompactCodeAttributeComposer dup_x1() {
        return this.add(new SimpleInstruction(90));
    }

    public CompactCodeAttributeComposer dup_x2() {
        return this.add(new SimpleInstruction(91));
    }

    public CompactCodeAttributeComposer dup2() {
        return this.add(new SimpleInstruction(92));
    }

    public CompactCodeAttributeComposer dup2_x1() {
        return this.add(new SimpleInstruction(93));
    }

    public CompactCodeAttributeComposer dup2_x2() {
        return this.add(new SimpleInstruction(94));
    }

    public CompactCodeAttributeComposer swap() {
        return this.add(new SimpleInstruction(95));
    }

    public CompactCodeAttributeComposer iadd() {
        return this.add(new SimpleInstruction(96));
    }

    public CompactCodeAttributeComposer ladd() {
        return this.add(new SimpleInstruction(97));
    }

    public CompactCodeAttributeComposer fadd() {
        return this.add(new SimpleInstruction(98));
    }

    public CompactCodeAttributeComposer dadd() {
        return this.add(new SimpleInstruction(99));
    }

    public CompactCodeAttributeComposer isub() {
        return this.add(new SimpleInstruction(100));
    }

    public CompactCodeAttributeComposer lsub() {
        return this.add(new SimpleInstruction(101));
    }

    public CompactCodeAttributeComposer fsub() {
        return this.add(new SimpleInstruction(102));
    }

    public CompactCodeAttributeComposer dsub() {
        return this.add(new SimpleInstruction(103));
    }

    public CompactCodeAttributeComposer imul() {
        return this.add(new SimpleInstruction(104));
    }

    public CompactCodeAttributeComposer lmul() {
        return this.add(new SimpleInstruction(105));
    }

    public CompactCodeAttributeComposer fmul() {
        return this.add(new SimpleInstruction(106));
    }

    public CompactCodeAttributeComposer dmul() {
        return this.add(new SimpleInstruction(107));
    }

    public CompactCodeAttributeComposer idiv() {
        return this.add(new SimpleInstruction(108));
    }

    public CompactCodeAttributeComposer ldiv() {
        return this.add(new SimpleInstruction(109));
    }

    public CompactCodeAttributeComposer fdiv() {
        return this.add(new SimpleInstruction(110));
    }

    public CompactCodeAttributeComposer ddiv() {
        return this.add(new SimpleInstruction(111));
    }

    public CompactCodeAttributeComposer irem() {
        return this.add(new SimpleInstruction(112));
    }

    public CompactCodeAttributeComposer lrem() {
        return this.add(new SimpleInstruction(113));
    }

    public CompactCodeAttributeComposer frem() {
        return this.add(new SimpleInstruction(114));
    }

    public CompactCodeAttributeComposer drem() {
        return this.add(new SimpleInstruction(115));
    }

    public CompactCodeAttributeComposer ineg() {
        return this.add(new SimpleInstruction(116));
    }

    public CompactCodeAttributeComposer lneg() {
        return this.add(new SimpleInstruction(117));
    }

    public CompactCodeAttributeComposer fneg() {
        return this.add(new SimpleInstruction(118));
    }

    public CompactCodeAttributeComposer dneg() {
        return this.add(new SimpleInstruction(119));
    }

    public CompactCodeAttributeComposer ishl() {
        return this.add(new SimpleInstruction(120));
    }

    public CompactCodeAttributeComposer lshl() {
        return this.add(new SimpleInstruction(121));
    }

    public CompactCodeAttributeComposer ishr() {
        return this.add(new SimpleInstruction(122));
    }

    public CompactCodeAttributeComposer lshr() {
        return this.add(new SimpleInstruction(123));
    }

    public CompactCodeAttributeComposer iushr() {
        return this.add(new SimpleInstruction(124));
    }

    public CompactCodeAttributeComposer lushr() {
        return this.add(new SimpleInstruction(125));
    }

    public CompactCodeAttributeComposer iand() {
        return this.add(new SimpleInstruction(126));
    }

    public CompactCodeAttributeComposer land() {
        return this.add(new SimpleInstruction(127));
    }

    public CompactCodeAttributeComposer ior() {
        return this.add(new SimpleInstruction(-128));
    }

    public CompactCodeAttributeComposer lor() {
        return this.add(new SimpleInstruction(-127));
    }

    public CompactCodeAttributeComposer ixor() {
        return this.add(new SimpleInstruction(-126));
    }

    public CompactCodeAttributeComposer lxor() {
        return this.add(new SimpleInstruction(-125));
    }

    public CompactCodeAttributeComposer iinc(int variableIndex, int constant) {
        return this.add(new VariableInstruction(-124, variableIndex, constant));
    }

    public CompactCodeAttributeComposer i2l() {
        return this.add(new SimpleInstruction(-123));
    }

    public CompactCodeAttributeComposer i2f() {
        return this.add(new SimpleInstruction(-122));
    }

    public CompactCodeAttributeComposer i2d() {
        return this.add(new SimpleInstruction(-121));
    }

    public CompactCodeAttributeComposer l2i() {
        return this.add(new SimpleInstruction(-120));
    }

    public CompactCodeAttributeComposer l2f() {
        return this.add(new SimpleInstruction(-119));
    }

    public CompactCodeAttributeComposer l2d() {
        return this.add(new SimpleInstruction(-118));
    }

    public CompactCodeAttributeComposer f2i() {
        return this.add(new SimpleInstruction(-117));
    }

    public CompactCodeAttributeComposer f2l() {
        return this.add(new SimpleInstruction(-116));
    }

    public CompactCodeAttributeComposer f2d() {
        return this.add(new SimpleInstruction(-115));
    }

    public CompactCodeAttributeComposer d2i() {
        return this.add(new SimpleInstruction(-114));
    }

    public CompactCodeAttributeComposer d2l() {
        return this.add(new SimpleInstruction(-113));
    }

    public CompactCodeAttributeComposer d2f() {
        return this.add(new SimpleInstruction(-112));
    }

    public CompactCodeAttributeComposer i2b() {
        return this.add(new SimpleInstruction(-111));
    }

    public CompactCodeAttributeComposer i2c() {
        return this.add(new SimpleInstruction(-110));
    }

    public CompactCodeAttributeComposer i2s() {
        return this.add(new SimpleInstruction(-109));
    }

    public CompactCodeAttributeComposer lcmp() {
        return this.add(new SimpleInstruction(-108));
    }

    public CompactCodeAttributeComposer fcmpl() {
        return this.add(new SimpleInstruction(-107));
    }

    public CompactCodeAttributeComposer fcmpg() {
        return this.add(new SimpleInstruction(-106));
    }

    public CompactCodeAttributeComposer dcmpl() {
        return this.add(new SimpleInstruction(-105));
    }

    public CompactCodeAttributeComposer dcmpg() {
        return this.add(new SimpleInstruction(-104));
    }

    public CompactCodeAttributeComposer ifeq(int branchOffset) {
        return this.add(new BranchInstruction(-103, branchOffset));
    }

    public CompactCodeAttributeComposer ifne(int branchOffset) {
        return this.add(new BranchInstruction(-102, branchOffset));
    }

    public CompactCodeAttributeComposer iflt(int branchOffset) {
        return this.add(new BranchInstruction(-101, branchOffset));
    }

    public CompactCodeAttributeComposer ifge(int branchOffset) {
        return this.add(new BranchInstruction(-100, branchOffset));
    }

    public CompactCodeAttributeComposer ifgt(int branchOffset) {
        return this.add(new BranchInstruction(-99, branchOffset));
    }

    public CompactCodeAttributeComposer ifle(int branchOffset) {
        return this.add(new BranchInstruction(-98, branchOffset));
    }

    public CompactCodeAttributeComposer ificmpeq(int branchOffset) {
        return this.add(new BranchInstruction(-97, branchOffset));
    }

    public CompactCodeAttributeComposer ificmpne(int branchOffset) {
        return this.add(new BranchInstruction(-96, branchOffset));
    }

    public CompactCodeAttributeComposer ificmplt(int branchOffset) {
        return this.add(new BranchInstruction(-95, branchOffset));
    }

    public CompactCodeAttributeComposer ificmpge(int branchOffset) {
        return this.add(new BranchInstruction(-94, branchOffset));
    }

    public CompactCodeAttributeComposer ificmpgt(int branchOffset) {
        return this.add(new BranchInstruction(-93, branchOffset));
    }

    public CompactCodeAttributeComposer ificmple(int branchOffset) {
        return this.add(new BranchInstruction(-92, branchOffset));
    }

    public CompactCodeAttributeComposer ifacmpeq(int branchOffset) {
        return this.add(new BranchInstruction(-91, branchOffset));
    }

    public CompactCodeAttributeComposer ifacmpne(int branchOffset) {
        return this.add(new BranchInstruction(-90, branchOffset));
    }

    public CompactCodeAttributeComposer goto_(int branchOffset) {
        return this.add(new BranchInstruction(-89, branchOffset));
    }

    public CompactCodeAttributeComposer jsr(int branchOffset) {
        return this.add(new BranchInstruction(-88, branchOffset));
    }

    public CompactCodeAttributeComposer ret(int variableIndex) {
        return this.add(new VariableInstruction(-87, variableIndex));
    }

    public CompactCodeAttributeComposer tableswitch(int defaultOffset, int lowCase, int highCase, int[] jumpOffsets) {
        return this.add(new TableSwitchInstruction(-86, defaultOffset, lowCase, highCase, jumpOffsets));
    }

    public CompactCodeAttributeComposer lookupswitch(int defaultOffset, int[] cases, int[] jumpOffsets) {
        return this.add(new LookUpSwitchInstruction(-85, defaultOffset, cases, jumpOffsets));
    }

    public CompactCodeAttributeComposer ireturn() {
        return this.add(new SimpleInstruction(-84));
    }

    public CompactCodeAttributeComposer lreturn() {
        return this.add(new SimpleInstruction(-83));
    }

    public CompactCodeAttributeComposer freturn() {
        return this.add(new SimpleInstruction(-82));
    }

    public CompactCodeAttributeComposer dreturn() {
        return this.add(new SimpleInstruction(-81));
    }

    public CompactCodeAttributeComposer areturn() {
        return this.add(new SimpleInstruction(-80));
    }

    public CompactCodeAttributeComposer return_() {
        return this.add(new SimpleInstruction(-79));
    }

    public CompactCodeAttributeComposer getstatic(Clazz referencedClass, Member referencedMember) {
        return this.getstatic(referencedClass.getName(), referencedMember.getName(referencedClass), referencedMember.getDescriptor(referencedClass), referencedClass, referencedMember);
    }

    public CompactCodeAttributeComposer getstatic(String className, String name, String descriptor) {
        return this.getstatic(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer getstatic(String className, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.getstatic(this.constantPoolEditor.addFieldrefConstant(className, name, descriptor, referencedClass, referencedMember));
    }

    public CompactCodeAttributeComposer getstatic(int constantIndex) {
        return this.add(new ConstantInstruction(-78, constantIndex));
    }

    public CompactCodeAttributeComposer putstatic(Clazz referencedClass, Member referencedMember) {
        return this.putstatic(referencedClass.getName(), referencedMember.getName(referencedClass), referencedMember.getDescriptor(referencedClass), referencedClass, referencedMember);
    }

    public CompactCodeAttributeComposer putstatic(String className, String name, String descriptor) {
        return this.putstatic(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer putstatic(String className, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.putstatic(this.constantPoolEditor.addFieldrefConstant(className, name, descriptor, referencedClass, referencedMember));
    }

    public CompactCodeAttributeComposer putstatic(int constantIndex) {
        return this.add(new ConstantInstruction(-77, constantIndex));
    }

    public CompactCodeAttributeComposer getfield(String className, String name, String descriptor) {
        return this.getfield(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer getfield(String className, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.getfield(this.constantPoolEditor.addFieldrefConstant(className, name, descriptor, referencedClass, referencedMember));
    }

    public CompactCodeAttributeComposer getfield(int constantIndex) {
        return this.add(new ConstantInstruction(-76, constantIndex));
    }

    public CompactCodeAttributeComposer putfield(String className, String name, String descriptor) {
        return this.putfield(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer putfield(String className, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.putfield(this.constantPoolEditor.addFieldrefConstant(className, name, descriptor, referencedClass, referencedMember));
    }

    public CompactCodeAttributeComposer putfield(int constantIndex) {
        return this.add(new ConstantInstruction(-75, constantIndex));
    }

    public CompactCodeAttributeComposer invokevirtual(String className, String name, String descriptor) {
        return this.invokevirtual(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer invokevirtual(Clazz referencedClass, Member referencedMember) {
        return this.invokevirtual(referencedClass.getName(), referencedMember.getName(referencedClass), referencedMember.getDescriptor(referencedClass), referencedClass, referencedMember);
    }

    public CompactCodeAttributeComposer invokevirtual(String className, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.invokevirtual(this.constantPoolEditor.addMethodrefConstant(className, name, descriptor, referencedClass, referencedMember));
    }

    public CompactCodeAttributeComposer invokevirtual(int constantIndex) {
        return this.add(new ConstantInstruction(-74, constantIndex));
    }

    public CompactCodeAttributeComposer invokespecial(String className, String name, String descriptor) {
        return this.invokespecial(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer invokespecial(String className, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.invokespecial(this.constantPoolEditor.addMethodrefConstant(className, name, descriptor, referencedClass, referencedMember));
    }

    public CompactCodeAttributeComposer invokespecial(int constantIndex) {
        return this.add(new ConstantInstruction(-73, constantIndex));
    }

    public CompactCodeAttributeComposer invokestatic(String className, String name, String descriptor) {
        return this.invokestatic(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer invokestatic(Clazz referencedClass, Member referencedMember) {
        return this.invokestatic(referencedClass.getName(), referencedMember.getName(referencedClass), referencedMember.getDescriptor(referencedClass), referencedClass, referencedMember);
    }

    public CompactCodeAttributeComposer invokestatic(String className, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.invokestatic(this.constantPoolEditor.addMethodrefConstant(className, name, descriptor, referencedClass, referencedMember));
    }

    public CompactCodeAttributeComposer invokestaticinterface(String className, String name, String descriptor) {
        return this.invokestaticinterface(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer invokestaticinterface(Clazz referencedClass, Member referencedMember) {
        return this.invokestaticinterface(referencedClass.getName(), referencedMember.getName(referencedClass), referencedMember.getDescriptor(referencedClass), referencedClass, referencedMember);
    }

    public CompactCodeAttributeComposer invokestaticinterface(String className, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.invokestatic(this.constantPoolEditor.addInterfaceMethodrefConstant(className, name, descriptor, referencedClass, referencedMember));
    }

    public CompactCodeAttributeComposer invokestatic(int constantIndex) {
        return this.add(new ConstantInstruction(-72, constantIndex));
    }

    public CompactCodeAttributeComposer invokeinterface(String className, String name, String descriptor) {
        return this.invokeinterface(className, name, descriptor, null, null);
    }

    public CompactCodeAttributeComposer invokeinterface(String className, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        int invokeinterfaceConstant = ClassUtil.internalMethodParameterSize(descriptor, false) << 8;
        return this.invokeinterface(this.constantPoolEditor.addInterfaceMethodrefConstant(className, name, descriptor, referencedClass, referencedMember), invokeinterfaceConstant);
    }

    public CompactCodeAttributeComposer invokeinterface(int constantIndex, int constant) {
        return this.add(new ConstantInstruction(-71, constantIndex, constant));
    }

    public CompactCodeAttributeComposer invokedynamic(int bootStrapMethodIndex, String name, String descriptor, Clazz[] referencedClasses) {
        return this.invokedynamic(this.constantPoolEditor.addInvokeDynamicConstant(bootStrapMethodIndex, name, descriptor, referencedClasses));
    }

    public CompactCodeAttributeComposer invokedynamic(int constantIndex) {
        return this.add(new ConstantInstruction(-70, constantIndex));
    }

    public CompactCodeAttributeComposer new_(String className) {
        return this.new_(className, null);
    }

    public CompactCodeAttributeComposer new_(String className, Clazz referencedClass) {
        return this.new_(this.constantPoolEditor.addClassConstant(className, referencedClass));
    }

    public CompactCodeAttributeComposer new_(int constantIndex) {
        return this.add(new ConstantInstruction(-69, constantIndex));
    }

    public CompactCodeAttributeComposer newarray(int constant) {
        return this.add(new SimpleInstruction(-68, constant));
    }

    public CompactCodeAttributeComposer anewarray(String className, Clazz referencedClass) {
        return this.anewarray(this.constantPoolEditor.addClassConstant(className, referencedClass));
    }

    public CompactCodeAttributeComposer anewarray(int constantIndex) {
        return this.add(new ConstantInstruction(-67, constantIndex));
    }

    public CompactCodeAttributeComposer arraylength() {
        return this.add(new SimpleInstruction(-66));
    }

    public CompactCodeAttributeComposer athrow() {
        return this.add(new SimpleInstruction(-65));
    }

    public CompactCodeAttributeComposer checkcast(String className) {
        return this.checkcast(className, null);
    }

    public CompactCodeAttributeComposer checkcast(String className, Clazz referencedClass) {
        return this.checkcast(this.constantPoolEditor.addClassConstant(className, referencedClass));
    }

    public CompactCodeAttributeComposer checkcast(int constantIndex) {
        return this.add(new ConstantInstruction(-64, constantIndex));
    }

    public CompactCodeAttributeComposer instanceof_(String className, Clazz referencedClass) {
        return this.instanceof_(this.constantPoolEditor.addClassConstant(className, referencedClass));
    }

    public CompactCodeAttributeComposer instanceof_(int constantIndex) {
        return this.add(new ConstantInstruction(-63, constantIndex));
    }

    public CompactCodeAttributeComposer monitorenter() {
        return this.add(new SimpleInstruction(-62));
    }

    public CompactCodeAttributeComposer monitorexit() {
        return this.add(new SimpleInstruction(-61));
    }

    public CompactCodeAttributeComposer wide() {
        return this.add(new SimpleInstruction(-60));
    }

    public CompactCodeAttributeComposer multianewarray(String className, Clazz referencedClass) {
        return this.multianewarray(this.constantPoolEditor.addClassConstant(className, referencedClass));
    }

    public CompactCodeAttributeComposer multianewarray(int constantIndex) {
        return this.add(new ConstantInstruction(-59, constantIndex));
    }

    public CompactCodeAttributeComposer ifnull(int branchOffset) {
        return this.add(new BranchInstruction(-58, branchOffset));
    }

    public CompactCodeAttributeComposer ifnonnull(int branchOffset) {
        return this.add(new BranchInstruction(-57, branchOffset));
    }

    public CompactCodeAttributeComposer goto_w(int branchOffset) {
        return this.add(new BranchInstruction(-56, branchOffset));
    }

    public CompactCodeAttributeComposer jsr_w(int branchOffset) {
        return this.add(new BranchInstruction(-55, branchOffset));
    }

    public CompactCodeAttributeComposer pushPrimitive(Object primitive, char internalType) {
        switch (internalType) {
            case 'Z': {
                return (Boolean)primitive != false ? this.iconst_1() : this.iconst_0();
            }
            case 'B': {
                return this.bipush(((Byte)primitive).byteValue());
            }
            case 'C': {
                return this.ldc(((Character)primitive).charValue());
            }
            case 'S': {
                return this.sipush(((Short)primitive).shortValue());
            }
            case 'I': {
                return this.ldc((Integer)primitive);
            }
            case 'J': {
                return this.ldc2_w((Long)primitive);
            }
            case 'F': {
                return this.ldc(((Float)primitive).floatValue());
            }
            case 'D': {
                return this.ldc2_w((Double)primitive);
            }
        }
        throw new IllegalArgumentException(primitive.toString());
    }

    public CompactCodeAttributeComposer pushInt(int value) {
        return value >= -1 && value <= 5 ? this.iconst(value) : (value == (byte)value ? this.bipush(value) : (value == (short)value ? this.sipush(value) : this.ldc(value)));
    }

    public CompactCodeAttributeComposer pushFloat(float value) {
        return value == 0.0f || value == 1.0f ? this.fconst((int)value) : this.ldc(value);
    }

    public CompactCodeAttributeComposer pushLong(long value) {
        return value == 0L || value == 1L ? this.lconst((int)value) : this.ldc2_w(value);
    }

    public CompactCodeAttributeComposer pushDouble(double value) {
        return value == 0.0 || value == 1.0 ? this.dconst((int)value) : this.ldc2_w(value);
    }

    public CompactCodeAttributeComposer pushNewArray(String elementTypeOrClassName, int size) {
        this.pushInt(size);
        return ClassUtil.isInternalPrimitiveType(elementTypeOrClassName) ? this.newarray(InstructionUtil.arrayTypeFromInternalType(elementTypeOrClassName.charAt(0))) : this.anewarray(elementTypeOrClassName, null);
    }

    public CompactCodeAttributeComposer load(int variableIndex, String internalType) {
        return this.load(variableIndex, internalType.charAt(0));
    }

    public CompactCodeAttributeComposer load(int variableIndex, char internalType) {
        switch (internalType) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.iload(variableIndex);
            }
            case 'J': {
                return this.lload(variableIndex);
            }
            case 'F': {
                return this.fload(variableIndex);
            }
            case 'D': {
                return this.dload(variableIndex);
            }
        }
        return this.aload(variableIndex);
    }

    public CompactCodeAttributeComposer store(int variableIndex, String internalType) {
        return this.store(variableIndex, internalType.charAt(0));
    }

    public CompactCodeAttributeComposer store(int variableIndex, char internalType) {
        switch (internalType) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.istore(variableIndex);
            }
            case 'J': {
                return this.lstore(variableIndex);
            }
            case 'F': {
                return this.fstore(variableIndex);
            }
            case 'D': {
                return this.dstore(variableIndex);
            }
        }
        return this.astore(variableIndex);
    }

    public CompactCodeAttributeComposer storeToArray(String elementType) {
        switch (elementType.charAt(0)) {
            case 'B': 
            case 'Z': {
                return this.bastore();
            }
            case 'C': {
                return this.castore();
            }
            case 'S': {
                return this.sastore();
            }
            case 'I': {
                return this.iastore();
            }
            case 'J': {
                return this.lastore();
            }
            case 'F': {
                return this.fastore();
            }
            case 'D': {
                return this.dastore();
            }
        }
        return this.aastore();
    }

    public CompactCodeAttributeComposer return_(String internalType) {
        switch (internalType.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.ireturn();
            }
            case 'J': {
                return this.lreturn();
            }
            case 'F': {
                return this.freturn();
            }
            case 'D': {
                return this.dreturn();
            }
            case 'V': {
                return this.return_();
            }
        }
        return this.areturn();
    }

    public CompactCodeAttributeComposer appendPrintIntegerInstructions(String message) {
        this.appendPrintInstructions(message);
        this.appendPrintIntegerInstructions();
        return this;
    }

    public CompactCodeAttributeComposer appendPrintIntegerHexInstructions(String message) {
        this.appendPrintInstructions(message);
        this.appendPrintIntegerHexInstructions();
        return this;
    }

    public CompactCodeAttributeComposer appendPrintLongInstructions(String message) {
        this.appendPrintInstructions(message);
        this.appendPrintLongInstructions();
        return this;
    }

    public CompactCodeAttributeComposer appendPrintStringInstructions(String message) {
        this.appendPrintInstructions(message);
        this.appendPrintStringInstructions();
        return this;
    }

    public CompactCodeAttributeComposer appendPrintObjectInstructions(String message) {
        this.appendPrintInstructions(message);
        this.appendPrintObjectInstructions();
        return this;
    }

    public CompactCodeAttributeComposer appendPrintStackTraceInstructions(String message) {
        this.appendPrintInstructions(message);
        this.appendPrintStackTraceInstructions();
        return this;
    }

    public CompactCodeAttributeComposer appendPrintInstructions(String message) {
        this.getstatic("java/lang/System", "err", "Ljava/io/PrintStream;");
        this.ldc(message);
        this.invokevirtual("java/io/PrintStream", "println", "(Ljava/lang/String;)V");
        return this;
    }

    public CompactCodeAttributeComposer appendPrintIntegerInstructions() {
        this.dup();
        this.getstatic("java/lang/System", "err", "Ljava/io/PrintStream;");
        this.swap();
        this.invokevirtual("java/io/PrintStream", "println", "(I)V");
        return this;
    }

    public CompactCodeAttributeComposer appendPrintIntegerHexInstructions() {
        this.dup();
        this.getstatic("java/lang/System", "err", "Ljava/io/PrintStream;");
        this.swap();
        this.invokestatic("java/lang/Integer", "toHexString", "(I)Ljava/lang/String;");
        this.invokevirtual("java/io/PrintStream", "println", "(Ljava/lang/String;)V");
        return this;
    }

    public CompactCodeAttributeComposer appendPrintLongInstructions() {
        this.dup2();
        this.getstatic("java/lang/System", "err", "Ljava/io/PrintStream;");
        this.dup_x2();
        this.pop();
        this.invokevirtual("java/io/PrintStream", "println", "(J)V");
        return this;
    }

    public CompactCodeAttributeComposer appendPrintStringInstructions() {
        this.dup();
        this.getstatic("java/lang/System", "err", "Ljava/io/PrintStream;");
        this.swap();
        this.invokevirtual("java/io/PrintStream", "println", "(Ljava/lang/String;)V");
        return this;
    }

    public CompactCodeAttributeComposer appendPrintObjectInstructions() {
        this.dup();
        this.getstatic("java/lang/System", "err", "Ljava/io/PrintStream;");
        this.swap();
        this.invokevirtual("java/io/PrintStream", "println", "(Ljava/lang/Object;)V");
        return this;
    }

    public CompactCodeAttributeComposer appendPrintStackTraceInstructions() {
        this.dup();
        this.invokevirtual("java/lang/Throwable", "printStackTrace", "()V");
        return this;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeComposer.visitCodeAttribute(clazz, method, codeAttribute);
    }

    private CompactCodeAttributeComposer add(Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(instruction);
        return this;
    }

    public static void main(String[] args) {
        ProgramClass targetClass = new ProgramClass(0, 0, new Constant[32], 0, 0, 0);
        CompactCodeAttributeComposer composer = new CompactCodeAttributeComposer(targetClass);
        composer.beginCodeFragment(4);
        composer.appendInstruction(0, new SimpleInstruction(3));
        composer.appendInstruction(1, new VariableInstruction(54, 0));
        composer.appendInstruction(2, new BranchInstruction(-89, 1));
        composer.beginCodeFragment(4);
        composer.appendInstruction(0, new VariableInstruction(-124, 0, 1));
        composer.appendInstruction(1, new VariableInstruction(21, 0));
        composer.appendInstruction(2, new SimpleInstruction(8));
        composer.appendInstruction(3, new BranchInstruction(-95, -3));
        composer.endCodeFragment();
        composer.appendInstruction(3, new SimpleInstruction(-79));
        composer.endCodeFragment();
    }
}

