/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker.instrument;

import com.google.caliper.core.Running;
import com.google.caliper.model.ArbitraryMeasurement;
import com.google.caliper.model.Measurement;
import com.google.caliper.model.Value;
import com.google.caliper.util.Util;
import com.google.caliper.worker.instrument.WorkerInstrument;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Map;
import javax.inject.Inject;

final class ArbitraryMeasurementWorkerInstrument
extends WorkerInstrument {
    private final Options options;
    private final String unit;
    private final String description;

    @Inject
    ArbitraryMeasurementWorkerInstrument(@Running.Benchmark Object benchmark, @Running.BenchmarkMethod Method method, @WorkerInstrument.Options Map<String, String> options) {
        super(benchmark, method);
        this.options = new Options(options);
        ArbitraryMeasurement annotation = method.getAnnotation(ArbitraryMeasurement.class);
        this.unit = annotation.units();
        this.description = annotation.description();
    }

    @Override
    public void preMeasure(boolean inWarmup) throws Exception {
        if (this.options.gcBeforeEach && !inWarmup) {
            Util.forceGc();
        }
    }

    @Override
    public void dryRun() throws Exception {
        this.benchmarkMethod.invoke(this.benchmark, new Object[0]);
    }

    @Override
    public Iterable<Measurement> measure() throws Exception {
        double measured = (Double)this.benchmarkMethod.invoke(this.benchmark, new Object[0]);
        return ImmutableSet.of((Object)new Measurement.Builder().value(Value.create((double)measured, (String)this.unit)).weight(1.0).description(this.description).build());
    }

    private static class Options {
        final boolean gcBeforeEach;

        Options(Map<String, String> options) {
            this.gcBeforeEach = Boolean.parseBoolean(options.get("gcBeforeEach"));
        }
    }
}

