/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.resultprocessor;

import com.google.caliper.api.ResultProcessor;
import com.google.caliper.core.UserCodeException;
import com.google.caliper.runner.config.ResultProcessorConfig;
import com.google.common.base.Optional;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

final class ResultProcessorCreator {
    public static final String NO_VALID_CONSTRUCTOR = "ResultProcessor %s not supported: it needs a public constructor with either no parameters or one ResultProcessorConfig parameter";

    private ResultProcessorCreator() {
    }

    static ResultProcessor createResultProcessor(Class<? extends ResultProcessor> processorClass, ResultProcessorConfig config) {
        try {
            Optional<ResultProcessor> result = ResultProcessorCreator.tryInstantiate(processorClass, config);
            if (!result.isPresent() && !(result = ResultProcessorCreator.tryInstantiate(processorClass, new Object[0])).isPresent()) {
                throw new UserCodeException(String.format(NO_VALID_CONSTRUCTOR, processorClass));
            }
            return (ResultProcessor)result.get();
        }
        catch (InvocationTargetException e) {
            throw new UserCodeException(String.format("ResultProcessor %s could not be instantiated", processorClass), e.getCause());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new UserCodeException(String.format("ResultProcessor %s could not be instantiated", processorClass), (Throwable)e);
        }
    }

    private static Optional<ResultProcessor> tryInstantiate(Class<? extends ResultProcessor> processorClass, Object ... args) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Class[] argClasses = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argClasses[i] = args[i].getClass();
        }
        try {
            Constructor<? extends ResultProcessor> constructor = processorClass.getConstructor(argClasses);
            return Optional.of((Object)constructor.newInstance(args));
        }
        catch (NoSuchMethodException e) {
            return Optional.absent();
        }
    }
}

