/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.worker;

import com.google.caliper.bridge.LogMessage;
import com.google.caliper.bridge.OpenedSocket;
import com.google.caliper.bridge.StopMeasurementLogMessage;
import com.google.caliper.model.Measurement;
import com.google.caliper.runner.target.Device;
import com.google.caliper.runner.target.VmProcess;
import com.google.caliper.runner.worker.WorkerOutputLogger;
import com.google.caliper.runner.worker.WorkerScoped;
import com.google.caliper.runner.worker.WorkerSpec;
import com.google.caliper.util.Parser;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import com.google.common.io.Closeables;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.inject.Inject;

@WorkerScoped
public final class Worker
extends AbstractService {
    private static final int SHUTDOWN_WAIT_MILLIS = 5000;
    private static final Logger logger = Logger.getLogger(Worker.class.getName());
    private static final StreamItem TIMEOUT_ITEM = new StreamItem(StreamItem.Kind.TIMEOUT, null);
    static final StreamItem EOF_ITEM = new StreamItem(StreamItem.Kind.EOF, null);
    private final ListeningExecutorService streamExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).build()));
    private final BlockingQueue<StreamItem> outputQueue = Queues.newLinkedBlockingQueue();
    private final WorkerSpec spec;
    private final Device device;
    private final ListenableFuture<OpenedSocket> socketFuture;
    private final Parser<LogMessage> logMessageParser;
    private final WorkerOutputLogger output;
    private volatile VmProcess process;
    private final AtomicInteger openStreams = new AtomicInteger();
    private final AtomicInteger runningReadStreams = new AtomicInteger();
    private OpenedSocket.Writer socketWriter;

    @Inject
    Worker(WorkerSpec spec, Device device, ListenableFuture<OpenedSocket> socketFuture, Parser<LogMessage> logMessageParser, WorkerOutputLogger output) {
        this.spec = spec;
        this.device = device;
        this.socketFuture = socketFuture;
        this.logMessageParser = logMessageParser;
        this.output = output;
    }

    String name() {
        return this.spec.name();
    }

    WorkerOutputLogger outputLogger() {
        return this.output;
    }

    protected void doStart() {
        try {
            this.process = this.device.startVm(this.spec, this.output);
        }
        catch (Exception e) {
            this.notifyFailed(e);
            return;
        }
        this.addListener(new Service.Listener(){

            public void terminated(Service.State from) {
                this.cleanup();
            }

            public void failed(Service.State from, Throwable failure) {
                this.cleanup();
            }

            void cleanup() {
                Worker.this.streamExecutor.shutdown();
                Worker.this.process.kill();
                boolean interrupt = false;
                try {
                    Worker.this.process.awaitExit();
                }
                catch (InterruptedException e) {
                    interrupt = true;
                }
                try {
                    Worker.this.streamExecutor.awaitTermination(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    interrupt = true;
                }
                if (interrupt) {
                    Thread.currentThread().interrupt();
                }
                Worker.this.streamExecutor.shutdownNow();
            }
        }, MoreExecutors.directExecutor());
        this.openStreams.incrementAndGet();
        this.startStreamReader("stderr", this.process.stderr());
        this.startStreamReader("stdout", this.process.stdout());
        this.socketFuture.addListener(new Runnable(){

            @Override
            public void run() {
                Worker.this.startSocketStream();
            }
        }, MoreExecutors.directExecutor());
        this.notifyStarted();
    }

    private void startStreamReader(String name, InputStream inputStream) {
        this.runningReadStreams.incrementAndGet();
        String string = String.valueOf(name);
        ListenableFuture possiblyIgnoredError = this.streamExecutor.submit(Worker.threadRenaming(string.length() != 0 ? "worker-".concat(string) : new String("worker-"), new StreamReader(name, new InputStreamReader(inputStream, Charset.defaultCharset()))));
    }

    private void startSocketStream() {
        try {
            OpenedSocket openedSocket = (OpenedSocket)Uninterruptibles.getUninterruptibly(this.socketFuture);
            logger.fine("successfully opened the pipe from the worker");
            this.socketWriter = openedSocket.writer();
            this.runningReadStreams.incrementAndGet();
            this.openStreams.incrementAndGet();
            ListenableFuture listenableFuture = this.streamExecutor.submit(Worker.threadRenaming("worker-socket", new SocketStreamReader(openedSocket.reader())));
        }
        catch (ExecutionException e) {
            this.notifyFailed(e.getCause());
        }
    }

    StreamItem readItem(long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkState((boolean)this.isRunning(), (String)"Cannot read items from a %s StreamService", (Object)this.state());
        StreamItem line = this.outputQueue.poll(timeout, unit);
        if (line == EOF_ITEM) {
            this.closeStream();
        }
        return line == null ? TIMEOUT_ITEM : line;
    }

    void sendRequest() {
        this.socketFuture.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    Worker.this.sendMessage((Serializable)Worker.this.spec.request());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, MoreExecutors.directExecutor());
    }

    public void sendMessage(Serializable message) throws IOException {
        Preconditions.checkState((boolean)this.isRunning(), (String)"Cannot read items from a %s StreamService", (Object)this.state());
        Preconditions.checkState((this.socketWriter != null ? 1 : 0) != 0, (Object)"Attempted to write to the socket before it was opened.");
        try {
            this.socketWriter.write(new Serializable[]{message});
        }
        catch (IOException e) {
            Closeables.close((Closeable)this.socketWriter, (boolean)true);
            this.notifyFailed(e);
            throw e;
        }
    }

    public void closeWriter() throws IOException {
        Preconditions.checkState((boolean)this.isRunning(), (String)"Cannot read items from a %s StreamService", (Object)this.state());
        Preconditions.checkState((this.socketWriter != null ? 1 : 0) != 0, (Object)"Attempted to close the socket before it was opened.");
        try {
            this.socketWriter.close();
        }
        catch (IOException e) {
            this.notifyFailed(e);
            throw e;
        }
        this.closeStream();
    }

    protected void doStop() {
        if (this.openStreams.get() > 0) {
            logger.warning("Attempting to stop the stream service with streams still open");
        }
        final ListenableFuture processFuture = this.streamExecutor.submit((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Worker.this.process.awaitExit();
            }
        });
        ListenableFuture possiblyIgnoredError = this.streamExecutor.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int n;
                boolean threw = true;
                try {
                    if ((Integer)processFuture.get(5000L, TimeUnit.MILLISECONDS) == 0) {
                        Worker.this.notifyStopped();
                    } else {
                        n = Worker.this.process.awaitExit();
                        Worker.this.notifyFailed(new Exception(new StringBuilder(54).append("Process failed to stop cleanly. Exit code: ").append(n).toString()));
                    }
                    threw = false;
                }
                finally {
                    processFuture.cancel(true);
                    if (threw) {
                        Worker.this.process.kill();
                        n = Worker.this.process.awaitExit();
                        Worker.this.notifyFailed(new Exception(new StringBuilder(78).append("Process failed to stop cleanly and was forcibly killed. Exit code: ").append(n).toString()));
                    }
                }
                return null;
            }
        });
    }

    private void closeStream() {
        if (this.openStreams.decrementAndGet() == 0) {
            this.stopAsync();
        }
    }

    private void closeReadStream() {
        if (this.runningReadStreams.decrementAndGet() == 0) {
            this.outputQueue.add(EOF_ITEM);
        }
    }

    private static <T> Callable<T> threadRenaming(final String name, final Callable<T> callable) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(callable);
        return new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                Thread currentThread = Thread.currentThread();
                String oldName = currentThread.getName();
                currentThread.setName(name);
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    currentThread.setName(oldName);
                }
            }
        };
    }

    private final class SocketStreamReader
    implements Callable<Void> {
        final OpenedSocket.Reader reader;

        SocketStreamReader(OpenedSocket.Reader reader) {
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws IOException, InterruptedException, ParseException {
            boolean threw = true;
            try {
                Serializable obj;
                while ((obj = this.reader.read()) != null) {
                    if (obj instanceof String) {
                        this.log(obj.toString());
                        continue;
                    }
                    LogMessage message = (LogMessage)obj;
                    if (message instanceof StopMeasurementLogMessage) {
                        for (Measurement measurement : ((StopMeasurementLogMessage)message).measurements()) {
                            this.log(String.format("I got a result! %s: %f%s%n", measurement.description(), measurement.value().magnitude() / measurement.weight(), measurement.value().unit()));
                        }
                    }
                    Worker.this.outputQueue.put(new StreamItem(message));
                }
                threw = false;
            }
            catch (Exception e) {
                Worker.this.notifyFailed(e);
            }
            finally {
                Worker.this.closeReadStream();
                Closeables.close((Closeable)this.reader, (boolean)threw);
            }
            return null;
        }

        private void log(String text) {
            Worker.this.output.log("socket", text);
        }
    }

    private final class StreamReader
    implements Callable<Void> {
        final Reader reader;
        final String streamName;

        StreamReader(String streamName, Reader reader) {
            this.streamName = streamName;
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws IOException, InterruptedException, ParseException {
            BufferedReader lineReader = new BufferedReader(this.reader);
            boolean threw = true;
            try {
                String line;
                while ((line = lineReader.readLine()) != null) {
                    Worker.this.output.log(this.streamName, line);
                    LogMessage logMessage = (LogMessage)Worker.this.logMessageParser.parse((CharSequence)line);
                    if (logMessage == null) continue;
                    Worker.this.outputQueue.put(new StreamItem(logMessage));
                }
                threw = false;
            }
            catch (Exception e) {
                Worker.this.notifyFailed(e);
            }
            finally {
                Worker.this.closeReadStream();
                Closeables.close((Closeable)this.reader, (boolean)threw);
            }
            return null;
        }
    }

    static class StreamItem {
        @Nullable
        private final LogMessage logMessage;
        private final Kind kind;

        private StreamItem(LogMessage line) {
            this(Kind.DATA, (LogMessage)Preconditions.checkNotNull((Object)line));
        }

        private StreamItem(Kind state, @Nullable LogMessage logMessage) {
            this.logMessage = logMessage;
            this.kind = state;
        }

        LogMessage content() {
            Preconditions.checkState((this.kind == Kind.DATA ? 1 : 0) != 0, (String)"Only data lines have content: %s", (Object)this);
            return this.logMessage;
        }

        Kind kind() {
            return this.kind;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(StreamItem.class);
            if (this.kind == Kind.DATA) {
                helper.addValue((Object)this.logMessage);
            } else {
                helper.addValue((Object)this.kind);
            }
            return helper.toString();
        }

        static enum Kind {
            EOF,
            TIMEOUT,
            DATA;

        }
    }
}

