/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.worker;

import com.google.caliper.runner.target.VmProcess;
import com.google.caliper.runner.worker.WorkerOutputFactory;
import com.google.caliper.runner.worker.WorkerScoped;
import com.google.caliper.runner.worker.WorkerSpec;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

@WorkerScoped
final class WorkerOutputLogger
implements VmProcess.Logger,
Flushable,
Closeable {
    @GuardedBy(value="this")
    private File file;
    @GuardedBy(value="this")
    private PrintWriter writer;
    private final WorkerOutputFactory outputManager;
    private final WorkerSpec workerSpec;

    @Inject
    WorkerOutputLogger(WorkerOutputFactory outputManager, WorkerSpec workerSpec) {
        this.outputManager = outputManager;
        this.workerSpec = workerSpec;
    }

    synchronized void open() throws IOException {
        if (this.writer == null) {
            WorkerOutputFactory.FileAndWriter fileAndWriter = this.outputManager.getOutputFile(String.valueOf(this.workerSpec.name()).concat(".log"));
            this.file = fileAndWriter.file;
            this.writer = fileAndWriter.writer;
        }
    }

    private synchronized void checkOpened() {
        Preconditions.checkState((this.writer != null ? 1 : 0) != 0, (Object)"The logger is not open");
    }

    synchronized void printHeader() {
        this.checkOpened();
        this.workerSpec.printInfoHeader(this.writer);
        this.writer.println();
    }

    @Override
    public synchronized void log(String line) {
        this.checkOpened();
        this.writer.println(line);
    }

    @Override
    public synchronized void log(String source, String line) {
        this.checkOpened();
        this.writer.printf("[%s] %s%n", source, line);
    }

    @Override
    public synchronized void flush() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    @Override
    public synchronized void close() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    synchronized void ensureFileIsSaved() {
        this.checkOpened();
        this.outputManager.persistFile(this.file);
    }

    synchronized File outputFile() {
        this.checkOpened();
        return this.file;
    }
}

