/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;

@BugPattern(tags={"Refactoring"}, summary="Prefer using `@Rule` with an explicit order over declaring a `RuleChain`. RuleChain was the only way to declare ordered rules before JUnit 4.13. Newer versions should use the cleaner individual `@Rule(order = n)` option. The rules with a higher value are inner.", severity=BugPattern.SeverityLevel.WARNING)
public class DoNotUseRuleChain
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final String TEST_RULE_VAR_PREFIX = "testRule";
    private static final String JUNIT_RULE_CHAIN_IMPORT_PATH = "org.junit.rules.RuleChain";
    private static final String JUNIT_CLASS_RULE_IMPORT_PATH = "org.junit.ClassRule";
    private static final String JUNIT_RULE_IMPORT_PATH = "org.junit.Rule";
    private static final Matcher<ExpressionTree> RULE_CHAIN_METHOD_MATCHER = Matchers.anyMethod().onDescendantOf("org.junit.rules.RuleChain").namedAnyOf(new String[]{"around", "outerRule"});

    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (symbol.getKind() != ElementKind.FIELD || !DoNotUseRuleChain.isRuleChainExpression(tree, state) || !DoNotUseRuleChain.isClassWithSingleRule(state) || DoNotUseRuleChain.isChainedRuleChain(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)DoNotUseRuleChain.refactor(tree, state));
    }

    private static boolean isRuleChainExpression(VariableTree tree, VisitorState state) {
        ExpressionTree expression = tree.getInitializer();
        if (expression == null) {
            return false;
        }
        return RULE_CHAIN_METHOD_MATCHER.matches((Tree)expression, state);
    }

    private static boolean isClassWithSingleRule(VisitorState state) {
        Optional<ClassTree> classTree = DoNotUseRuleChain.getClassTree(state);
        if (classTree.isEmpty()) {
            return false;
        }
        return classTree.get().getMembers().stream().filter(tree -> ASTHelpers.hasAnnotation((Tree)tree, (String)JUNIT_RULE_IMPORT_PATH, (VisitorState)state)).count() == 1L;
    }

    private static Optional<ClassTree> getClassTree(VisitorState state) {
        return Streams.stream(state.getPath().iterator()).filter(parent -> parent.getKind() == Tree.Kind.CLASS).map(ClassTree.class::cast).findFirst();
    }

    private static boolean isChainedRuleChain(VariableTree tree, VisitorState state) {
        return DoNotUseRuleChain.getOrderedExpressions(tree, state).stream().map(DoNotUseRuleChain::getArgumentExpression).anyMatch(ex -> Matchers.isSameType((String)JUNIT_RULE_CHAIN_IMPORT_PATH).matches((Tree)ex, state));
    }

    private static SuggestedFix refactor(VariableTree tree, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        ImmutableList<ExpressionTree> expressions = DoNotUseRuleChain.getOrderedExpressions(tree, state);
        Object replacement = "";
        for (int i = 0; i < expressions.size(); ++i) {
            ExpressionTree expression = DoNotUseRuleChain.getArgumentExpression((ExpressionTree)expressions.get(i));
            DoNotUseRuleChain.addImportIfNecessary(expression, fix);
            replacement = (String)replacement + DoNotUseRuleChain.extractRuleFromExpression(expression, i, tree, state);
        }
        fix.removeImport(JUNIT_RULE_CHAIN_IMPORT_PATH);
        fix.replace((Tree)tree, (String)replacement);
        return fix.build();
    }

    private static ImmutableList<ExpressionTree> getOrderedExpressions(VariableTree tree, VisitorState state) {
        ImmutableList.Builder expressions = ImmutableList.builder();
        ExpressionTree ex = tree.getInitializer();
        while (RULE_CHAIN_METHOD_MATCHER.matches((Tree)ex, state)) {
            expressions.add((Object)ex);
            ex = ASTHelpers.getReceiver((ExpressionTree)ex);
        }
        return expressions.build().reverse();
    }

    private static ExpressionTree getArgumentExpression(ExpressionTree ex) {
        MethodInvocationTree methodInvocation = (MethodInvocationTree)ex;
        return methodInvocation.getArguments().get(0);
    }

    private static void addImportIfNecessary(ExpressionTree expression, SuggestedFix.Builder fix) {
        Type originalType = ASTHelpers.getResultType((ExpressionTree)expression);
        if (ImmutableSet.of((Object)((Object)Tree.Kind.METHOD_INVOCATION), (Object)((Object)Tree.Kind.LAMBDA_EXPRESSION)).contains((Object)expression.getKind())) {
            fix.addImport(originalType.tsym.getQualifiedName().toString());
        }
    }

    private static String extractRuleFromExpression(ExpressionTree expression, int order, VariableTree tree, VisitorState state) {
        String className = DoNotUseRuleChain.className(expression);
        return String.format("%s(order = %d)\npublic %sfinal %s %s = %s;\n", DoNotUseRuleChain.annotationName(tree, state), order, ASTHelpers.getSymbol((VariableTree)tree).isStatic() ? "static " : "", className, DoNotUseRuleChain.classToVariableName(className), state.getSourceForNode((Tree)expression));
    }

    private static String className(ExpressionTree expression) {
        Type originalType = ASTHelpers.getResultType((ExpressionTree)expression);
        List<Type> arguments = originalType.getTypeArguments();
        String className = ((Name)originalType.tsym.getSimpleName()).toString();
        if (!arguments.isEmpty()) {
            String argumentString = arguments.stream().map(t -> ((Name)t.tsym.getSimpleName()).toString()).collect(Collectors.joining(", "));
            return String.format("%s<%s>", className, argumentString);
        }
        return className;
    }

    private static String annotationName(VariableTree tree, VisitorState state) {
        if (ASTHelpers.hasAnnotation((Tree)tree, (String)JUNIT_CLASS_RULE_IMPORT_PATH, (VisitorState)state)) {
            return "@ClassRule";
        }
        return "@Rule";
    }

    private static String classToVariableName(String className) {
        return String.format("%s%s", TEST_RULE_VAR_PREFIX, className).replace("<", "").replace(">", "").replace(",", "").replace(" ", "");
    }
}

