/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Math.abs does not always give a non-negative result. Please consider other methods for positive numbers.", severity=BugPattern.SeverityLevel.WARNING, altNames={"MathAbsoluteRandom"})
public final class MathAbsoluteNegative
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> POSSIBLY_NEGATIVE_ABS_VAL = Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.lang.Math").named("abs"), Matchers.argument((int)0, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("java.util.Random").namedAnyOf(new String[]{"nextInt", "nextLong"}).withNoParameters(), Matchers.instanceMethod().onDescendantOf("java.util.UUID").namedAnyOf(new String[]{"getLeastSignificantBits", "getMostSignificantBits"}).withNoParameters(), Matchers.instanceMethod().onDescendantOf("java.lang.Object").named("hashCode").withNoParameters(), Matchers.staticMethod().onClass("java.lang.System").named("identityHashCode"), Matchers.instanceMethod().onDescendantOf("com.google.common.hash.HashCode").namedAnyOf(new String[]{"asInt", "asLong", "padToLong"}).withNoParameters()}))});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (POSSIBLY_NEGATIVE_ABS_VAL.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

