/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Static fields should almost always be final.", severity=BugPattern.SeverityLevel.WARNING)
public final class NonFinalStaticField
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final ImmutableSet<String> ANNOTATIONS_TO_AVOID = ImmutableSet.of((Object)"Captor", (Object)"Inject", (Object)"LazyInit", (Object)"Mock", (Object)"TestParameter");
    private static final ImmutableSet<String> BEFORE_ALL_METHOD_ANNOTATIONS = ImmutableSet.of((Object)"org.junit.BeforeClass", (Object)"org.junit.jupiter.api.BeforeAll");

    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (!symbol.getKind().equals((Object)ElementKind.FIELD)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isStatic((Symbol)symbol)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isConsideredFinal((Symbol)symbol)) {
            return Description.NO_MATCH;
        }
        if (ANNOTATIONS_TO_AVOID.stream().anyMatch(anno -> ASTHelpers.hasDirectAnnotationWithSimpleName((Tree)tree, (String)anno))) {
            return Description.NO_MATCH;
        }
        IsMutated everMutatedInSameCompilationUnit = NonFinalStaticField.isEverMutatedInSameCompilationUnit(symbol, state);
        if (everMutatedInSameCompilationUnit == IsMutated.IN_BEFORE_METHOD) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.canBeRemoved((Symbol)symbol, (VisitorState)state) || everMutatedInSameCompilationUnit == IsMutated.TRUE) {
            return this.describeMatch(tree);
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.merge((SuggestedFix)SuggestedFixes.addModifiers((Tree)tree, (ModifiersTree)tree.getModifiers(), (VisitorState)state, (Set)ImmutableSet.of((Object)((Object)Modifier.FINAL))).orElse(SuggestedFix.emptyFix()), (SuggestedFix)SuggestedFixes.removeModifiers((ModifiersTree)tree.getModifiers(), (VisitorState)state, (Set)ImmutableSet.of((Object)((Object)Modifier.VOLATILE))).orElse(SuggestedFix.emptyFix()), (SuggestedFix[])new SuggestedFix[]{NonFinalStaticField.addDefaultInitializerIfNecessary(tree, state)}));
    }

    private static SuggestedFix addDefaultInitializerIfNecessary(VariableTree tree, VisitorState state) {
        if (tree.getInitializer() != null) {
            return SuggestedFix.emptyFix();
        }
        int pos = state.getEndPosition((Tree)tree) - 1;
        return SuggestedFix.replace((int)pos, (int)pos, (String)(" = " + NonFinalStaticField.getDefaultInitializer(tree, state)));
    }

    private static String getDefaultInitializer(VariableTree tree, VisitorState state) {
        Type type = ASTHelpers.getType((Tree)tree);
        Symtab symtab = state.getSymtab();
        if (ASTHelpers.isSameType((Type)type, (Type)symtab.booleanType, (VisitorState)state)) {
            return "false";
        }
        if (ASTHelpers.isSameType((Type)type, (Type)symtab.shortType, (VisitorState)state)) {
            return "(short) 0";
        }
        if (ASTHelpers.isSameType((Type)type, (Type)symtab.byteType, (VisitorState)state)) {
            return "(byte) 0";
        }
        if (ASTHelpers.isSameType((Type)type, (Type)symtab.charType, (VisitorState)state)) {
            return "(char) 0";
        }
        if (ASTHelpers.isSameType((Type)type, (Type)symtab.longType, (VisitorState)state) || ASTHelpers.isSameType((Type)type, (Type)symtab.intType, (VisitorState)state) || ASTHelpers.isSameType((Type)type, (Type)symtab.floatType, (VisitorState)state) || ASTHelpers.isSameType((Type)type, (Type)symtab.doubleType, (VisitorState)state)) {
            return "0";
        }
        return "null";
    }

    private static IsMutated isEverMutatedInSameCompilationUnit(final Symbol.VarSymbol symbol, final VisitorState state) {
        TreeScanner<Void, Void> scanner = new TreeScanner<Void, Void>(){
            IsMutated isMutated = IsMutated.FALSE;
            boolean inBeforeMethod = false;

            @Override
            public Void visitAssignment(AssignmentTree tree, Void unused) {
                if (Objects.equals(ASTHelpers.getSymbol((Tree)tree.getVariable()), symbol)) {
                    this.isMutated();
                }
                return (Void)super.visitAssignment(tree, null);
            }

            @Override
            public Void visitCompoundAssignment(CompoundAssignmentTree tree, Void unused) {
                if (Objects.equals(ASTHelpers.getSymbol((Tree)tree.getVariable()), symbol)) {
                    this.isMutated();
                }
                return (Void)super.visitCompoundAssignment(tree, null);
            }

            @Override
            public Void visitUnary(UnaryTree tree, Void unused) {
                if (Objects.equals(ASTHelpers.getSymbol((Tree)tree.getExpression()), symbol) && this.isMutating(tree.getKind())) {
                    this.isMutated();
                }
                return (Void)super.visitUnary(tree, null);
            }

            private void isMutated() {
                if (this.inBeforeMethod) {
                    this.isMutated = IsMutated.IN_BEFORE_METHOD;
                } else if (this.isMutated.equals((Object)IsMutated.FALSE)) {
                    this.isMutated = IsMutated.TRUE;
                }
            }

            private boolean isMutating(Tree.Kind kind) {
                switch (kind) {
                    case POSTFIX_DECREMENT: 
                    case POSTFIX_INCREMENT: 
                    case PREFIX_DECREMENT: 
                    case PREFIX_INCREMENT: {
                        return true;
                    }
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                boolean prev = this.inBeforeMethod;
                try {
                    this.inBeforeMethod |= BEFORE_ALL_METHOD_ANNOTATIONS.stream().anyMatch(annotation -> ASTHelpers.hasAnnotation((Tree)tree, (String)annotation, (VisitorState)state));
                    Void void_ = (Void)super.visitMethod(tree, null);
                    return void_;
                }
                finally {
                    this.inBeforeMethod = prev;
                }
            }
        };
        scanner.scan(state.getPath().getCompilationUnit(), null);
        return scanner.isMutated;
    }

    static enum IsMutated {
        TRUE,
        FALSE,
        IN_BEFORE_METHOD;

    }
}

