/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_UngroupedOverloads_MemberWithIndex;
import com.google.errorprone.bugpatterns.AutoValue_UngroupedOverloads_OverloadKey;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.Name;

@BugPattern(summary="Constructors and methods with the same name should appear sequentially with no other code in between, even when modifiers such as static or private differ between the methods. Please re-order or re-name methods.", severity=BugPattern.SeverityLevel.SUGGESTION)
public class UngroupedOverloads
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private final Boolean batchFindings;

    @Inject
    UngroupedOverloads(ErrorProneFlags flags) {
        this.batchFindings = flags.getBoolean("UngroupedOverloads:BatchFindings").orElse(false);
    }

    public Description matchClass(ClassTree classTree, VisitorState state) {
        LinkedHashMultimap methods = LinkedHashMultimap.create();
        for (int i = 0; i < classTree.getMembers().size(); ++i) {
            MethodTree methodTree;
            Tree member = classTree.getMembers().get(i);
            if (!(member instanceof MethodTree) || ASTHelpers.isGeneratedConstructor((MethodTree)(methodTree = (MethodTree)member))) continue;
            methods.put((Object)OverloadKey.create(methodTree), (Object)MemberWithIndex.create(i, methodTree));
        }
        ImmutableList descriptions = (ImmutableList)methods.asMap().entrySet().stream().flatMap(e -> this.checkOverloads(state, classTree.getMembers(), (ImmutableList<MemberWithIndex>)ImmutableList.copyOf((Collection)((Collection)e.getValue())))).collect(ImmutableList.toImmutableList());
        if (this.batchFindings.booleanValue() && !descriptions.isEmpty()) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            descriptions.forEach(d -> fix.merge((SuggestedFix)Iterables.getOnlyElement((Iterable)d.fixes)));
            return this.describeMatch(((Description)descriptions.get((int)0)).position, (Fix)fix.build());
        }
        descriptions.forEach(arg_0 -> ((VisitorState)state).reportMatch(arg_0));
        return Description.NO_MATCH;
    }

    private Stream<Description> checkOverloads(VisitorState state, List<? extends Tree> members, ImmutableList<MemberWithIndex> overloads) {
        if (overloads.size() <= 1) {
            return Stream.empty();
        }
        MemberWithIndex first = (MemberWithIndex)overloads.get(0);
        int prev = -1;
        int group = 0;
        LinkedHashMap<MemberWithIndex, Integer> groups = new LinkedHashMap<MemberWithIndex, Integer>();
        for (MemberWithIndex overload : overloads) {
            if (prev != -1 && prev != overload.index() - 1) {
                ++group;
            }
            groups.put(overload, group);
            prev = overload.index();
        }
        if (group == 0) {
            return Stream.empty();
        }
        if (overloads.stream().anyMatch(m -> this.isSuppressed(m.tree(), state))) {
            return Stream.empty();
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        StringBuilder sb = new StringBuilder("\n");
        sb.append(state.getSourceForNode((Tree)first.tree()));
        overloads.stream().filter(o -> o != first).forEach(o -> {
            int start = state.getEndPosition((Tree)members.get(o.index() - 1));
            int end = state.getEndPosition((Tree)o.tree());
            sb.append(state.getSourceCode(), start, end).append('\n');
            fixBuilder.replace(start, end, "");
        });
        fixBuilder.replace((Tree)first.tree(), sb.toString());
        SuggestedFix fix = fixBuilder.build();
        LineMap lineMap = state.getPath().getCompilationUnit().getLineMap();
        return overloads.stream().map(o -> this.buildDescription(o.tree()).addFix((Fix)fix).setMessage(UngroupedOverloads.createMessage(o.tree(), overloads, groups, lineMap, o)).build());
    }

    private static String createMessage(MethodTree tree, ImmutableList<MemberWithIndex> overloads, Map<MemberWithIndex, Integer> groups, LineMap lineMap, MemberWithIndex current) {
        String ungroupedLines = overloads.stream().filter(o -> !((Integer)groups.get(o)).equals(groups.get(current))).map(t -> lineMap.getLineNumber(ASTHelpers.getStartPosition((Tree)t.tree()))).map(String::valueOf).collect(Collectors.joining(", "));
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        String name = symbol.isConstructor() ? "constructor overloads" : String.format("overloads of '%s'", symbol.getSimpleName());
        return String.format("Overloads should be grouped together, even when modifiers such as static or private differ between the methods; found ungrouped %s on line(s): %s", name, ungroupedLines);
    }

    @AutoValue
    static abstract class OverloadKey {
        OverloadKey() {
        }

        abstract Name name();

        public static OverloadKey create(MethodTree methodTree) {
            Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)methodTree);
            return new AutoValue_UngroupedOverloads_OverloadKey(sym.getSimpleName());
        }
    }

    @AutoValue
    static abstract class MemberWithIndex {
        MemberWithIndex() {
        }

        abstract int index();

        abstract MethodTree tree();

        static MemberWithIndex create(int index, MethodTree tree) {
            return new AutoValue_UngroupedOverloads_MemberWithIndex(index, tree);
        }
    }
}

