/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Changes;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Heuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Parameter;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import org.jspecify.annotations.Nullable;

class LowInformationNameHeuristic
implements Heuristic {
    private static final ImmutableSet<String> DEFAULT_FORMAL_PARAMETER_EXCLUSION_REGEXS = ImmutableSet.of((Object)"[a-z][a-z]?[0-9]*", (Object)"arg[0-9]", (Object)"value", (Object)"key", (Object)"label", (Object)"param[0-9]", (Object[])new String[]{"str[0-9]"});
    private final ImmutableSet<String> overloadedNamesRegexs;

    LowInformationNameHeuristic(ImmutableSet<String> overloadedNamesRegexs) {
        this.overloadedNamesRegexs = overloadedNamesRegexs;
    }

    LowInformationNameHeuristic() {
        this(DEFAULT_FORMAL_PARAMETER_EXCLUSION_REGEXS);
    }

    @Override
    public boolean isAcceptableChange(Changes changes, Tree node, Symbol.MethodSymbol symbol, VisitorState state) {
        return changes.changedPairs().stream().allMatch(p -> this.findMatch(p.formal()) == null);
    }

    protected @Nullable String findMatch(Parameter parameter) {
        for (String regex : this.overloadedNamesRegexs) {
            if (!parameter.name().matches(regex)) continue;
            return regex;
        }
        return null;
    }
}

