/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm.types;

import com.dylibso.chicory.wasm.types.TableLimits;
import com.dylibso.chicory.wasm.types.ValueType;
import java.util.Objects;

public class Table {
    private final ValueType elementType;
    private final TableLimits limits;

    public Table(ValueType elementType, TableLimits limits) {
        this.elementType = Objects.requireNonNull(elementType, "elementType");
        if (!elementType.isReference()) {
            throw new IllegalArgumentException("Table element type must be a reference type");
        }
        this.limits = Objects.requireNonNull(limits, "limits");
    }

    public ValueType elementType() {
        return this.elementType;
    }

    public TableLimits limits() {
        return this.limits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Table)) {
            return false;
        }
        Table table = (Table)o;
        return this.elementType == table.elementType && Objects.equals(this.limits, table.limits);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.elementType, this.limits});
    }
}

