/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import org.jetbrains.annotations.Nullable;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.MethodDescriptor;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;

public class ReferencedClassesExtractor
implements MemberVisitor {
    private Clazz returnClass = null;
    private Clazz[] parameterClasses = null;

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.extractReferencedClasses(programClass, programMethod, programMethod.referencedClasses);
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        this.extractReferencedClasses(libraryClass, libraryMethod, libraryMethod.referencedClasses);
    }

    private void extractReferencedClasses(Clazz clazz, Method method, Clazz[] referencedClasses) {
        MethodDescriptor descriptor = new MethodDescriptor(method.getDescriptor(clazz));
        this.parameterClasses = new Clazz[descriptor.getArgumentTypes().size()];
        if (referencedClasses == null || referencedClasses.length == 0) {
            return;
        }
        if (!this.isPrimitiveOrPrimitiveArrayType(descriptor.getReturnType())) {
            this.returnClass = referencedClasses[referencedClasses.length - 1];
        }
        int referencedClassesIndex = 0;
        for (int i = 0; i < descriptor.getArgumentTypes().size(); ++i) {
            String argumentType = descriptor.getArgumentTypes().get(i);
            if (this.isPrimitiveOrPrimitiveArrayType(argumentType)) continue;
            this.getParameterClasses()[i] = referencedClasses[referencedClassesIndex++];
        }
    }

    private boolean isPrimitiveOrPrimitiveArrayType(String type) {
        return !ClassUtil.isInternalClassType(type);
    }

    @Nullable
    public Clazz getReturnClass() {
        return this.returnClass;
    }

    public Clazz[] getParameterClasses() {
        return this.parameterClasses;
    }
}

