/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.basic.AbstractBasicConverter;
import com.thoughtworks.xstream.converters.extended.StackTraceElementFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StackTraceElementConverter
extends AbstractBasicConverter {
    private static final Pattern PATTERN = Pattern.compile("^(.+)\\.([^\\(]+)\\(([^:]*)(:(\\d+))?\\)$");
    private final StackTraceElementFactory factory = new StackTraceElementFactory();
    static /* synthetic */ Class class$java$lang$StackTraceElement;

    public boolean canConvert(Class clazz) {
        return (class$java$lang$StackTraceElement == null ? (class$java$lang$StackTraceElement = StackTraceElementConverter.class$("java.lang.StackTraceElement")) : class$java$lang$StackTraceElement).equals(clazz);
    }

    protected Object fromString(String string) {
        Matcher matcher = PATTERN.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            if (string4.equals("Unknown Source")) {
                return this.factory.unknownSourceElement(string2, string3);
            }
            if (string4.equals("Native Method")) {
                return this.factory.nativeMethodElement(string2, string3);
            }
            if (matcher.group(4) != null) {
                int n = Integer.parseInt(matcher.group(5));
                return this.factory.element(string2, string3, string4, n);
            }
            return this.factory.element(string2, string3, string4);
        }
        throw new ConversionException("Could not parse StackTraceElement : " + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

