/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FieldDictionary {
    private final Map keyedByFieldNameCache = new TreeMap();
    private final Map keyedByFieldKeyCache = new TreeMap();
    static /* synthetic */ Class class$java$lang$Object;

    public Iterator serializableFieldsFor(Class clazz) {
        return this.buildMap(clazz, true).values().iterator();
    }

    public Field field(Class clazz, String string, Class clazz2) {
        Map map = this.buildMap(clazz, clazz2 != null);
        Field field = (Field)map.get(clazz2 != null ? new FieldKey(string, clazz2, 0) : string);
        if (field == null) {
            throw new ObjectAccessException("No such field " + clazz.getName() + "." + string);
        }
        return field;
    }

    private Map buildMap(Class clazz, boolean bl) {
        String string = clazz.getName();
        if (!this.keyedByFieldNameCache.containsKey(string)) {
            TreeMap<String, Field> treeMap = new TreeMap<String, Field>();
            OrderRetainingMap orderRetainingMap = new OrderRetainingMap();
            while (!(class$java$lang$Object == null ? FieldDictionary.class$("java.lang.Object") : class$java$lang$Object).equals(clazz)) {
                Field[] fieldArray = clazz.getDeclaredFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    Field field = fieldArray[i];
                    if (field.getName().startsWith("this$")) continue;
                    field.setAccessible(true);
                    if (!treeMap.containsKey(field.getName())) {
                        treeMap.put(field.getName(), field);
                    }
                    orderRetainingMap.put(new FieldKey(field.getName(), field.getDeclaringClass(), i), field);
                }
                clazz = clazz.getSuperclass();
            }
            this.keyedByFieldNameCache.put(string, treeMap);
            this.keyedByFieldKeyCache.put(string, orderRetainingMap);
        }
        return (Map)(bl ? this.keyedByFieldKeyCache.get(string) : this.keyedByFieldNameCache.get(string));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class OrderRetainingMap
    extends HashMap {
        private List valueOrder = new ArrayList();

        private OrderRetainingMap() {
        }

        public Object put(Object object, Object object2) {
            this.valueOrder.add(object2);
            return super.put(object, object2);
        }

        public Collection values() {
            return Collections.unmodifiableList(this.valueOrder);
        }
    }

    private static class FieldKey {
        private String fieldName;
        private Class declaringClass;
        private Integer depth;
        private int order;

        public FieldKey(String string, Class clazz, int n) {
            this.fieldName = string;
            this.declaringClass = clazz;
            this.order = n;
            Class clazz2 = clazz;
            int n2 = 0;
            while (clazz2.getSuperclass() != null) {
                ++n2;
                clazz2 = clazz2.getSuperclass();
            }
            this.depth = new Integer(n2);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof FieldKey)) {
                return false;
            }
            FieldKey fieldKey = (FieldKey)object;
            if (this.declaringClass != null ? !this.declaringClass.equals(fieldKey.declaringClass) : fieldKey.declaringClass != null) {
                return false;
            }
            return !(this.fieldName != null ? !this.fieldName.equals(fieldKey.fieldName) : fieldKey.fieldName != null);
        }

        public int hashCode() {
            int n = this.fieldName != null ? this.fieldName.hashCode() : 0;
            n = 29 * n + (this.declaringClass != null ? this.declaringClass.hashCode() : 0);
            return n;
        }

        public String toString() {
            return "FieldKey{order=" + this.order + ", depth=" + this.depth + ", declaringClass=" + this.declaringClass + ", fieldName='" + this.fieldName + "'" + "}";
        }
    }
}

