/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.codehaus.groovy.runtime.BigDecimalMath;
import org.codehaus.groovy.runtime.BigIntegerMath;
import org.codehaus.groovy.runtime.FloatingPointMath;
import org.codehaus.groovy.runtime.IntegerMath;
import org.codehaus.groovy.runtime.LongMath;

public abstract class NumberMath {
    public static Number abs(Number number) {
        return NumberMath.getMath(number).absImpl(number);
    }

    public static Number add(Number left, Number right) {
        return NumberMath.getMath(left, right).addImpl(left, right);
    }

    public static Number subtract(Number left, Number right) {
        return NumberMath.getMath(left, right).subtractImpl(left, right);
    }

    public static Number multiply(Number left, Number right) {
        return NumberMath.getMath(left, right).multiplyImpl(left, right);
    }

    public static Number divide(Number left, Number right) {
        return NumberMath.getMath(left, right).divideImpl(left, right);
    }

    public static int compareTo(Number left, Number right) {
        return NumberMath.getMath(left, right).compareToImpl(left, right);
    }

    public static boolean isFloatingPoint(Number number) {
        return number instanceof Double || number instanceof Float;
    }

    public static boolean isInteger(Number number) {
        return number instanceof Integer;
    }

    public static boolean isLong(Number number) {
        return number instanceof Long;
    }

    public static boolean isBigDecimal(Number number) {
        return number instanceof BigDecimal;
    }

    public static boolean isBigInteger(Number number) {
        return number instanceof BigInteger;
    }

    public static BigDecimal toBigDecimal(Number n) {
        return n instanceof BigDecimal ? (BigDecimal)n : new BigDecimal(n.toString());
    }

    public static BigInteger toBigInteger(Number n) {
        return n instanceof BigInteger ? (BigInteger)n : new BigInteger(n.toString());
    }

    private static NumberMath getMath(Number left, Number right) {
        if (NumberMath.isFloatingPoint(left) || NumberMath.isFloatingPoint(right)) {
            return FloatingPointMath.instance;
        }
        if (NumberMath.isBigDecimal(left) || NumberMath.isBigDecimal(right)) {
            return BigDecimalMath.instance;
        }
        if (NumberMath.isBigInteger(left) || NumberMath.isBigInteger(right)) {
            return BigIntegerMath.instance;
        }
        if (NumberMath.isLong(left) || NumberMath.isLong(right)) {
            return LongMath.instance;
        }
        return IntegerMath.instance;
    }

    private static NumberMath getMath(Number number) {
        if (NumberMath.isInteger(number)) {
            return IntegerMath.instance;
        }
        if (NumberMath.isLong(number)) {
            return LongMath.instance;
        }
        if (NumberMath.isFloatingPoint(number)) {
            return FloatingPointMath.instance;
        }
        if (NumberMath.isBigDecimal(number)) {
            return BigDecimalMath.instance;
        }
        if (NumberMath.isBigInteger(number)) {
            return BigIntegerMath.instance;
        }
        throw new IllegalArgumentException("An unexpected Number subclass was supplied.");
    }

    protected abstract Number absImpl(Number var1);

    protected abstract Number addImpl(Number var1, Number var2);

    protected abstract Number subtractImpl(Number var1, Number var2);

    protected abstract Number multiplyImpl(Number var1, Number var2);

    protected abstract Number divideImpl(Number var1, Number var2);

    protected abstract int compareToImpl(Number var1, Number var2);
}

