/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.AutoGridBagLayout;
import ccl.swing.ExitJDialog;
import ccl.swing.SwingUtil;
import ccl.util.FileUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextViewer
extends ExitJDialog {
    private static final Font FONT_COURIER = new Font("Monospaced", 0, 12);
    private JTextArea _pTextArea = null;
    private JButton _btnOK = null;

    public TextViewer(Frame frmParent_) {
        super(frmParent_, false);
        this.setTitle("Text Viewer");
        this._btnOK = new JButton("OK");
        this._btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event_) {
                TextViewer.this.setVisible(false);
            }
        });
        JPanel pnlMain = (JPanel)this.getContentPane();
        this._pTextArea = new JTextArea();
        this._pTextArea.setFont(FONT_COURIER);
        JScrollPane scpText = new JScrollPane(this._pTextArea);
        scpText.setBorder(SwingUtil.createCCLBorder());
        AutoGridBagLayout layout = new AutoGridBagLayout();
        layout.setLayoutOn(pnlMain);
        layout.setExpandBoth();
        layout.setFillBoth();
        layout.add(pnlMain, scpText);
        layout.setFillNone();
        layout.setExpandNone();
        layout.endLine();
        layout.add(pnlMain, Box.createVerticalStrut(5));
        layout.endLine();
        layout.add(pnlMain, this._btnOK);
        layout.endLine();
        layout.add(pnlMain, Box.createVerticalStrut(2));
        layout.endLine();
        Dimension dimScreen = SwingUtil.getScreenSize();
        int width = dimScreen.width * 3 / 4;
        int height = dimScreen.height * 3 / 4;
        this.setSize(width, height);
        SwingUtil.centerComponent(this);
    }

    public static void showTextFromFile(Frame frmParent_, String sFile_) {
        TextViewer viewer = new TextViewer(frmParent_);
        try {
            String sFileContent = FileUtil.readFile(sFile_);
            TextViewer.showText(frmParent_, sFileContent);
        }
        catch (IOException exception) {
            SwingUtil.showMessage(frmParent_, "Error while loading file '" + sFile_ + "'!");
            return;
        }
    }

    public static void showText(Frame frmParent_, String sContent_) {
        TextViewer viewer = new TextViewer(frmParent_);
        viewer._pTextArea.setText(sContent_);
        viewer.setVisible(true);
    }
}

