/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import ccl.swing.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.util.*;
import javax.swing.*;
import ccl.util.*;

/**
 * Select multiple items from a list or cancel.
 *
 * @version  $Id: ListCancelMultiSelector.java,v 1.12 2003/05/01 16:44:20 clemens Exp clemens $
 * @author   <a href="http://www.kclee.com/clemens/">
 *           Chr. Clemens Lee</a>
 *           &lt;<a href="mailto:clemens@kclee.com">
 *           clemens@kclee.com
 *           </a>>
 *
 * @deprecated   Use ListCancelSelector with multi select flag.
 */
public class ListCancelMultiSelector extends ExitJDialog 
{
    private static final int MAX_ELEMENTS = 20;
    private static final String S_TITLE = "Select";
    protected JList _lst;
    protected Vector _vValues;
    protected Vector _vSelected = new Vector();
    protected Vector _vOrigSelected;
    protected Vector _vIndexes = new Vector();
    protected Vector _vOrigIndexes = new Vector();
    private   OKCancelPanel _pOKCancelPanel = null;
    protected JLabel[] _alblHeadline;
    protected boolean _bOK = false;

    public ListCancelMultiSelector(Frame frmParent_, String sMessage_,
                                   Vector vsList_)
    {
        this( frmParent_, sMessage_, vsList_, new Vector() );
    }

    public ListCancelMultiSelector(Frame frmParent_, String sMessage_,
                                   Vector vsList_, Vector vsSelected_)
    {
        super(frmParent_, S_TITLE, true);
        
        Util.panicIf(vsList_ == null);
        
        _bOK = false;
        
        _vValues = (Vector)vsList_.clone();
        _vOrigSelected = (Vector)vsSelected_.clone();

        //getContentPane().setBackground( frmParent_.getBackground() );
        ((JPanel)getContentPane()).setBorder( BorderFactory.
                                              createEmptyBorder( 5, 5, 5, 5 ) );
        // Messages
        Vector vMessages = new Vector();
        vMessages = Util.stringToLines(sMessage_);
        JPanel pnlMessages = new JPanel();
        AutoGridBagLayout agblMessages = new AutoGridBagLayout();
        agblMessages.setExpandHorizontal();
        agblMessages.setFillHorizontal();
        agblMessages.setAnchor(GridBagConstraints.WEST);
        pnlMessages.setLayout(agblMessages);
        _alblHeadline = new JLabel[vMessages.size()];
        for(int line = 0; line < vMessages.size(); line++) 
{
            // Message
            String sLine = (String)vMessages.elementAt(line);
            JLabel lblLine = new JLabel(sLine);
            _alblHeadline[line] = lblLine;
            pnlMessages.add(lblLine);
            agblMessages.endLine();
        }
        getContentPane().add(pnlMessages, "North");
        
        // List
        int lines = Util.min(vsList_.size(), MAX_ELEMENTS);
        Util.debug("ListCancelMultiSelector.<init>(..).1");
        DefaultListModel pDefaultListModel = new DefaultListModel();
        _lst = new JList( pDefaultListModel );
        _lst.setSelectionMode( ListSelectionModel.MULTIPLE_INTERVAL_SELECTION );
        for(Enumeration e = vsList_.elements(); e.hasMoreElements(); ) 
{
            pDefaultListModel.addElement(e.nextElement());
        }
        JScrollPane scpList = new JScrollPane( _lst );
        scpList.setBorder( new CCLBorder() );

        getContentPane().add( scpList, "Center" );
        Util.debug("ListCancelMultiSelector.<init>(..).2");
        
        if (vsSelected_ != null) 
{
            for(Enumeration eSelected = vsSelected_.elements(); eSelected.hasMoreElements(); ) 
{
                String sNextSelected = (String)eSelected.nextElement();
                int index = vsList_.indexOf(sNextSelected);
                if (index != -1) 
{
                    _lst.setSelectedIndex(index);
                    _vOrigIndexes.addElement(new Integer(index));
                }
            }
        }
        Util.debug("ListCancelMultiSelector.<init>(..).3");
        
        // OK and Cancel buttons
        {
            JPanel pnlButtons = new JPanel();
            pnlButtons.setLayout( new BorderLayout() );

            pnlButtons.add( Box.createVerticalStrut( 5 ), 
                            BorderLayout.NORTH );

            pnlButtons.add( new JLabel(" "), BorderLayout.CENTER );

            _pOKCancelPanel = new OKCancelPanel( this );
            pnlButtons.add( _pOKCancelPanel, BorderLayout.EAST );
        
            getContentPane().add(pnlButtons, "South");
        }

        Util.debug("ListCancelMultiSelector.<init>(..).4");
        
        pack();
        setSize( 340, 340 );
        SwingUtil.centerComponent(this);
    }
    
    public boolean isOK() 
{
        return _bOK;
    }
    
    public Vector getValues() 
{
        if (!_bOK) 
{
            return(_vOrigSelected);
        }
        
        return _vSelected;
    }

    public Vector getIndexes() 
{
        if (!_bOK) 
{
            return(_vOrigIndexes);
        }
        
        return _vIndexes;
    }

    public void exit() 
{
        super.exit();
    }

    public void setVisible( boolean bVisible_ ) 
{
        if ( bVisible_ == false ) 
{
            if ( _pOKCancelPanel.isOK() == true ) 
{
                _vSelected = new Vector();
                int aiSelected[] = _lst.getSelectedIndices();
            
                for(int selected = 0; selected < aiSelected.length; selected++) 
{
                    _vSelected.addElement(_vValues.elementAt(aiSelected[selected]));
                    _vIndexes.addElement(new Integer(aiSelected[selected]));
                }
            
                _bOK = true;
            }
        }

        super.setVisible( bVisible_ );
    }

    /**
     * @return   null on cancel.
     */
    public static Vector input( Frame frmParent_, 
                                String sMessage_,
                                Vector vsList_ )
    {
        ListCancelMultiSelector dialog = 
               new ListCancelMultiSelector( frmParent_, 
                                            sMessage_,
                                            vsList_ );
        dialog.setVisible( true );

        if ( dialog.isOK() ) 
{
            return dialog.getValues();
        }

        // must be cancel;
        return null;
    }

    /**
     * @return   null on cancel.
     */
    public static Vector inputIndexes( Frame frmParent_, 
                                       String sMessage_,
                                       Vector vsList_ )
    {
        ListCancelMultiSelector dialog = 
               new ListCancelMultiSelector( frmParent_, 
                                            sMessage_,
                                            vsList_ );
        dialog.setVisible( true );

        if ( dialog.isOK() ) 
{
            return dialog.getIndexes();
        }

        // must be cancel;
        return null;
    }
}
