package ccl.swing.test;

import ccl.swing.CCLLineBorder;
import ccl.swing.GraphicsUtil;
/*import ccl.util.FileUtil;*/
import ccl.util.Test;
/*import ccl.util.Util;*/
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.image.BufferedImage;
/*import java.io.File;*/
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;

/**
 * Tests class CCLLineBorder.
 *
 * @version $Id: CCLLineBorderTest.java,v 1.1 2003/05/01 16:44:30 clemens Exp clemens $
 * @author  Chr. Clemens Lee
 */
public class CCLLineBorderTest extends Test 
{
    /**
     * Default test.
     */
    public void testCCLLineBorder()
        throws Exception
    {
        BufferedImage image = createImage( null );

        Border lineBorder = BorderFactory.createLineBorder( Color.black, 1 );
        BufferedImage lineImage = createImage( lineBorder );

        Assert( GraphicsUtil.equals( image, lineImage ) == false );

        Border emptyCCLLineBorder = new CCLLineBorder( Color.black, new Insets( 0, 0, 0, 0 ) );
        BufferedImage emptyCCLLineImage = createImage( emptyCCLLineBorder );

        Assert( GraphicsUtil.equals( image, emptyCCLLineImage ) );

        Border cclLineBorder = new CCLLineBorder( Color.black, new Insets( 1, 1, 1, 1 ) );
        BufferedImage cclLineImage = createImage( cclLineBorder );

        Assert( GraphicsUtil.equals( lineImage, cclLineImage ) );

        Border thickLineBorder = BorderFactory.createLineBorder( Color.black, 3 );
        BufferedImage thickLineImage = createImage( thickLineBorder );

        Border thickCCLLineBorder = new CCLLineBorder( Color.black, new Insets( 3, 3, 3, 3 ) );
        BufferedImage thickCCLLineImage = createImage( thickCCLLineBorder );

        Assert( GraphicsUtil.equals( thickLineImage, thickCCLLineImage ) );
    }

    /**
     * Returns image of the given panel.
     */
    private BufferedImage createImage( Border border )
        throws IOException 
    {
        JPanel panel = new JPanel();        
        panel.setSize         ( new Dimension( 100, 100 ) );
        panel.setPreferredSize( new Dimension( 100, 100 ) );
        panel.setMinimumSize  ( new Dimension( 100, 100 ) );
        panel.setMaximumSize  ( new Dimension( 100, 100 ) );
        panel.setBackground( Color.white );

        panel.setBorder( border );

        JFrame frame = new JFrame( "CCLLineBorderTest" );
        frame.getContentPane().setBackground( Color.red );
        
        frame.getContentPane().setLayout( null );
        
        frame.getContentPane().add( panel );
        panel.setLocation( 50, 50 );
        
        frame.pack();
        frame.setSize( 200, 200 );
        frame.setVisible( true );
        /*
          Util.sleep( 2 );
        // */
        BufferedImage image = GraphicsUtil.componentToImage( panel, (new JFrame()).getContentPane() );
        /*
          String tempFileName = FileUtil.getTempDir() + File.separator + "__ccllineborder.gif";
          Util.println( tempFileName );
          GraphicsUtil.saveImageAsGIF( tempFileName, image );
          // */
        
        frame.setVisible( false );
        frame.dispose();
        
        return image;
    }
    
    /**
     * Default constructor.
     */
    public CCLLineBorderTest() {
        super();
    }

    /**
     * Standard constructor.
     */
    public CCLLineBorderTest( Test pTest_ ) {
        super( pTest_ );
    }

    /**
     * Main test routine.
     *
     * @exception   Exception   if anything goes wrong the test fails as well.
     */
    protected void _doIt()
        throws Exception
    {
        testCCLLineBorder();
    }

    /**
     * Main method if test class should be run individually.
     */
    public static void main( String[] asArg_ ) {
        Test pTest = (Test)(new CCLLineBorderTest());
        pTest.setVerbose( true );
        pTest.run();
        pTest.printResult();

        System.exit( 0 );
    }
}
