/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.tag;

import org.outerj.daisy.diff.tag.Atom;

public class TagAtom
implements Atom {
    private String identifier;
    private String internalIdentifiers = "";

    public TagAtom(String string) {
        if (!this.isValidAtom(string)) {
            throw new IllegalArgumentException("The given string is not a valid tag");
        }
        if ((string = string.substring(1, string.length() - 1)).indexOf(32) > 0) {
            this.identifier = string.substring(0, string.indexOf(32));
            this.internalIdentifiers = string.substring(string.indexOf(32) + 1);
        } else {
            this.identifier = string;
        }
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getInternalIdentifiers() {
        return this.internalIdentifiers;
    }

    @Override
    public boolean hasInternalIdentifiers() {
        return this.internalIdentifiers.length() > 0;
    }

    public static boolean isValidTag(String string) {
        return string.lastIndexOf(60) == 0 && string.indexOf(62) == string.length() - 1 && string.length() >= 3;
    }

    @Override
    public String getFullText() {
        String string = "<" + this.identifier;
        if (this.hasInternalIdentifiers()) {
            string = string + " " + this.internalIdentifiers;
        }
        string = string + ">";
        return string;
    }

    @Override
    public boolean isValidAtom(String string) {
        return TagAtom.isValidTag(string);
    }

    public String toString() {
        return "TagAtom: " + this.getFullText();
    }

    @Override
    public boolean equalsIdentifier(Atom atom) {
        return atom.getIdentifier().equals(this.getIdentifier());
    }
}

