/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.ClassEnv;
import jas.CodeAttr;
import jas.InsnOperand;
import jas.RuntimeConstants;
import java.io.DataOutputStream;
import java.io.IOException;

class UnsignedByteWideOperand
extends InsnOperand
implements RuntimeConstants {
    int val;
    boolean Wide;

    UnsignedByteWideOperand(int n, boolean Wide) {
        this.val = n;
        this.Wide = Wide || this.val > 255;
    }

    @Override
    int size(ClassEnv ce, CodeAttr code) {
        return this.Wide ? 3 : 1;
    }

    @Override
    void writePrefix(ClassEnv e, CodeAttr ce, DataOutputStream out) throws IOException {
        if (this.Wide) {
            out.writeByte(-60);
        }
    }

    @Override
    void write(ClassEnv e, CodeAttr ce, DataOutputStream out) throws IOException {
        if (this.Wide) {
            out.writeShort((short)(0xFFFF & this.val));
        } else {
            out.writeByte((byte)(this.val & 0xFF));
        }
    }

    @Override
    void resolve(ClassEnv e) {
    }
}

