/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.DexType;
import com.googlecode.dex2jar.Field;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.visitors.DexAnnotationAble;
import com.googlecode.dex2jar.visitors.DexAnnotationVisitor;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;

public class AnnotationNode
implements DexAnnotationVisitor {
    public String type;
    public boolean visible;
    protected List<Item> items = new ArrayList<Item>(5);

    public static void accept(String name, Object v, AnnotationVisitor av) {
        if (v instanceof AnnotationNode) {
            AnnotationNode a = (AnnotationNode)v;
            AnnotationVisitor av1 = av.visitAnnotation(name, a.type);
            AnnotationNode.accept(a.items, av1);
            av1.visitEnd();
        } else if (v instanceof Field) {
            Field e = (Field)v;
            av.visitEnum(name, e.getOwner(), e.getName());
        } else if (v instanceof List) {
            List list = (List)v;
            AnnotationVisitor av1 = av.visitArray(name);
            for (Object i : list) {
                AnnotationNode.accept(null, i, av1);
            }
            av1.visitEnd();
        } else if (v instanceof Method) {
            av.visit(name, v);
        } else if (v instanceof DexType) {
            av.visit(name, (Object)((DexType)v).desc);
        } else {
            av.visit(name, v);
        }
    }

    private static void accept(List<Item> items, AnnotationVisitor av) {
        for (Item item : items) {
            AnnotationNode.accept(item.name, item.value, av);
        }
    }

    public static void accept(String name, Object v, DexAnnotationVisitor av) {
        if (v instanceof AnnotationNode) {
            AnnotationNode a = (AnnotationNode)v;
            DexAnnotationVisitor av1 = av.visitAnnotation(name, a.type);
            AnnotationNode.accept(a.items, av1);
            av1.visitEnd();
        } else if (v instanceof Field) {
            Field e = (Field)v;
            av.visitEnum(name, e.getOwner(), e.getName());
        } else if (v instanceof List) {
            List list = (List)v;
            DexAnnotationVisitor av1 = av.visitArray(name);
            for (Object i : list) {
                AnnotationNode.accept(null, i, av1);
            }
            av1.visitEnd();
        } else if (v instanceof Field) {
            Field e = (Field)v;
            av.visitEnum(name, e.getOwner(), e.getName());
        } else if (v instanceof Method) {
            av.visit(name, v);
        } else {
            av.visit(name, v);
        }
    }

    private static void accept(List<Item> items, DexAnnotationVisitor av) {
        for (Item item : items) {
            AnnotationNode.accept(item.name, item.value, av);
        }
    }

    public AnnotationNode() {
    }

    public AnnotationNode(String type, boolean visible) {
        this.type = type;
        this.visible = visible;
    }

    public void accept(DexAnnotationAble a) {
        DexAnnotationVisitor av = a.visitAnnotation(this.type, this.visible);
        AnnotationNode.accept(this.items, av);
        av.visitEnd();
    }

    public void accept(DexAnnotationVisitor av) {
        AnnotationNode.accept(this.items, av);
    }

    public void accept(FieldVisitor fv) {
        AnnotationVisitor av = fv.visitAnnotation(this.type, this.visible);
        AnnotationNode.accept(this.items, av);
        av.visitEnd();
    }

    public void visit(String name, Object value) {
        this.items.add(new Item(name, value));
    }

    public DexAnnotationVisitor visitAnnotation(String name, String desc) {
        AnnotationNode ann = new AnnotationNode(desc, true);
        this.items.add(new Item(name, ann));
        return ann;
    }

    public DexAnnotationVisitor visitArray(String name) {
        ArrayList<Object> list = new ArrayList<Object>(5);
        this.items.add(new Item(name, list));
        return new ArrayV(list);
    }

    public void visitEnd() {
    }

    public void visitEnum(String name, String desc, String value) {
        this.items.add(new Item(name, new Field(desc, value, null)));
    }

    public void accept(ClassVisitor cv) {
        AnnotationVisitor av = cv.visitAnnotation(this.type, this.visible);
        AnnotationNode.accept(this.items, av);
        av.visitEnd();
    }

    private static class ArrayV
    implements DexAnnotationVisitor {
        List<Object> list;

        public ArrayV(List<Object> list2) {
            this.list = list2;
        }

        public void visit(String name, Object value) {
            this.list.add(value);
        }

        public void visitEnum(String name, String desc, String value) {
            this.list.add(new Field(desc, value, null));
        }

        public DexAnnotationVisitor visitAnnotation(String name, String desc) {
            AnnotationNode node = new AnnotationNode(desc, true);
            this.list.add(node);
            return node;
        }

        public DexAnnotationVisitor visitArray(String name) {
            ArrayList<Object> list = new ArrayList<Object>(5);
            list.add(list);
            return new ArrayV(list);
        }

        public void visitEnd() {
        }
    }

    public static class Item {
        public String name;
        public Object value;

        public Item(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

