/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.DexException;
import com.googlecode.dex2jar.reader.DexFileReader;
import com.googlecode.dex2jar.reader.io.DataIn;
import com.googlecode.dex2jar.v3.ClassVisitorFactory;
import com.googlecode.dex2jar.v3.DexExceptionHandler;
import com.googlecode.dex2jar.v3.V3;
import com.googlecode.dex2jar.v3.V3InnerClzGather;
import com.googlecode.dex2jar.visitors.DexClassVisitor;
import com.googlecode.dex2jar.visitors.DexFileVisitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class Dex2jar {
    private DexExceptionHandler exceptionHandler;
    private final DexFileReader reader;
    private int readerConfig;
    private boolean verbose = false;
    private int v3Config;
    private Set<String> dirs = new HashSet<String>();

    public static Dex2jar from(byte[] in) throws IOException {
        return Dex2jar.from(new DexFileReader(in));
    }

    public static Dex2jar from(DataIn in) throws IOException {
        return Dex2jar.from(new DexFileReader(in));
    }

    public static Dex2jar from(DexFileReader reader) {
        return new Dex2jar(reader);
    }

    public static Dex2jar from(File in) throws IOException {
        return Dex2jar.from(new DexFileReader(in));
    }

    public static Dex2jar from(InputStream in) throws IOException {
        return Dex2jar.from(new DexFileReader(in));
    }

    public static Dex2jar from(String in) throws IOException {
        return Dex2jar.from(new File(in));
    }

    private Dex2jar(DexFileReader reader) {
        this.reader = reader;
        this.readerConfig |= 1;
    }

    private void doTranslate(final Object dist) throws IOException {
        if (this.reader.isOdex()) {
            throw new DexException("dex-translator not support translate an odex file, please refere smali http://code.google.com/p/smali/ to convert odex to dex");
        }
        V3InnerClzGather afa = new V3InnerClzGather();
        this.reader.accept((DexFileVisitor)afa, 5);
        try {
            this.reader.accept((DexFileVisitor)new V3(afa.getClasses(), this.exceptionHandler, new ClassVisitorFactory(){

                @Override
                public ClassVisitor create(final String name) {
                    return new ClassWriter(1){

                        public void visitEnd() {
                            super.visitEnd();
                            try {
                                byte[] data = this.toByteArray();
                                Dex2jar.this.saveTo(data, name, dist);
                            }
                            catch (IOException e) {
                                e.printStackTrace(System.err);
                            }
                        }
                    };
                }
            }, this.v3Config){

                @Override
                public DexClassVisitor visit(int access_flags, String className, String superClass, String[] interfaceNames) {
                    if (Dex2jar.this.verbose) {
                        System.err.println("Processing " + className);
                    }
                    return super.visit(access_flags, className, superClass, interfaceNames);
                }
            }, this.readerConfig);
        }
        catch (Exception e) {
            if (this.exceptionHandler == null) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
            this.exceptionHandler.handleFileException(e);
        }
    }

    public DexExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public DexFileReader getReader() {
        return this.reader;
    }

    public Dex2jar reUseReg(boolean b) {
        this.v3Config = b ? (this.v3Config |= 1) : (this.v3Config &= 0xFFFFFFFE);
        return this;
    }

    public Dex2jar topoLogicalSort(boolean b) {
        this.v3Config = b ? (this.v3Config |= 2) : (this.v3Config &= 0xFFFFFFFD);
        return this;
    }

    public Dex2jar verbose() {
        this.verbose = true;
        return this;
    }

    public Dex2jar verbose(boolean b) {
        this.verbose = b;
        return this;
    }

    public Dex2jar optimizeSynchronized(boolean b) {
        this.v3Config = b ? (this.v3Config |= 8) : (this.v3Config &= 0xFFFFFFF7);
        return this;
    }

    public Dex2jar printIR(boolean b) {
        this.v3Config = b ? (this.v3Config |= 4) : (this.v3Config &= 0xFFFFFFFB);
        return this;
    }

    public Dex2jar reUseReg() {
        this.v3Config |= 1;
        return this;
    }

    public Dex2jar optimizeSynchronized() {
        this.v3Config |= 8;
        return this;
    }

    public Dex2jar printIR() {
        this.v3Config |= 4;
        return this;
    }

    public Dex2jar topoLogicalSort() {
        this.v3Config |= 2;
        return this;
    }

    private void check(String dir, ZipOutputStream zos) throws IOException {
        if (this.dirs.contains(dir)) {
            return;
        }
        this.dirs.add(dir);
        int i = dir.lastIndexOf(47);
        if (i > 0) {
            this.check(dir.substring(0, i), zos);
        }
        zos.putNextEntry(new ZipEntry(String.valueOf(dir) + "/"));
        zos.closeEntry();
    }

    private void saveTo(byte[] data, String name, Object dist) throws IOException {
        if (dist instanceof ZipOutputStream) {
            ZipOutputStream zos = (ZipOutputStream)dist;
            ZipEntry entry = new ZipEntry(String.valueOf(name) + ".class");
            int i = name.lastIndexOf(47);
            if (i > 0) {
                this.check(name.substring(0, i), zos);
            }
            zos.putNextEntry(entry);
            zos.write(data);
            zos.closeEntry();
        } else {
            File dir = (File)dist;
            FileUtils.writeByteArrayToFile((File)new File(dir, String.valueOf(name) + ".class"), (byte[])data);
        }
    }

    public void setExceptionHandler(DexExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public Dex2jar skipDebug(boolean b) {
        this.readerConfig = b ? (this.readerConfig |= 1) : (this.readerConfig &= 0xFFFFFFFE);
        return this;
    }

    public Dex2jar skipDebug() {
        this.readerConfig |= 1;
        return this;
    }

    public void to(File file) throws IOException {
        if (file.exists() && file.isDirectory()) {
            this.doTranslate(file);
        } else {
            FileOutputStream fos = FileUtils.openOutputStream((File)file);
            try {
                this.to(fos);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)fos);
            }
        }
    }

    public void to(OutputStream os) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        this.doTranslate(zos);
        zos.finish();
    }

    public void to(String file) throws IOException {
        this.to(new File(file));
    }

    public Dex2jar withExceptionHandler(DexExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }
}

