/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.dex2jar.ir.ET;
import com.googlecode.dex2jar.reader.DexFileReader;
import com.googlecode.dex2jar.tools.BaseCmd;
import com.googlecode.dex2jar.v3.Dex2jar;
import com.googlecode.dex2jar.v3.DexExceptionHandlerImpl;
import com.googlecode.dex2jar.v3.Main;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class Dex2jarCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="e", longOpt="exception-file", description="detail exception file, default is $current_dir/[file-name]-error.zip", argName="file")
    private File exceptionFile;
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="n", longOpt="not-handle-exception", hasArg=false, description="not handle any exception throwed by dex2jar")
    private boolean notHandleException = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output .jar file, default is $current_dir/[file-name]-dex2jar.jar", argName="out-jar-file")
    private File output;
    @BaseCmd.Opt(opt="r", longOpt="reuse-reg", hasArg=false, description="reuse regiter while generate java .class file")
    private boolean reuseReg = false;
    @BaseCmd.Opt(opt="s", hasArg=false, description="same with --topological-sort/-ts")
    private boolean topologicalSort1 = false;
    @BaseCmd.Opt(opt="v", longOpt="verbose", hasArg=false, description="show progress")
    private boolean verbose = false;
    @BaseCmd.Opt(opt="ts", longOpt="topological-sort", hasArg=false, description="sort block by topological, that will generate more readable code")
    private boolean topologicalSort = false;
    @BaseCmd.Opt(opt="d", longOpt="debug-info", hasArg=false, description="translate debug info")
    private boolean debugInfo = false;
    @BaseCmd.Opt(opt="p", longOpt="print-ir", hasArg=false, description="print ir to Syste.out")
    private boolean printIR = false;
    @BaseCmd.Opt(opt="os", longOpt="optmize-synchronized", hasArg=false, description="optmize-synchronized")
    private boolean optmizeSynchronized = false;

    public static void main(String[] args) {
        new Dex2jarCmd().doMain(args);
    }

    public Dex2jarCmd() {
        super("d2j-dex2jar [options] <file0> [file1 ... fileN]", "convert dex to jar");
    }

    @Override
    protected void doCommandLine() throws Exception {
        File file;
        String fileName;
        int n;
        int n2;
        String[] stringArray;
        if (this.remainingArgs.length == 0) {
            this.usage();
            return;
        }
        if ((this.exceptionFile != null || this.output != null) && this.remainingArgs.length != 1) {
            System.err.println("-e/-o can only used with one file");
            return;
        }
        if (this.debugInfo && this.reuseReg) {
            System.err.println("-d/-r can not use together");
            return;
        }
        if (this.output != null) {
            if (this.output.exists() && !this.forceOverwrite) {
                System.err.println(this.output + " exists, use --force to overwrite");
                return;
            }
        } else {
            stringArray = this.remainingArgs;
            n2 = this.remainingArgs.length;
            n = 0;
            while (n < n2) {
                fileName = stringArray[n];
                file = new File(String.valueOf(FilenameUtils.getBaseName((String)fileName)) + "-dex2jar.jar");
                if (file.exists() && !this.forceOverwrite) {
                    System.err.println(file + " exists, use --force to overwrite");
                    return;
                }
                ++n;
            }
        }
        stringArray = this.remainingArgs;
        n2 = this.remainingArgs.length;
        n = 0;
        while (n < n2) {
            Map exceptions;
            fileName = stringArray[n];
            file = this.output == null ? new File(String.valueOf(FilenameUtils.getBaseName((String)fileName)) + "-dex2jar.jar") : this.output;
            System.err.println("dex2jar " + fileName + " -> " + file);
            DexFileReader reader = new DexFileReader(new File(fileName));
            DexExceptionHandlerImpl handler = this.notHandleException ? null : new DexExceptionHandlerImpl().skipDebug(!this.debugInfo);
            Dex2jar.from((DexFileReader)reader).withExceptionHandler(handler).reUseReg(this.reuseReg).topoLogicalSort(this.topologicalSort || this.topologicalSort1).skipDebug(!this.debugInfo).optimizeSynchronized(this.optmizeSynchronized).printIR(this.printIR).verbose(this.verbose).to(file);
            if (!this.notHandleException && (exceptions = handler.getExceptions()) != null && exceptions.size() > 0) {
                File errorFile = this.exceptionFile == null ? new File(String.valueOf(FilenameUtils.getBaseName((String)fileName)) + "-error.zip") : this.exceptionFile;
                handler.dumpException(reader, errorFile);
                System.err.println("Detail Error Information in File " + errorFile);
                System.err.println("Please report this file to http://code.google.com/p/dex2jar/issues/entry if possible.");
            }
            ++n;
        }
    }

    @Override
    protected String getVersionString() {
        return "reader-" + DexFileReader.class.getPackage().getImplementationVersion() + ", translator-" + Main.class.getPackage().getImplementationVersion() + ", ir-" + ET.class.getPackage().getImplementationVersion();
    }
}

