/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.ir.Constant;
import com.googlecode.dex2jar.ir.ET;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.reader.DexFileReader;
import com.googlecode.dex2jar.util.ASMifierCodeV;
import com.googlecode.dex2jar.util.Escape;
import com.googlecode.dex2jar.util.Out;
import com.googlecode.dex2jar.v3.DexExceptionHandler;
import com.googlecode.dex2jar.v3.IrMethod2AsmMethod;
import com.googlecode.dex2jar.v3.Main;
import com.googlecode.dex2jar.visitors.DexClassVisitor;
import com.googlecode.dex2jar.visitors.DexCodeVisitor;
import com.googlecode.dex2jar.visitors.DexFileVisitor;
import com.googlecode.dex2jar.visitors.DexMethodVisitor;
import com.googlecode.dex2jar.visitors.EmptyVisitor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class DexExceptionHandlerImpl
implements DexExceptionHandler {
    private int readerConfig = 1;
    private Map<Method, Exception> exceptions = new HashMap<Method, Exception>();

    public Map<Method, Exception> getExceptions() {
        return this.exceptions;
    }

    @Override
    public void handleFileException(Exception e) {
        e.printStackTrace(System.err);
    }

    @Override
    public void handleMethodTranslateException(Method method, IrMethod irMethod, MethodNode methodNode, Exception e) {
        this.exceptions.put(method, e);
        StringWriter s = new StringWriter();
        e.printStackTrace(new PrintWriter(s));
        String msg = s.toString();
        methodNode.instructions.clear();
        methodNode.tryCatchBlocks.clear();
        irMethod.traps.clear();
        irMethod.stmts.clear();
        irMethod.stmts.add((Stmt)Stmts.nThrow((Value)Exprs.nInvokeNew((Value[])new Value[]{Constant.nString((String)("Generated by Dex2jar, and Some Exception Caught :" + msg))}, (Type[])new Type[]{Type.getType(String.class)}, (Type)Type.getType(RuntimeException.class))));
        new IrMethod2AsmMethod().convert(irMethod, (MethodVisitor)methodNode);
    }

    public static String getVersionString() {
        return "version: reader-" + DexFileReader.class.getPackage().getImplementationVersion() + ", translator-" + Main.class.getPackage().getImplementationVersion() + ", ir-" + ET.class.getPackage().getImplementationVersion();
    }

    public DexExceptionHandlerImpl skipDebug(boolean b) {
        this.readerConfig = b ? (this.readerConfig |= 1) : (this.readerConfig &= 0xFFFFFFFE);
        return this;
    }

    public DexExceptionHandlerImpl skipDebug() {
        this.readerConfig |= 1;
        return this;
    }

    public void dumpException(DexFileReader reader, File errorFile) throws IOException {
        for (Map.Entry<Method, Exception> e : this.exceptions.entrySet()) {
            System.err.println("Error:" + e.getKey().toString() + "->" + e.getValue().getMessage());
        }
        final ZipOutputStream errorZipOutputStream = new ZipOutputStream(FileUtils.openOutputStream((File)errorFile));
        errorZipOutputStream.putNextEntry(new ZipEntry("summary.txt"));
        final PrintWriter fw = new PrintWriter(new OutputStreamWriter((OutputStream)errorZipOutputStream, "UTF-8"));
        fw.println(DexExceptionHandlerImpl.getVersionString());
        fw.println("there are " + this.exceptions.size() + " error methods");
        fw.print("options: ");
        if ((this.readerConfig & 1) == 0) {
            fw.print(" -d");
        }
        fw.println();
        fw.flush();
        errorZipOutputStream.closeEntry();
        final Out out = new Out(){

            public void pop() {
            }

            public void push() {
            }

            public void s(String s) {
                fw.println(s);
            }

            public void s(String format, Object ... arg) {
                fw.println(String.format(format, arg));
            }
        };
        final int[] count = new int[1];
        reader.accept((DexFileVisitor)new EmptyVisitor(){

            public DexClassVisitor visit(int accessFlags, String className, String superClass, String[] interfaceNames) {
                return new EmptyVisitor(){

                    public DexMethodVisitor visitMethod(final int accessFlags, final Method method) {
                        if (DexExceptionHandlerImpl.this.exceptions.containsKey(method)) {
                            return new EmptyVisitor(){

                                public DexCodeVisitor visitCode() {
                                    try {
                                        int n = count[0];
                                        count[0] = n + 1;
                                        errorZipOutputStream.putNextEntry(new ZipEntry("t" + n + ".txt"));
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                    Exception exception = (Exception)DexExceptionHandlerImpl.this.exceptions.get(method);
                                    exception.printStackTrace(fw);
                                    out.s("");
                                    out.s("DexMethodVisitor mv=cv.visitMethod(%s, %s);", new Object[]{Escape.methodAcc((int)accessFlags), Escape.v((Method)method)});
                                    out.s("DexCodeVisitor code = mv.visitCode();");
                                    return new ASMifierCodeV(out);
                                }

                                public void visitEnd() {
                                    out.s("mv.visitEnd();");
                                    fw.flush();
                                    try {
                                        errorZipOutputStream.closeEntry();
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            };
                        }
                        return null;
                    }
                };
            }
        }, this.readerConfig);
        errorZipOutputStream.close();
    }
}

