/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.DexException;
import com.googlecode.dex2jar.ir.Constant;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Local;
import com.googlecode.dex2jar.ir.LocalVar;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ValueBox;
import com.googlecode.dex2jar.ir.expr.ArrayExpr;
import com.googlecode.dex2jar.ir.expr.CastExpr;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.FieldExpr;
import com.googlecode.dex2jar.ir.expr.FilledArrayExpr;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.NewExpr;
import com.googlecode.dex2jar.ir.expr.NewMutiArrayExpr;
import com.googlecode.dex2jar.ir.expr.RefExpr;
import com.googlecode.dex2jar.ir.expr.TypeExpr;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.JumpStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.LookupSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.TableSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.UnopStmt;
import com.googlecode.dex2jar.ir.ts.BaseLiveAnalyze;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.LiveAnalyze;
import com.googlecode.dex2jar.ir.ts.LocalType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class IrMethod2AsmMethod
implements Opcodes {
    private boolean reuseReg = false;
    private boolean optimizeSynchronized = false;

    public IrMethod2AsmMethod() {
    }

    public IrMethod2AsmMethod(boolean reuseReg) {
        this.reuseReg = reuseReg;
    }

    public IrMethod2AsmMethod(int config) {
        this.reuseReg = (config & 1) != 0;
        this.optimizeSynchronized = (config & 8) != 0;
    }

    private void reIndexLocalReuseReg(IrMethod ir) {
        LiveAnalyze la = new LiveAnalyze(ir);
        la.analyze();
        List phis = la.phis;
        int index = 0;
        if ((ir.access & 8) == 0) {
            ++index;
        }
        int localSize = ir.locals.size();
        int[] parameterIdx = new int[ir.args.length];
        int i = 0;
        while (i < ir.args.length) {
            parameterIdx[i] = index;
            index += ir.args[i].getSize();
            ++i;
        }
        int[] maps = new int[localSize];
        int i2 = 0;
        while (i2 < localSize) {
            maps[i2] = -1;
            ++i2;
        }
        Local _thisLocal = null;
        Local[] _parameterLocals = new Local[ir.args.length];
        Stmt stmt = ir.stmts.getFirst();
        while (stmt != null) {
            if (stmt.st == Stmt.ST.IDENTITY || stmt.st == Stmt.ST.ASSIGN) {
                Stmt.E2Stmt e2 = (Stmt.E2Stmt)stmt;
                switch (e2.op2.value.vt) {
                    case THIS_REF: {
                        Local local = (Local)e2.op1.value;
                        maps[local._ls_index] = 0;
                        _thisLocal = local;
                        break;
                    }
                    case PARAMETER_REF: {
                        Local local = (Local)e2.op1.value;
                        int i3 = ((RefExpr)e2.op2.value).parameterIndex;
                        maps[local._ls_index] = parameterIdx[i3];
                        _parameterLocals[i3] = local;
                    }
                }
            }
            stmt = stmt.getNext();
        }
        this.createGraph(ir, phis.size());
        if ((ir.access & 8) == 0 && _thisLocal != null) {
            this.markPhiNeverReuse(phis, _thisLocal);
        }
        Local[] localArray = _parameterLocals;
        int n = _parameterLocals.length;
        int n2 = 0;
        while (n2 < n) {
            Local local = localArray[n2];
            if (local != null) {
                this.markPhiNeverReuse(phis, local);
            }
            ++n2;
        }
        this.gradyColoring(phis, maps);
        for (Local local : ir.locals) {
            local._ls_index = maps[local._ls_index];
        }
    }

    private void markPhiNeverReuse(List<BaseLiveAnalyze.Phi> phis, Local local) {
        LiveAnalyze.LivePhi nPhi = null;
        for (BaseLiveAnalyze.Phi x : phis) {
            LiveAnalyze.LivePhi phi = (LiveAnalyze.LivePhi)x;
            if (phi.local != local) continue;
            nPhi = phi;
            break;
        }
        if (nPhi == null) {
            nPhi = new LiveAnalyze.LivePhi();
            nPhi.local = local;
        }
        for (BaseLiveAnalyze.Phi phi : phis) {
            if (phi == nPhi) continue;
            phi.parents.add(nPhi);
            nPhi.parents.add(phi);
        }
    }

    private int findNextColor(BaseLiveAnalyze.Phi v, int n, int max, int[] maps) {
        BitSet bs = new BitSet(max);
        bs.set(0, max);
        for (BaseLiveAnalyze.Phi t : v.parents) {
            LiveAnalyze.LivePhi one = (LiveAnalyze.LivePhi)t;
            int x = maps[one.local._ls_index];
            if (x < 0) continue;
            bs.clear(x);
            if (IrMethod2AsmMethod.sizeOf((BaseLiveAnalyze.Phi)one) <= 1) continue;
            bs.clear(x + 1);
        }
        boolean wide = IrMethod2AsmMethod.sizeOf(v) > 1;
        int i = bs.nextSetBit(n);
        while (i >= 0) {
            if (wide) {
                if (i + 1 < bs.length() && bs.get(i + 1)) {
                    return i;
                }
            } else {
                return i;
            }
            i = bs.nextSetBit(i + 1);
        }
        return -1;
    }

    private void gradyColoring(List<BaseLiveAnalyze.Phi> phis, int[] maps) {
        if (phis.size() <= 0) {
            return;
        }
        Collections.sort(phis, new Comparator<BaseLiveAnalyze.Phi>(){

            @Override
            public int compare(BaseLiveAnalyze.Phi o1, BaseLiveAnalyze.Phi o2) {
                int r = o2.parents.size() - o1.parents.size();
                return r == 0 ? IrMethod2AsmMethod.sizeOf(o2) - IrMethod2AsmMethod.sizeOf(o1) : r;
            }
        });
        BaseLiveAnalyze.Phi first = phis.get(0);
        int size = IrMethod2AsmMethod.sizeOf(first);
        for (BaseLiveAnalyze.Phi p : first.parents) {
            size += IrMethod2AsmMethod.sizeOf(p);
        }
        BitSet toColor = new BitSet(phis.size());
        int i = 0;
        while (i < phis.size()) {
            LiveAnalyze.LivePhi p = (LiveAnalyze.LivePhi)phis.get(i);
            if (maps[p.local._ls_index] < 0) {
                toColor.set(i);
            }
            ++i;
        }
        while (!this.doColor(0, toColor, phis, size, maps)) {
            ++size;
        }
    }

    private boolean doColor(int idx, BitSet toColor, List<BaseLiveAnalyze.Phi> phis, int size, int[] maps) {
        int x = toColor.nextSetBit(idx);
        if (x < 0) {
            return true;
        }
        LiveAnalyze.LivePhi phi = (LiveAnalyze.LivePhi)phis.get(x);
        int i = this.findNextColor((BaseLiveAnalyze.Phi)phi, 0, size, maps);
        while (i >= 0) {
            maps[phi.local._ls_index] = i;
            if (this.doColor(x + 1, toColor, phis, size, maps)) {
                return true;
            }
            maps[phi.local._ls_index] = -1;
            i = this.findNextColor((BaseLiveAnalyze.Phi)phi, i + 1, size, maps);
        }
        return false;
    }

    private static int sizeOf(BaseLiveAnalyze.Phi p) {
        return LocalType.typeOf((Value)((LiveAnalyze.LivePhi)p).local).getSize();
    }

    private void createGraph(IrMethod ir, int localSize) {
        ArrayList<BaseLiveAnalyze.Phi> tmp = new ArrayList<BaseLiveAnalyze.Phi>(localSize);
        Stmt p = ir.stmts.getFirst();
        while (p != null) {
            tmp.clear();
            BaseLiveAnalyze.Phi[] frame = (BaseLiveAnalyze.Phi[])p._ls_forward_frame;
            p._ls_forward_frame = null;
            if (frame != null) {
                BaseLiveAnalyze.Phi[] phiArray = frame;
                int n = frame.length;
                int n2 = 0;
                while (n2 < n) {
                    BaseLiveAnalyze.Phi r = phiArray[n2];
                    if (r != null) {
                        tmp.add(r);
                    }
                    ++n2;
                }
            }
            int i = 0;
            while (i < tmp.size() - 1) {
                BaseLiveAnalyze.Phi a = (BaseLiveAnalyze.Phi)tmp.get(i);
                int j = i + 1;
                while (j < tmp.size()) {
                    BaseLiveAnalyze.Phi b = (BaseLiveAnalyze.Phi)tmp.get(j);
                    if (a != b) {
                        a.parents.add(b);
                        b.parents.add(a);
                    }
                    ++j;
                }
                ++i;
            }
            p = p.getNext();
        }
    }

    private void reIndexLocal(IrMethod ir) {
        if (this.reuseReg) {
            this.reIndexLocalReuseReg(ir);
        } else {
            this.reIndexLocalDirect(ir);
        }
    }

    private void reIndexLocalDirect(IrMethod ir) {
        int index = 0;
        if ((ir.access & 8) == 0) {
            ++index;
        }
        final int[] ids = new int[ir.args.length];
        int i = 0;
        while (i < ir.args.length) {
            ids[i] = index;
            index += ir.args[i].getSize();
            ++i;
        }
        for (Local local : ir.locals) {
            local._ls_index = -1;
        }
        final int[] indexHolder = new int[]{index};
        Cfg.createCFG((IrMethod)ir);
        Cfg.Forward((IrMethod)ir, (Cfg.StmtVisitor)new Cfg.StmtVisitor<Object>(){

            public Object exec(Stmt stmt) {
                block0 : switch (stmt.st) {
                    case ASSIGN: 
                    case IDENTITY: {
                        Type localType;
                        if (((AssignStmt)stmt).op1.value.vt != Value.VT.LOCAL) break;
                        Local local = (Local)((AssignStmt)stmt).op1.value;
                        if (local._ls_index != -1 || Type.VOID_TYPE.equals((Object)(localType = LocalType.typeOf((Value)local)))) break;
                        Value ref = ((AssignStmt)stmt).op2.value;
                        switch (ref.vt) {
                            case THIS_REF: {
                                local._ls_index = 0;
                                break block0;
                            }
                            case PARAMETER_REF: {
                                local._ls_index = ids[((RefExpr)ref).parameterIndex];
                                break block0;
                            }
                            case EXCEPTION_REF: {
                                int n = indexHolder[0];
                                indexHolder[0] = n + 1;
                                local._ls_index = n;
                                break block0;
                            }
                        }
                        local._ls_index = indexHolder[0];
                        indexHolder[0] = indexHolder[0] + LocalType.typeOf((Value)ref).getSize();
                    }
                }
                return null;
            }
        });
    }

    public void convert(IrMethod ir, MethodVisitor asm) {
        this.reIndexLocal(ir);
        this.reIndexStmts(ir);
        this.reBuildInstructions(ir, asm);
        this.reBuildTryCatchBlocks(ir, asm);
        this.reBuildLocalVar(ir, asm);
    }

    private void reBuildTryCatchBlocks(IrMethod ir, MethodVisitor asm) {
        for (Trap trap : ir.traps) {
            boolean needAdd = false;
            Stmt p = trap.start.getNext();
            while (p != null && p != trap.end) {
                if (p.st != Stmt.ST.LABEL) {
                    needAdd = true;
                    break;
                }
                p = p.getNext();
            }
            if (!needAdd) continue;
            int i = 0;
            while (i < trap.handlers.length) {
                Type type = trap.types[i];
                asm.visitTryCatchBlock(trap.start.label, trap.end.label, trap.handlers[i].label, type == null ? null : type.getInternalName());
                ++i;
            }
        }
    }

    private void reIndexStmts(IrMethod ir) {
        int count = 0;
        for (Stmt st : ir.stmts) {
            st.id = count++;
        }
    }

    private void reBuildInstructions(IrMethod ir, MethodVisitor asm) {
        Local maxLoale;
        HashMap<String, Integer> lockMap = new HashMap<String, Integer>();
        int maxLocalIndex = ir.locals.size() == 0 ? 0 : ((maxLoale = Collections.max(ir.locals, new Comparator<Local>(){

            @Override
            public int compare(Local o1, Local o2) {
                int i = o1._ls_index - o2._ls_index;
                if (i != 0) {
                    return i;
                }
                Type t1 = LocalType.typeOf((Value)o1);
                if (t1 == null) {
                    return -1;
                }
                Type t2 = LocalType.typeOf((Value)o2);
                if (t2 == null) {
                    return 1;
                }
                return t1.getSize() - t2.getSize();
            }
        })) == null || maxLoale._ls_index < 0 ? 0 : maxLoale._ls_index + LocalType.typeOf((Value)maxLoale).getSize() - 1);
        block26: for (Stmt st : ir.stmts) {
            switch (st.st) {
                case LABEL: {
                    LabelStmt labelStmt = (LabelStmt)st;
                    asm.visitLabel(labelStmt.label);
                    if (labelStmt.lineNumber < 0) break;
                    asm.visitLineNumber(labelStmt.lineNumber, labelStmt.label);
                    break;
                }
                case ASSIGN: {
                    Stmt.E2Stmt e2 = (Stmt.E2Stmt)st;
                    Value v1 = e2.op1.value;
                    Value v2 = e2.op2.value;
                    switch (v1.vt) {
                        case LOCAL: {
                            Local local = (Local)v1;
                            int i = local._ls_index;
                            if (v2.vt == Value.VT.LOCAL && i == ((Local)v2)._ls_index) continue block26;
                            boolean skipOrg = false;
                            if (LocalType.typeOf((Value)v1).equals((Object)Type.INT_TYPE)) {
                                Value.E2Expr e;
                                if (v2.vt == Value.VT.ADD) {
                                    int increment;
                                    e = (Value.E2Expr)v2;
                                    if ((e.op1.value == local && e.op2.value.vt == Value.VT.CONSTANT || e.op2.value == local && e.op1.value.vt == Value.VT.CONSTANT) && (increment = ((Integer)((Constant)(e.op1.value == local ? e.op2.value : e.op1.value)).value).intValue()) >= Short.MIN_VALUE && increment <= Short.MAX_VALUE) {
                                        asm.visitIincInsn(i, increment);
                                        skipOrg = true;
                                    }
                                } else if (v2.vt == Value.VT.SUB) {
                                    int increment;
                                    e = (Value.E2Expr)v2;
                                    if (e.op1.value == local && e.op2.value.vt == Value.VT.CONSTANT && (increment = -((Integer)((Constant)e.op2.value).value).intValue()) >= Short.MIN_VALUE && increment <= Short.MAX_VALUE) {
                                        asm.visitIincInsn(i, increment);
                                        skipOrg = true;
                                    }
                                }
                            }
                            if (skipOrg) break;
                            IrMethod2AsmMethod.accept(v2, asm);
                            if (i >= 0) {
                                if (local._ls_read_count == 0) {
                                    asm.visitInsn(LocalType.typeOf((Value)v1).getSize() == 2 ? 88 : 87);
                                    break;
                                }
                                asm.visitVarInsn(LocalType.typeOf((Value)v1).getOpcode(54), i);
                                break;
                            }
                            if (LocalType.typeOf((Value)v1).equals((Object)Type.VOID_TYPE)) break;
                            asm.visitInsn(LocalType.typeOf((Value)v1).getSize() == 2 ? 88 : 87);
                            break;
                        }
                        case FIELD: {
                            FieldExpr fe = (FieldExpr)v1;
                            if (fe.op == null) {
                                IrMethod2AsmMethod.accept(v2, asm);
                                IrMethod2AsmMethod.insertI2x(LocalType.typeOf((Value)v2), fe.fieldType, asm);
                                asm.visitFieldInsn(179, fe.fieldOwnerType.getInternalName(), fe.fieldName, fe.fieldType.getDescriptor());
                                break;
                            }
                            IrMethod2AsmMethod.accept(fe.op.value, asm);
                            IrMethod2AsmMethod.accept(v2, asm);
                            IrMethod2AsmMethod.insertI2x(LocalType.typeOf((Value)v2), fe.fieldType, asm);
                            asm.visitFieldInsn(181, fe.fieldOwnerType.getInternalName(), fe.fieldName, fe.fieldType.getDescriptor());
                            break;
                        }
                        case ARRAY: {
                            ArrayExpr ae = (ArrayExpr)v1;
                            IrMethod2AsmMethod.accept(ae.op1.value, asm);
                            IrMethod2AsmMethod.accept(ae.op2.value, asm);
                            IrMethod2AsmMethod.accept(v2, asm);
                            Type tp1 = LocalType.typeOf((Value)ae.op1.value);
                            Type tp2 = LocalType.typeOf((Value)ae);
                            if (tp1.getSort() == 9) {
                                Type arrayElementType = Type.getType((String)tp1.getDescriptor().substring(1));
                                IrMethod2AsmMethod.insertI2x(LocalType.typeOf((Value)v2), arrayElementType, asm);
                                asm.visitInsn(arrayElementType.getOpcode(79));
                                break;
                            }
                            asm.visitInsn(tp2.getOpcode(79));
                        }
                    }
                    continue block26;
                }
                case IDENTITY: {
                    Stmt.E2Stmt e2 = (Stmt.E2Stmt)st;
                    if (e2.op2.value.vt != Value.VT.EXCEPTION_REF) break;
                    int index = ((Local)e2.op1.value)._ls_index;
                    if (index >= 0) {
                        asm.visitVarInsn(58, index);
                        break;
                    }
                    asm.visitInsn(87);
                    break;
                }
                case GOTO: {
                    asm.visitJumpInsn(167, ((JumpStmt)st).target.label);
                    break;
                }
                case IF: {
                    this.reBuildJumpInstructions((JumpStmt)st, asm);
                    break;
                }
                case LOCK: {
                    String key;
                    Value v = ((UnopStmt)st).op.value;
                    IrMethod2AsmMethod.accept(v, asm);
                    if (this.optimizeSynchronized) {
                        switch (v.vt) {
                            case CONSTANT: 
                            case LOCAL: {
                                key = v.vt == Value.VT.LOCAL ? "L" + ((Local)v)._ls_index : "C" + ((Constant)v).value;
                                Integer integer = (Integer)lockMap.get(key);
                                int nIndex = integer != null ? integer : ++maxLocalIndex;
                                asm.visitInsn(89);
                                asm.visitVarInsn(LocalType.typeOf((Value)v).getOpcode(54), nIndex);
                                lockMap.put(key, nIndex);
                                break;
                            }
                            default: {
                                throw new RuntimeException();
                            }
                        }
                    }
                    asm.visitInsn(194);
                    break;
                }
                case UNLOCK: {
                    String key;
                    Value v = ((UnopStmt)st).op.value;
                    if (this.optimizeSynchronized) {
                        switch (v.vt) {
                            case CONSTANT: 
                            case LOCAL: {
                                key = v.vt == Value.VT.LOCAL ? "L" + ((Local)v)._ls_index : "C" + ((Constant)v).value;
                                Integer integer = (Integer)lockMap.get(key);
                                if (integer != null) {
                                    asm.visitVarInsn(LocalType.typeOf((Value)v).getOpcode(21), integer.intValue());
                                    break;
                                }
                                IrMethod2AsmMethod.accept(v, asm);
                                break;
                            }
                            default: {
                                IrMethod2AsmMethod.accept(v, asm);
                                break;
                            }
                        }
                    } else {
                        IrMethod2AsmMethod.accept(v, asm);
                    }
                    asm.visitInsn(195);
                    break;
                }
                case NOP: {
                    break;
                }
                case RETURN: {
                    Value v = ((UnopStmt)st).op.value;
                    IrMethod2AsmMethod.accept(v, asm);
                    IrMethod2AsmMethod.insertI2x(LocalType.typeOf((Value)v), ir.ret, asm);
                    asm.visitInsn(LocalType.typeOf((Value)v).getOpcode(172));
                    break;
                }
                case RETURN_VOID: {
                    asm.visitInsn(177);
                    break;
                }
                case LOOKUP_SWITCH: {
                    LookupSwitchStmt lss = (LookupSwitchStmt)st;
                    IrMethod2AsmMethod.accept(lss.op.value, asm);
                    Label[] targets = new Label[lss.targets.length];
                    int i = 0;
                    while (i < targets.length) {
                        targets[i] = lss.targets[i].label;
                        ++i;
                    }
                    asm.visitLookupSwitchInsn(lss.defaultTarget.label, lss.lookupValues, targets);
                    break;
                }
                case TABLE_SWITCH: {
                    TableSwitchStmt tss = (TableSwitchStmt)st;
                    IrMethod2AsmMethod.accept(tss.op.value, asm);
                    Label[] targets = new Label[tss.targets.length];
                    int i = 0;
                    while (i < targets.length) {
                        targets[i] = tss.targets[i].label;
                        ++i;
                    }
                    asm.visitTableSwitchInsn(tss.lowIndex, tss.highIndex, tss.defaultTarget.label, targets);
                    break;
                }
                case THROW: {
                    IrMethod2AsmMethod.accept(((UnopStmt)st).op.value, asm);
                    asm.visitInsn(191);
                }
            }
        }
    }

    private static void insertI2x(Type tos, Type expect, MethodVisitor mv) {
        switch (expect.getSort()) {
            case 3: {
                switch (tos.getSort()) {
                    case 2: 
                    case 4: 
                    case 5: {
                        mv.visitInsn(145);
                    }
                }
                break;
            }
            case 4: {
                switch (tos.getSort()) {
                    case 2: 
                    case 5: {
                        mv.visitInsn(147);
                    }
                }
                break;
            }
            case 2: {
                switch (tos.getSort()) {
                    case 5: {
                        mv.visitInsn(146);
                    }
                }
            }
        }
    }

    private void reBuildJumpInstructions(JumpStmt st, MethodVisitor asm) {
        Label target = st.target.label;
        Value v = st.op.value;
        Value v1 = ((Value.E2Expr)v).op1.value;
        Value v2 = ((Value.E2Expr)v).op2.value;
        Type type = LocalType.typeOf((Value)v1);
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (v1.vt == Value.VT.CONSTANT && ((Constant)v1).value.equals(new Integer(0)) || v2.vt == Value.VT.CONSTANT && ((Constant)v2).value.equals(new Integer(0))) {
                    if (v2.vt == Value.VT.CONSTANT && ((Constant)v2).value.equals(new Integer(0))) {
                        IrMethod2AsmMethod.accept(v1, asm);
                    } else {
                        IrMethod2AsmMethod.accept(v2, asm);
                    }
                    switch (v.vt) {
                        case NE: {
                            asm.visitJumpInsn(154, target);
                            break;
                        }
                        case EQ: {
                            asm.visitJumpInsn(153, target);
                            break;
                        }
                        case GE: {
                            asm.visitJumpInsn(156, target);
                            break;
                        }
                        case GT: {
                            asm.visitJumpInsn(157, target);
                            break;
                        }
                        case LE: {
                            asm.visitJumpInsn(158, target);
                            break;
                        }
                        case LT: {
                            asm.visitJumpInsn(155, target);
                        }
                    }
                    break;
                }
                IrMethod2AsmMethod.accept(v1, asm);
                IrMethod2AsmMethod.accept(v2, asm);
                switch (v.vt) {
                    case NE: {
                        asm.visitJumpInsn(160, target);
                        break;
                    }
                    case EQ: {
                        asm.visitJumpInsn(159, target);
                        break;
                    }
                    case GE: {
                        asm.visitJumpInsn(162, target);
                        break;
                    }
                    case GT: {
                        asm.visitJumpInsn(163, target);
                        break;
                    }
                    case LE: {
                        asm.visitJumpInsn(164, target);
                        break;
                    }
                    case LT: {
                        asm.visitJumpInsn(161, target);
                    }
                }
                break;
            }
            case 9: 
            case 10: {
                if (v1.vt == Value.VT.CONSTANT && ((Constant)v1).value.equals(Constant.Null) || v2.vt == Value.VT.CONSTANT && ((Constant)v2).value.equals(Constant.Null)) {
                    if (v2.vt == Value.VT.CONSTANT && ((Constant)v2).value.equals(Constant.Null)) {
                        IrMethod2AsmMethod.accept(v1, asm);
                    } else {
                        IrMethod2AsmMethod.accept(v2, asm);
                    }
                    asm.visitJumpInsn(v.vt == Value.VT.EQ ? 198 : 199, target);
                    break;
                }
                IrMethod2AsmMethod.accept(v1, asm);
                IrMethod2AsmMethod.accept(v2, asm);
                asm.visitJumpInsn(v.vt == Value.VT.EQ ? 165 : 166, target);
            }
        }
    }

    private void reBuildLocalVar(IrMethod ir, MethodVisitor asm) {
        for (LocalVar vs : ir.vars) {
            if (vs.reg.value.vt != Value.VT.LOCAL) {
                throw new DexException("the reg in LocalVar is not a Local");
            }
            if (vs.start.id <= vs.end.id) {
                asm.visitLocalVariable(vs.name, vs.type, vs.signature, vs.start.label, vs.end.label, ((Local)vs.reg.value)._ls_index);
                continue;
            }
            asm.visitLocalVariable(vs.name, vs.type, vs.signature, vs.end.label, vs.start.label, ((Local)vs.reg.value)._ls_index);
        }
    }

    private static void accept(Value value, MethodVisitor asm) {
        switch (value.et) {
            case E0: {
                switch (value.vt) {
                    case LOCAL: {
                        asm.visitVarInsn(LocalType.typeOf((Value)value).getOpcode(21), ((Local)value)._ls_index);
                        break;
                    }
                    case CONSTANT: {
                        Constant cst = (Constant)value;
                        if (cst.value.equals(Constant.Null)) {
                            asm.visitInsn(1);
                            break;
                        }
                        asm.visitLdcInsn(cst.value);
                        break;
                    }
                    case NEW: {
                        asm.visitTypeInsn(187, ((NewExpr)value).type.getInternalName());
                    }
                }
                break;
            }
            case E1: {
                IrMethod2AsmMethod.reBuildE1Expression((Value.E1Expr)value, asm);
                break;
            }
            case E2: {
                IrMethod2AsmMethod.reBuildE2Expression((Value.E2Expr)value, asm);
                break;
            }
            case En: {
                IrMethod2AsmMethod.reBuildEnExpression((Value.EnExpr)value, asm);
            }
        }
    }

    private static void reBuildEnExpression(Value.EnExpr value, MethodVisitor asm) {
        if (value.vt == Value.VT.FILLED_ARRAY) {
            FilledArrayExpr fae = (FilledArrayExpr)value;
            TypeExpr te = Exprs.nNewArray((Type)fae.type, (Value)Constant.nInt((int)fae.ops.length));
            IrMethod2AsmMethod.reBuildE1Expression((Value.E1Expr)te, asm);
            Type tp1 = LocalType.typeOf((Value)fae);
            int xastore = 79;
            Type elementType = null;
            if (tp1.getSort() == 9) {
                elementType = Type.getType((String)tp1.getDescriptor().substring(1));
                xastore = elementType.getOpcode(79);
            }
            int i = 0;
            while (i < fae.ops.length) {
                if (fae.ops[i].value != null) {
                    asm.visitInsn(89);
                    asm.visitLdcInsn((Object)i);
                    IrMethod2AsmMethod.accept(fae.ops[i].value, asm);
                    Type tp2 = LocalType.typeOf((Value)fae.ops[i].value);
                    if (elementType != null) {
                        IrMethod2AsmMethod.insertI2x(tp2, elementType, asm);
                    }
                    asm.visitInsn(xastore);
                }
                ++i;
            }
            return;
        }
        switch (value.vt) {
            case NEW_MUTI_ARRAY: {
                ValueBox[] xastore = value.ops;
                int tp1 = value.ops.length;
                int te = 0;
                while (te < tp1) {
                    ValueBox vb = xastore[te];
                    IrMethod2AsmMethod.accept(vb.value, asm);
                    ++te;
                }
                NewMutiArrayExpr nmae = (NewMutiArrayExpr)value;
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < nmae.dimension) {
                    sb.append('[');
                    ++i;
                }
                sb.append(nmae.baseType.getDescriptor());
                asm.visitMultiANewArrayInsn(sb.toString(), nmae.dimension);
                break;
            }
            case INVOKE_NEW: {
                asm.visitTypeInsn(187, ((InvokeExpr)value).methodOwnerType.getInternalName());
                asm.visitInsn(89);
            }
            case INVOKE_INTERFACE: 
            case INVOKE_SPECIAL: 
            case INVOKE_STATIC: 
            case INVOKE_VIRTUAL: {
                int opcode;
                InvokeExpr ie = (InvokeExpr)value;
                int i = 0;
                if (value.vt != Value.VT.INVOKE_STATIC && value.vt != Value.VT.INVOKE_NEW) {
                    i = 1;
                    IrMethod2AsmMethod.accept(value.ops[0].value, asm);
                }
                int j = 0;
                while (i < value.ops.length) {
                    ValueBox vb = value.ops[i];
                    IrMethod2AsmMethod.accept(vb.value, asm);
                    IrMethod2AsmMethod.insertI2x(LocalType.typeOf((Value)vb.value), ie.argmentTypes[j], asm);
                    ++i;
                    ++j;
                }
                switch (value.vt) {
                    case INVOKE_VIRTUAL: {
                        opcode = 182;
                        break;
                    }
                    case INVOKE_INTERFACE: {
                        opcode = 185;
                        break;
                    }
                    case INVOKE_NEW: 
                    case INVOKE_SPECIAL: {
                        opcode = 183;
                        break;
                    }
                    case INVOKE_STATIC: {
                        opcode = 184;
                        break;
                    }
                    default: {
                        opcode = -1;
                    }
                }
                asm.visitMethodInsn(opcode, ie.methodOwnerType.getInternalName(), ie.methodName, Type.getMethodDescriptor((Type)(ie.vt == Value.VT.INVOKE_NEW ? Type.VOID_TYPE : ie.methodReturnType), (Type[])ie.argmentTypes));
            }
        }
    }

    private static void reBuildE1Expression(Value.E1Expr e1, MethodVisitor asm) {
        if (e1.op != null) {
            IrMethod2AsmMethod.accept(e1.op.value, asm);
        }
        block0 : switch (e1.vt) {
            case FIELD: {
                FieldExpr fe = (FieldExpr)e1;
                asm.visitFieldInsn(e1.op == null ? 178 : 180, fe.fieldOwnerType.getInternalName(), fe.fieldName, fe.fieldType.getDescriptor());
                break;
            }
            case NEW_ARRAY: {
                int operand;
                TypeExpr te = (TypeExpr)e1;
                switch (te.type.getSort()) {
                    case 9: 
                    case 10: {
                        asm.visitTypeInsn(189, te.type.getInternalName());
                        break block0;
                    }
                }
                switch (te.type.getSort()) {
                    case 1: {
                        operand = 4;
                        break;
                    }
                    case 3: {
                        operand = 8;
                        break;
                    }
                    case 4: {
                        operand = 9;
                        break;
                    }
                    case 2: {
                        operand = 5;
                        break;
                    }
                    case 5: {
                        operand = 10;
                        break;
                    }
                    case 6: {
                        operand = 6;
                        break;
                    }
                    case 7: {
                        operand = 11;
                        break;
                    }
                    case 8: {
                        operand = 7;
                        break;
                    }
                    default: {
                        operand = -1;
                    }
                }
                asm.visitIntInsn(188, operand);
                break;
            }
            case CHECK_CAST: 
            case INSTANCE_OF: {
                TypeExpr te = (TypeExpr)e1;
                asm.visitTypeInsn(e1.vt == Value.VT.CHECK_CAST ? 192 : 193, te.type.getInternalName());
                break;
            }
            case CAST: {
                CastExpr te = (CastExpr)e1;
                IrMethod2AsmMethod.cast2(LocalType.typeOf((Value)e1.op.value), te.to, asm);
                break;
            }
            case LENGTH: {
                asm.visitInsn(190);
                break;
            }
            case NEG: {
                asm.visitInsn(LocalType.typeOf((Value)e1).getOpcode(116));
            }
        }
    }

    private static void reBuildE2Expression(Value.E2Expr e2, MethodVisitor asm) {
        Type type = LocalType.typeOf((Value)e2.op2.value);
        IrMethod2AsmMethod.accept(e2.op1.value, asm);
        if ((e2.vt == Value.VT.ADD || e2.vt == Value.VT.SUB) && e2.op2.value.vt == Value.VT.CONSTANT) {
            Constant constant = (Constant)e2.op2.value;
            Type t = LocalType.typeOf((Value)constant);
            switch (t.getSort()) {
                case 3: 
                case 4: 
                case 5: {
                    int s = (Integer)constant.value;
                    if (s >= 0) break;
                    asm.visitLdcInsn((Object)(-s));
                    asm.visitInsn(type.getOpcode(e2.vt == Value.VT.ADD ? 100 : 96));
                    return;
                }
                case 6: {
                    float s = ((Float)constant.value).floatValue();
                    if (!(s < 0.0f)) break;
                    asm.visitLdcInsn((Object)Float.valueOf(-s));
                    asm.visitInsn(type.getOpcode(e2.vt == Value.VT.ADD ? 100 : 96));
                    return;
                }
                case 7: {
                    long s = (Long)constant.value;
                    if (s >= 0L) break;
                    asm.visitLdcInsn((Object)(-s));
                    asm.visitInsn(type.getOpcode(e2.vt == Value.VT.ADD ? 100 : 96));
                    return;
                }
                case 8: {
                    double s = (Double)constant.value;
                    if (!(s < 0.0)) break;
                    asm.visitLdcInsn((Object)(-s));
                    asm.visitInsn(type.getOpcode(e2.vt == Value.VT.ADD ? 100 : 96));
                    return;
                }
            }
        }
        IrMethod2AsmMethod.accept(e2.op2.value, asm);
        Type tp1 = LocalType.typeOf((Value)e2.op1.value);
        switch (e2.vt) {
            case ARRAY: {
                Type tp2 = LocalType.typeOf((Value)e2);
                if (tp1.getSort() == 9) {
                    asm.visitInsn(Type.getType((String)tp1.getDescriptor().substring(1)).getOpcode(46));
                    break;
                }
                asm.visitInsn(tp2.getOpcode(46));
                break;
            }
            case ADD: {
                asm.visitInsn(type.getOpcode(96));
                break;
            }
            case SUB: {
                asm.visitInsn(type.getOpcode(100));
                break;
            }
            case DIV: {
                asm.visitInsn(type.getOpcode(108));
                break;
            }
            case MUL: {
                asm.visitInsn(type.getOpcode(104));
                break;
            }
            case REM: {
                asm.visitInsn(type.getOpcode(112));
                break;
            }
            case AND: {
                asm.visitInsn(type.getOpcode(126));
                break;
            }
            case OR: {
                asm.visitInsn(type.getOpcode(128));
                break;
            }
            case XOR: {
                asm.visitInsn(type.getOpcode(130));
                break;
            }
            case SHL: {
                asm.visitInsn(tp1.getOpcode(120));
                break;
            }
            case SHR: {
                asm.visitInsn(tp1.getOpcode(122));
                break;
            }
            case USHR: {
                asm.visitInsn(tp1.getOpcode(124));
                break;
            }
            case LCMP: {
                asm.visitInsn(148);
                break;
            }
            case FCMPG: {
                asm.visitInsn(150);
                break;
            }
            case DCMPG: {
                asm.visitInsn(152);
                break;
            }
            case FCMPL: {
                asm.visitInsn(149);
                break;
            }
            case DCMPL: {
                asm.visitInsn(151);
            }
        }
    }

    private static void cast2(Type t1, Type t2, MethodVisitor asm) {
        int opcode;
        if (t1.equals((Object)t2)) {
            return;
        }
        switch (t1.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                t1 = Type.INT_TYPE;
            }
        }
        switch (t1.getSort() * 10 + t2.getSort()) {
            case 56: {
                opcode = 134;
                break;
            }
            case 57: {
                opcode = 133;
                break;
            }
            case 58: {
                opcode = 135;
                break;
            }
            case 52: {
                opcode = 146;
                break;
            }
            case 53: {
                opcode = 145;
                break;
            }
            case 54: {
                opcode = 147;
                break;
            }
            case 75: {
                opcode = 136;
                break;
            }
            case 76: {
                opcode = 137;
                break;
            }
            case 78: {
                opcode = 138;
                break;
            }
            case 65: {
                opcode = 139;
                break;
            }
            case 67: {
                opcode = 140;
                break;
            }
            case 68: {
                opcode = 141;
                break;
            }
            case 85: {
                opcode = 142;
                break;
            }
            case 86: {
                opcode = 144;
                break;
            }
            case 87: {
                opcode = 143;
                break;
            }
            default: {
                opcode = -1;
            }
        }
        if (opcode == -1) {
            throw new DexException("can't cast %s to %s", new Object[]{t1, t2});
        }
        asm.visitInsn(opcode);
    }
}

