/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.reader;

import com.googlecode.dex2jar.DexException;
import com.googlecode.dex2jar.Field;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.reader.CCZipExtractor;
import com.googlecode.dex2jar.reader.Constant;
import com.googlecode.dex2jar.reader.DexAnnotationReader;
import com.googlecode.dex2jar.reader.DexCodeReader;
import com.googlecode.dex2jar.reader.Mutf8;
import com.googlecode.dex2jar.reader.ZipExtractor;
import com.googlecode.dex2jar.reader.io.ArrayDataIn;
import com.googlecode.dex2jar.reader.io.DataIn;
import com.googlecode.dex2jar.reader.io.OffsetedDataIn;
import com.googlecode.dex2jar.visitors.DexAnnotationAble;
import com.googlecode.dex2jar.visitors.DexClassVisitor;
import com.googlecode.dex2jar.visitors.DexCodeVisitor;
import com.googlecode.dex2jar.visitors.DexFieldVisitor;
import com.googlecode.dex2jar.visitors.DexFileVisitor;
import com.googlecode.dex2jar.visitors.DexMethodVisitor;
import com.googlecode.dex2jar.visitors.OdexFileVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DexFileReader {
    private static final byte[] DEX_FILE_MAGIC = new byte[]{100, 101, 120};
    private static final byte[] ODEX_FILE_MAGIC = new byte[]{100, 101, 121};
    private static final byte[] VERSION_035 = new byte[]{48, 51, 53};
    private static final byte[] VERSION_036 = new byte[]{48, 51, 54};
    static final int ENDIAN_CONSTANT = 305419896;
    static final int REVERSE_ENDIAN_CONSTANT = 2018915346;
    private static final int DEFAULT_API_LEVEL = 13;
    private static final Logger log = Logger.getLogger(DexFileReader.class.getName());
    private int class_defs_off;
    private int class_defs_size;
    private int field_ids_off;
    private int field_ids_size;
    private DataIn in;
    private int method_ids_off;
    private int method_ids_size;
    private int proto_ids_off;
    private int proto_ids_size;
    private int string_ids_off;
    private int string_ids_size;
    private int type_ids_off;
    private int type_ids_size;
    public static final int SKIP_DEBUG = 1;
    public static final int SKIP_CODE = 4;
    public static final int SKIP_ANNOTATION = 8;
    public static final int SKIP_FIELD_CONSTANT = 16;
    private final boolean odex;
    private DataIn odex_in;
    private int odex_depsOffset;
    int apiLevel = 13;
    private boolean apiLevelSetted = false;
    private static final boolean isLittleEndian = true;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static byte[] readDex(byte[] data) throws IOException {
        if ("de".equals(new String(data, 0, 2))) {
            return data;
        }
        if ("PK".equals(new String(data, 0, 2))) {
            ZipExtractor ze;
            try {
                Class.forName("org.apache.commons.compress.archivers.zip.ZipArchiveInputStream");
                ze = new CCZipExtractor();
            }
            catch (ClassNotFoundException classNotFoundException) {
                ze = new ZipExtractor();
            }
            return ze.extract(data, "classes.dex");
        }
        throw new RuntimeException("the src file not a .dex, .odex or zip file");
    }

    public static byte[] readDex(File file) throws IOException {
        return DexFileReader.readDex(FileUtils.readFileToByteArray((File)file));
    }

    public DexFileReader(DataIn in) {
        in.move(0);
        byte[] magic = in.readBytes(3);
        if (Arrays.equals(magic, DEX_FILE_MAGIC)) {
            this.odex = false;
        } else if (Arrays.equals(magic, ODEX_FILE_MAGIC)) {
            this.odex = true;
            this.odex_in = in;
        } else {
            throw new DexException("not support magic.");
        }
        in.skip(1);
        byte[] version = in.readBytes(3);
        if (!Arrays.equals(version, VERSION_035) && !Arrays.equals(version, VERSION_036)) {
            throw new DexException("not support version.");
        }
        in.skip(1);
        if (this.odex) {
            int base = in.readIntx();
            in.skip(4);
            this.odex_depsOffset = in.readIntx();
            in = new OffsetedDataIn(in, base);
            in.skip(8);
        }
        in.skip(32);
        int endian_tag = in.readUIntx();
        if (endian_tag != 305419896) {
            throw new DexException("not support endian_tag");
        }
        this.in = in;
        in.skip(12);
        this.string_ids_size = in.readUIntx();
        this.string_ids_off = in.readUIntx();
        this.type_ids_size = in.readUIntx();
        this.type_ids_off = in.readUIntx();
        this.proto_ids_size = in.readUIntx();
        this.proto_ids_off = in.readUIntx();
        this.field_ids_size = in.readUIntx();
        this.field_ids_off = in.readUIntx();
        this.method_ids_size = in.readUIntx();
        this.method_ids_off = in.readUIntx();
        this.class_defs_size = in.readUIntx();
        this.class_defs_off = in.readUIntx();
    }

    private static DataIn opDataIn(byte[] data) {
        try {
            return new ArrayDataIn(DexFileReader.readDex(data), true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DexException(e);
        }
    }

    public DexFileReader(byte[] data) {
        this(DexFileReader.opDataIn(data));
    }

    public DexFileReader(File file) throws IOException {
        this(FileUtils.readFileToByteArray((File)file));
    }

    public DexFileReader(InputStream in) throws IOException {
        this(IOUtils.toByteArray((InputStream)in));
    }

    public void accept(DexFileVisitor dv) {
        this.accept(dv, 0);
    }

    public void accept(DexFileVisitor dv, int config) {
        DataIn in;
        if (this.odex && !this.apiLevelSetted) {
            log.warning("read an odex file without setting the apiLevel, use 13 as default.");
        }
        if (this.odex && dv instanceof OdexFileVisitor) {
            in = this.odex_in;
            OdexFileVisitor odv = (OdexFileVisitor)dv;
            in.pushMove(this.odex_depsOffset);
            try {
                in.skip(12);
                int size = in.readIntx();
                int i = 0;
                while (i < size) {
                    int length = in.readIntx();
                    odv.visitDepedence(new String(in.readBytes(length), 0, length - 1, UTF8), in.readBytes(20));
                    ++i;
                }
            }
            finally {
                in.pop();
            }
        }
        in = this.in;
        int cid = 0;
        while (cid < this.class_defs_size) {
            int idxOffset = this.class_defs_off + cid * 32;
            in.pushMove(idxOffset);
            String className = null;
            try {
                DexClassVisitor dcv;
                className = this.getType(in.readUIntx());
                int access_flags = in.readUIntx();
                int superclass_idx = in.readUIntx();
                String superClassName = superclass_idx == -1 ? null : this.getType(superclass_idx);
                String[] interfaceNames = null;
                int interfaces_off = in.readUIntx();
                if (interfaces_off != 0) {
                    in.pushMove(interfaces_off);
                    try {
                        int size = in.readUIntx();
                        interfaceNames = new String[size];
                        int i = 0;
                        while (i < size) {
                            interfaceNames[i] = this.getType(in.readUShortx());
                            ++i;
                        }
                    }
                    finally {
                        in.pop();
                    }
                }
                if ((dcv = dv.visit(access_flags, className, superClassName, interfaceNames)) != null) {
                    this.acceptClass(dv, dcv, className, config);
                }
            }
            finally {
                in.pop();
            }
            ++cid;
        }
        dv.visitEnd();
    }

    private void acceptClass(DexFileVisitor dv, DexClassVisitor dcv, String className, int config) {
        HashMap<Integer, Integer> paramAnnotationPositions;
        HashMap<Integer, Integer> methodAnnotationPositions;
        HashMap<Integer, Integer> fieldAnnotationPositions;
        DataIn in = this.in;
        int source_file_idx = in.readUIntx();
        if ((config & 1) == 0 && source_file_idx != -1) {
            dcv.visitSource(this.getString(source_file_idx));
        }
        int annotations_off = in.readUIntx();
        if ((config & 8) == 0) {
            fieldAnnotationPositions = new HashMap<Integer, Integer>();
            methodAnnotationPositions = new HashMap<Integer, Integer>();
            paramAnnotationPositions = new HashMap<Integer, Integer>();
            if (annotations_off != 0) {
                in.pushMove(annotations_off);
                try {
                    int method_idx;
                    int class_annotations_off = in.readUIntx();
                    if (class_annotations_off != 0) {
                        in.pushMove(class_annotations_off);
                        try {
                            try {
                                DexAnnotationReader.accept(this, in, dcv);
                            }
                            catch (Exception e) {
                                throw new RuntimeException("error on reading Annotation of class " + className, e);
                            }
                        }
                        finally {
                            in.pop();
                        }
                    }
                    int field_annotation_size = in.readUIntx();
                    int method_annotation_size = in.readUIntx();
                    int parameter_annotation_size = in.readUIntx();
                    int i = 0;
                    while (i < field_annotation_size) {
                        int field_idx = in.readUIntx();
                        int field_annotations_offset = in.readUIntx();
                        fieldAnnotationPositions.put(field_idx, field_annotations_offset);
                        ++i;
                    }
                    i = 0;
                    while (i < method_annotation_size) {
                        method_idx = in.readUIntx();
                        int method_annotation_offset = in.readUIntx();
                        methodAnnotationPositions.put(method_idx, method_annotation_offset);
                        ++i;
                    }
                    i = 0;
                    while (i < parameter_annotation_size) {
                        method_idx = in.readUIntx();
                        int parameter_annotation_offset = in.readUIntx();
                        paramAnnotationPositions.put(method_idx, parameter_annotation_offset);
                        ++i;
                    }
                }
                finally {
                    in.pop();
                }
            }
        } else {
            fieldAnnotationPositions = null;
            methodAnnotationPositions = null;
            paramAnnotationPositions = null;
        }
        int class_data_off = in.readUIntx();
        int static_values_off = in.readUIntx();
        if (class_data_off != 0) {
            in.pushMove(class_data_off);
            try {
                int static_fields = (int)in.readULeb128();
                int instance_fields = (int)in.readULeb128();
                int direct_methods = (int)in.readULeb128();
                int virtual_methods = (int)in.readULeb128();
                int lastIndex = 0;
                Object[] constant = null;
                if ((config & 0x10) == 0 && static_values_off != 0) {
                    in.pushMove(static_values_off);
                    try {
                        int size = (int)in.readULeb128();
                        constant = new Object[size];
                        int i = 0;
                        while (i < size) {
                            constant[i] = Constant.ReadConstant(this, in);
                            ++i;
                        }
                    }
                    finally {
                        in.pop();
                    }
                }
                int i = 0;
                while (i < static_fields) {
                    Object value = null;
                    if (constant != null && i < constant.length) {
                        value = constant[i];
                    }
                    lastIndex = this.acceptField(lastIndex, dcv, fieldAnnotationPositions, value, config);
                    ++i;
                }
                lastIndex = 0;
                int i2 = 0;
                while (i2 < instance_fields) {
                    lastIndex = this.acceptField(lastIndex, dcv, fieldAnnotationPositions, null, config);
                    ++i2;
                }
                lastIndex = 0;
                i2 = 0;
                while (i2 < direct_methods) {
                    lastIndex = this.acceptMethod(lastIndex, dcv, methodAnnotationPositions, paramAnnotationPositions, config);
                    ++i2;
                }
                lastIndex = 0;
                i2 = 0;
                while (i2 < virtual_methods) {
                    lastIndex = this.acceptMethod(lastIndex, dcv, methodAnnotationPositions, paramAnnotationPositions, config);
                    ++i2;
                }
            }
            finally {
                in.pop();
            }
        }
        dcv.visitEnd();
    }

    Field getField(int id) {
        if (id >= this.field_ids_size || id < 0) {
            throw new IllegalArgumentException("Id out of bound");
        }
        DataIn in = this.in;
        int idxOffset = this.field_ids_off + id * 8;
        in.pushMove(idxOffset);
        try {
            int owner_idx = in.readUShortx();
            int type_idx = in.readUShortx();
            int name_idx = in.readUIntx();
            Field field = new Field(this.getType(owner_idx), this.getString(name_idx), this.getType(type_idx));
            return field;
        }
        finally {
            in.pop();
        }
    }

    Method getMethod(int method_idx) {
        if (method_idx >= this.method_ids_size || method_idx < 0) {
            throw new IllegalArgumentException("Id out of bound");
        }
        DataIn in = this.in;
        int idxOffset = this.method_ids_off + method_idx * 8;
        in.pushMove(idxOffset);
        try {
            String[] parameterTypes;
            String returnType;
            int name_idx;
            int owner_idx;
            block13: {
                owner_idx = in.readUShortx();
                int proto_idx = in.readUShortx();
                name_idx = in.readUIntx();
                if (proto_idx >= this.proto_ids_size) {
                    throw new IllegalArgumentException("Id out of bound");
                }
                int proto_off = this.proto_ids_off + proto_idx * 12;
                in.pushMove(proto_off);
                try {
                    in.skip(4);
                    int return_type_idx = in.readUIntx();
                    int parameters_off = in.readUIntx();
                    returnType = this.getType(return_type_idx);
                    if (parameters_off != 0) {
                        in.pushMove(parameters_off);
                        try {
                            int size = in.readUIntx();
                            parameterTypes = new String[size];
                            int i = 0;
                            while (i < size) {
                                parameterTypes[i] = this.getType(in.readUShortx());
                                ++i;
                            }
                            break block13;
                        }
                        finally {
                            in.pop();
                        }
                    }
                    parameterTypes = new String[]{};
                }
                finally {
                    in.pop();
                }
            }
            Method method = new Method(this.getType(owner_idx), this.getString(name_idx), parameterTypes, returnType);
            return method;
        }
        finally {
            in.pop();
        }
    }

    /*
     * Loose catch block
     */
    String getString(int id) {
        if (id >= this.string_ids_size || id < 0) {
            throw new IllegalArgumentException("Id out of bound");
        }
        DataIn in = this.in;
        int idxOffset = this.string_ids_off + id * 4;
        in.pushMove(idxOffset);
        try {
            int offset = in.readIntx();
            in.pushMove(offset);
            try {
                int length = (int)in.readULeb128();
                StringBuilder buff = new StringBuilder((int)((double)length * 1.5));
                String string = Mutf8.decode(in, buff);
                return string;
            }
            catch (UTFDataFormatException e) {
                throw new DexException(e, "fail to load string %d@%08x", id, offset);
            }
            finally {
                in.pop();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            in.pop();
        }
    }

    String getType(int id) {
        if (id == -1) {
            return null;
        }
        if (id >= this.type_ids_size || id < 0) {
            throw new IllegalArgumentException("Id out of bound");
        }
        DataIn in = this.in;
        int idxOffset = this.type_ids_off + id * 4;
        in.pushMove(idxOffset);
        try {
            int offset = in.readIntx();
            String string = this.getString(offset);
            return string;
        }
        finally {
            in.pop();
        }
    }

    public final void setApiLevel(int apiLevel) {
        this.apiLevelSetted = true;
        this.apiLevel = apiLevel;
    }

    int acceptField(int lastIndex, DexClassVisitor dcv, Map<Integer, Integer> fieldAnnotationPositions, Object value, int config) {
        DataIn in = this.in;
        int diff = (int)in.readULeb128();
        int field_id = lastIndex + diff;
        Field field = this.getField(field_id);
        int field_access_flags = (int)in.readULeb128();
        DexFieldVisitor dfv = dcv.visitField(field_access_flags, field, value);
        if (dfv != null) {
            Integer annotation_offset;
            if ((config & 8) == 0 && (annotation_offset = fieldAnnotationPositions.get(field_id)) != null) {
                in.pushMove(annotation_offset);
                try {
                    try {
                        DexAnnotationReader.accept(this, in, dfv);
                    }
                    catch (Exception e) {
                        throw new DexException(e, "while accept annotation in field:%s.", field.toString());
                    }
                }
                finally {
                    in.pop();
                }
            }
            dfv.visitEnd();
        }
        return field_id;
    }

    int acceptMethod(int lastIndex, DexClassVisitor cv, Map<Integer, Integer> methodAnnos, Map<Integer, Integer> parameterAnnos, int config) {
        int method_id;
        block26: {
            DataIn in = this.in;
            int diff = (int)in.readULeb128();
            int method_access_flags = (int)in.readULeb128();
            int code_off = (int)in.readULeb128();
            method_id = lastIndex + diff;
            Method method = this.getMethod(method_id);
            try {
                DexMethodVisitor dmv;
                block30: {
                    dmv = cv.visitMethod(method_access_flags, method);
                    if (dmv == null) break block26;
                    if ((config & 8) == 0) {
                        Integer parameter_annotation_offset;
                        Integer annotation_offset = methodAnnos.get(method_id);
                        if (annotation_offset != null) {
                            in.pushMove(annotation_offset);
                            try {
                                try {
                                    DexAnnotationReader.accept(this, in, dmv);
                                }
                                catch (Exception e) {
                                    throw new DexException(e, "while accept annotation in method:%s.", method.toString());
                                }
                            }
                            finally {
                                in.pop();
                            }
                        }
                        if ((parameter_annotation_offset = parameterAnnos.get(method_id)) != null) {
                            in.pushMove(parameter_annotation_offset);
                            try {
                                int sizeJ = in.readUIntx();
                                int j = 0;
                                while (j < sizeJ) {
                                    int field_annotation_offset = in.readUIntx();
                                    in.pushMove(field_annotation_offset);
                                    try {
                                        try {
                                            DexAnnotationAble dpav = dmv.visitParameterAnnotation(j);
                                            if (dpav != null) {
                                                DexAnnotationReader.accept(this, in, dpav);
                                            }
                                        }
                                        catch (Exception e) {
                                            throw new DexException(e, "while accept parameter annotation in method:[%s], parameter:[%d]", method.toString(), j);
                                        }
                                    }
                                    finally {
                                        in.pop();
                                    }
                                    ++j;
                                }
                            }
                            finally {
                                in.pop();
                            }
                        }
                    }
                    if (code_off != 0 && (4 & config) == 0) {
                        in.pushMove(code_off);
                        try {
                            DexCodeVisitor dcv = dmv.visitCode();
                            if (dcv == null) break block30;
                            try {
                                new DexCodeReader(this, in, (8 & method_access_flags) != 0, method).accept(dcv, config);
                            }
                            catch (Exception e) {
                                throw new DexException(e, "while accept code in method:[%s]", method.toString());
                            }
                        }
                        finally {
                            in.pop();
                        }
                    }
                }
                dmv.visitEnd();
            }
            catch (Exception e) {
                throw new DexException(e, "while accept method:[%s]", method.toString());
            }
        }
        return method_id;
    }

    public final boolean isOdex() {
        return this.odex;
    }

    public final int getClassSize() {
        return this.class_defs_size;
    }
}

