/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import cc.mallet.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.regex.Pattern;

public class FeaturesInWindow
extends Pipe
implements Serializable {
    String namePrefix;
    String namePrefixLeft;
    int leftBoundary;
    int rightBoundary;
    Pattern featureRegex;
    boolean includeBeginEndBoundaries;
    boolean includeCurrentToken = false;
    private static final int maxWindowSize = 20;
    private static final PropertyList[] startfs = new PropertyList[20];
    private static final PropertyList[] endfs = new PropertyList[20];
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    private static void initStartEndFs() {
        for (int i = 0; i < 20; ++i) {
            FeaturesInWindow.startfs[i] = PropertyList.add("<START" + i + ">", 1.0, null);
            FeaturesInWindow.endfs[i] = PropertyList.add("<END" + i + ">", 1.0, null);
        }
    }

    public FeaturesInWindow(String namePrefix, int leftBoundaryOffset, int rightBoundaryOffset, Pattern featureRegex, boolean includeBeginEndBoundaries) {
        this.namePrefix = namePrefix;
        this.leftBoundary = leftBoundaryOffset;
        this.rightBoundary = rightBoundaryOffset;
        this.featureRegex = featureRegex;
        this.includeBeginEndBoundaries = includeBeginEndBoundaries;
    }

    public FeaturesInWindow(String namePrefix, int leftBoundaryOffset, int rightBoundaryOffset) {
        this(namePrefix, leftBoundaryOffset, rightBoundaryOffset, null, true);
    }

    public Instance pipe(Instance carrier) {
        int i;
        TokenSequence ts = (TokenSequence)carrier.getData();
        int tsSize = ts.size();
        PropertyList[] newFeatures = new PropertyList[tsSize];
        for (i = 0; i < tsSize; ++i) {
            PropertyList pl;
            Token t = (Token)ts.get(i);
            newFeatures[i] = pl = t.getFeatures();
            for (int position = i + this.leftBoundary; position < i + this.rightBoundary; ++position) {
                if (position == i && !this.includeCurrentToken) continue;
                PropertyList pl2 = position < 0 ? startfs[-position] : (position >= tsSize ? endfs[position - tsSize] : ((Token)ts.get(position)).getFeatures());
                PropertyList.Iterator pl2i = pl2.iterator();
                while (pl2i.hasNext()) {
                    pl2i.next();
                    String key = pl2i.getKey();
                    if (this.featureRegex != null && !this.featureRegex.matcher(key).matches()) continue;
                    newFeatures[i] = PropertyList.add((this.namePrefixLeft == null || position - i > 0 ? this.namePrefix : this.namePrefixLeft) + key, pl2i.getNumericValue(), newFeatures[i]);
                }
            }
        }
        for (i = 0; i < tsSize; ++i) {
            ((Token)ts.get(i)).setFeatures(newFeatures[i]);
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.namePrefix);
        out.writeInt(this.leftBoundary);
        out.writeInt(this.rightBoundary);
        out.writeObject(this.featureRegex);
        out.writeBoolean(this.includeBeginEndBoundaries);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.namePrefix = (String)in.readObject();
        this.leftBoundary = in.readInt();
        this.rightBoundary = in.readInt();
        this.featureRegex = (Pattern)in.readObject();
        this.includeBeginEndBoundaries = in.readBoolean();
    }

    static {
        FeaturesInWindow.initStartEndFs();
    }
}

