/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types.tests;

import cc.mallet.types.HashedSparseVector;
import cc.mallet.types.SparseVector;
import cc.mallet.types.tests.TestSerializable;
import cc.mallet.util.FileUtils;
import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestHashedSparseVector
extends TestCase {
    double[] dbl1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
    double[] dbl2 = new double[]{1.0, 1.5, 2.0, 1.0, 1.0};
    double[] dbl3 = new double[]{2.0, 2.5, 3.0, 4.7, 3.5, 3.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    int[] idxs = new int[]{3, 5, 7, 13, 15};
    HashedSparseVector s1 = new HashedSparseVector(this.idxs, this.dbl1, this.dbl1.length, this.dbl1.length, true, true, true);
    HashedSparseVector s2 = new HashedSparseVector(this.idxs, this.dbl2, this.dbl2.length, this.dbl2.length, true, true, true);
    SparseVector d1 = new SparseVector(this.dbl3, true);
    private static int[] idx2 = new int[]{3, 7, 12, 15, 18};
    private static File oldSv = new File("test/resources/edu/umass/cs/mallet/base/types/hashed.sv.old.ser");

    public TestHashedSparseVector(String name) {
        super(name);
    }

    private void checkAnswer(HashedSparseVector actual, double[] ans) {
        TestHashedSparseVector.assertEquals((String)"Wrong number of locations:", (int)ans.length, (int)actual.numLocations());
        for (int i = 0; i < actual.numLocations(); ++i) {
            TestHashedSparseVector.assertEquals((String)("Value incorrect at location " + i + ": "), (double)ans[i], (double)actual.valueAtLocation(i), (double)0.0);
        }
    }

    public void testPlusEquals() {
        HashedSparseVector s = (HashedSparseVector)this.s1.cloneMatrix();
        s.plusEqualsSparse(this.s2, 2.0);
        this.checkAnswer(s, new double[]{3.0, 5.0, 7.0, 6.0, 7.0});
        HashedSparseVector s2p = new HashedSparseVector(new int[]{13}, new double[]{0.8});
        s.plusEqualsSparse(s2p, 1.0);
        this.checkAnswer(s, new double[]{3.0, 5.0, 7.0, 6.8, 7.0});
        HashedSparseVector s3p = new HashedSparseVector(new int[]{14}, new double[]{0.8});
        s.plusEqualsSparse(s3p, 1.0);
        this.checkAnswer(s, new double[]{3.0, 5.0, 7.0, 6.8, 7.0});
        HashedSparseVector s4 = new HashedSparseVector(new int[]{7, 14, 15}, new double[]{0.2, 0.8, 1.2});
        s.plusEqualsSparse(s4, 1.0);
        this.checkAnswer(s, new double[]{3.0, 5.0, 7.2, 6.8, 8.2});
        HashedSparseVector s5 = new HashedSparseVector(new int[]{7}, new double[]{0.2});
        s5.plusEqualsSparse(this.s1);
        for (int i = 0; i < s5.numLocations(); ++i) {
            TestHashedSparseVector.assertEquals((int)7, (int)s5.indexAtLocation(i));
            TestHashedSparseVector.assertEquals((double)3.2, (double)s5.valueAtLocation(i), (double)0.0);
        }
        HashedSparseVector s6 = new HashedSparseVector(new int[]{7}, new double[]{0.2});
        s6.plusEqualsSparse(this.s1, 3.5);
        for (int i = 0; i < s6.numLocations(); ++i) {
            TestHashedSparseVector.assertEquals((int)7, (int)s6.indexAtLocation(i));
            TestHashedSparseVector.assertEquals((double)10.7, (double)s6.valueAtLocation(i), (double)0.0);
        }
    }

    public void testPlusEqualsAfterClone() {
        this.s1.indexVector();
        HashedSparseVector s = (HashedSparseVector)this.s1.cloneMatrixZeroed();
        s.plusEqualsSparse(this.s1);
        s.plusEqualsSparse(this.s2, 2.0);
        this.checkAnswer(s, new double[]{3.0, 5.0, 7.0, 6.0, 7.0});
    }

    public void testDotProduct() {
        HashedSparseVector t1 = new HashedSparseVector(new int[]{7}, new double[]{0.2});
        TestHashedSparseVector.assertEquals((double)0.6, (double)t1.dotProduct(this.s1), (double)1.0E-5);
        TestHashedSparseVector.assertEquals((double)0.6, (double)this.s1.dotProduct(t1), (double)1.0E-5);
        TestHashedSparseVector.assertEquals((double)19.0, (double)this.s1.dotProduct(this.s2), (double)1.0E-5);
        TestHashedSparseVector.assertEquals((double)19.0, (double)this.s2.dotProduct(this.s1), (double)1.0E-5);
        TestHashedSparseVector.assertEquals((double)11.9, (double)this.s1.dotProduct(this.d1), (double)1.0E-5);
        TestHashedSparseVector.assertEquals((double)10.1, (double)this.s2.dotProduct(this.d1), (double)1.0E-5);
    }

    public void testIncrementValue() {
        HashedSparseVector s = (HashedSparseVector)this.s1.cloneMatrix();
        s.incrementValue(5, 0.75);
        double[] ans = new double[]{1.0, 2.75, 3.0, 4.0, 5.0};
        for (int i = 0; i < s.numLocations(); ++i) {
            TestHashedSparseVector.assertTrue((s.valueAtLocation(i) == ans[i] ? 1 : 0) != 0);
        }
    }

    public void testSetValue() {
        HashedSparseVector s = (HashedSparseVector)this.s1.cloneMatrix();
        s.setValue(5, 0.3);
        double[] ans = new double[]{1.0, 0.3, 3.0, 4.0, 5.0};
        for (int i = 0; i < s.numLocations(); ++i) {
            TestHashedSparseVector.assertTrue((s.valueAtLocation(i) == ans[i] ? 1 : 0) != 0);
        }
    }

    public void testBinaryVector() {
        HashedSparseVector binary1 = new HashedSparseVector(this.idxs, null, this.idxs.length, this.idxs.length, false, false, false);
        HashedSparseVector binary2 = new HashedSparseVector(idx2, null, idx2.length, idx2.length, false, false, false);
        TestHashedSparseVector.assertEquals((double)3.0, (double)binary1.dotProduct(binary2), (double)1.0E-4);
        TestHashedSparseVector.assertEquals((double)3.0, (double)binary2.dotProduct(binary1), (double)1.0E-4);
        TestHashedSparseVector.assertEquals((double)15.0, (double)binary1.dotProduct(this.s1), (double)1.0E-4);
        TestHashedSparseVector.assertEquals((double)15.0, (double)this.s1.dotProduct(binary1), (double)1.0E-4);
        TestHashedSparseVector.assertEquals((double)9.0, (double)binary2.dotProduct(this.s1), (double)1.0E-4);
        TestHashedSparseVector.assertEquals((double)9.0, (double)this.s1.dotProduct(binary2), (double)1.0E-4);
        HashedSparseVector dblVec = (HashedSparseVector)this.s1.cloneMatrix();
        dblVec.plusEqualsSparse(binary1);
        this.checkAnswer(dblVec, new double[]{2.0, 3.0, 4.0, 5.0, 6.0});
        HashedSparseVector dblVec2 = (HashedSparseVector)this.s1.cloneMatrix();
        dblVec2.plusEqualsSparse(binary2);
        this.checkAnswer(dblVec2, new double[]{2.0, 2.0, 4.0, 4.0, 6.0});
    }

    public void testCloneMatrixZeroed() {
        HashedSparseVector s = (HashedSparseVector)this.s1.cloneMatrixZeroed();
        for (int i = 0; i < s.numLocations(); ++i) {
            TestHashedSparseVector.assertTrue((s.valueAtLocation(i) == 0.0 ? 1 : 0) != 0);
            TestHashedSparseVector.assertTrue((s.indexAtLocation(i) == this.idxs[i] ? 1 : 0) != 0);
        }
    }

    public void testSerializable() throws Exception {
        HashedSparseVector s2 = (HashedSparseVector)TestSerializable.cloneViaSerialization(this.s1);
        TestHashedSparseVector.assertEquals((int)this.s1.numLocations(), (int)s2.numLocations());
        for (int loc = 0; loc < this.s1.numLocations(); ++loc) {
            TestHashedSparseVector.assertEquals((double)this.s1.valueAtLocation(loc), (double)s2.valueAtLocation(loc), (double)0.001);
        }
    }

    public void testPlusEqualsFromSaved() throws IOException, ClassNotFoundException {
        HashedSparseVector s1 = (HashedSparseVector)FileUtils.readObject(oldSv);
        HashedSparseVector s2 = new HashedSparseVector(new int[]{1}, new double[]{1.0});
        s1.plusEqualsSparse(s2, 1.0);
        TestHashedSparseVector.assertEquals((double)1.0, (double)s1.value(0), (double)1.0E-5);
        TestHashedSparseVector.assertEquals((double)0.0, (double)s1.value(1), (double)1.0E-5);
    }

    public static void saveOldSv() {
        HashedSparseVector sv = new HashedSparseVector(new int[]{0, 2}, new double[]{1.0, 2.0});
        sv.indexVector();
        FileUtils.writeObject(oldSv, sv);
    }

    public static Test suite() {
        return new TestSuite(TestHashedSparseVector.class);
    }

    protected void setUp() {
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestHashedSparseVector.suite());
    }
}

