/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.bucket.range.ParsedRange;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ParsedDateRange
extends ParsedRange {
    private static ObjectParser<ParsedDateRange, Void> PARSER = new ObjectParser(ParsedDateRange.class.getSimpleName(), true, ParsedDateRange::new);

    @Override
    public String getType() {
        return "date_range";
    }

    public static ParsedDateRange fromXContent(XContentParser parser, String name) throws IOException {
        ParsedDateRange aggregation = PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedDateRange.declareParsedRangeFields(PARSER, parser -> ParsedBucket.fromXContent(parser, false), parser -> ParsedBucket.fromXContent(parser, true));
    }

    public static class ParsedBucket
    extends ParsedRange.ParsedBucket {
        @Override
        public Object getFrom() {
            return ParsedBucket.doubleAsDateTime(this.from);
        }

        @Override
        public Object getTo() {
            return ParsedBucket.doubleAsDateTime(this.to);
        }

        private static DateTime doubleAsDateTime(Double d) {
            if (d == null || Double.isInfinite(d)) {
                return null;
            }
            return new DateTime(d.longValue(), DateTimeZone.UTC);
        }

        static ParsedBucket fromXContent(XContentParser parser, boolean keyed) throws IOException {
            return ParsedBucket.parseRangeBucketXContent(parser, ParsedBucket::new, keyed);
        }
    }
}

