/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Env;
import fan.sys.Err;
import fan.sys.Facet;
import fan.sys.Facets;
import fan.sys.FanObj;
import fan.sys.Field;
import fan.sys.IOErr;
import fan.sys.List;
import fan.sys.Method;
import fan.sys.NullableType;
import fan.sys.Param;
import fan.sys.Pod;
import fan.sys.Slot;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.UnknownSlotErr;
import fanx.emit.FTypeEmit;
import fanx.fcode.FDoc;
import fanx.fcode.FField;
import fanx.fcode.FMethod;
import fanx.fcode.FMethodVar;
import fanx.fcode.FPod;
import fanx.fcode.FStore;
import fanx.fcode.FType;
import fanx.serial.ObjEncoder;
import fanx.util.FanUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class ClassType
extends Type {
    static final boolean Debug = false;
    static Object noParams;
    final Pod pod;
    final String name;
    final String qname;
    final int flags;
    final Type nullable;
    int lineNum;
    String sourceFile = "";
    Type base;
    List mixins;
    List inheritance;
    FType ftype;
    boolean docLoaded;
    public String doc;
    List fields;
    List methods;
    List slots;
    HashMap slotsByName;
    Facets myFacets;
    Facets inheritedFacets;
    Class cls;
    Class auxCls;
    boolean finished;
    String finishing;
    boolean javaRepr;

    ClassType(Pod pod, FType fType) {
        this.pod = pod;
        this.ftype = fType;
        this.name = pod.fpod.typeRef((int)fType.self).typeName;
        this.qname = pod.name + "::" + this.name;
        this.nullable = new NullableType(this);
        this.flags = fType.flags;
    }

    public ClassType(Pod pod, String string, int n, Facets facets) {
        this.pod = pod;
        this.name = string;
        this.qname = pod.name + "::" + string;
        this.nullable = new NullableType(this);
        this.flags = n;
    }

    public final Pod pod() {
        return this.pod;
    }

    public final String name() {
        return this.name;
    }

    public final String qname() {
        return this.qname;
    }

    public String signature() {
        return this.qname;
    }

    public final Type toNullable() {
        return this.nullable;
    }

    int flags() {
        return this.flags;
    }

    public Object trap(String string, List list) {
        if (string.equals("lineNumber")) {
            this.reflect();
            return (long)this.lineNum;
        }
        if (string.equals("sourceFile")) {
            this.reflect();
            return this.sourceFile;
        }
        return super.trap(string, list);
    }

    public final List fields() {
        return this.reflect().fields.ro();
    }

    public final List methods() {
        return this.reflect().methods.ro();
    }

    public final List slots() {
        return this.reflect().slots.ro();
    }

    public final Slot slot(String string, boolean bl) {
        Slot slot = (Slot)this.reflect().slotsByName.get(string);
        if (slot != null) {
            return slot;
        }
        if (bl) {
            throw UnknownSlotErr.make(this.qname + "." + string);
        }
        return null;
    }

    public final Object make(List list) {
        return super.make(list);
    }

    public Type base() {
        return this.base;
    }

    public List mixins() {
        return this.mixins;
    }

    public List inheritance() {
        if (this.inheritance == null) {
            this.inheritance = ClassType.inheritance(this);
        }
        return this.inheritance;
    }

    static List inheritance(Type type) {
        HashMap<String, Type> hashMap = new HashMap<String, Type>();
        List list = new List(Sys.TypeType);
        if (type == Sys.VoidType) {
            list.add(type);
            return list.trim().ro();
        }
        hashMap.put(type.qname(), type);
        list.add(type);
        ClassType.addInheritance(type.base(), list, hashMap);
        List list2 = type.mixins();
        for (int i = 0; i < list2.sz(); ++i) {
            ClassType.addInheritance((Type)list2.get(i), list, hashMap);
        }
        return list.trim().ro();
    }

    private static void addInheritance(Type type, List list, HashMap hashMap) {
        if (type == null) {
            return;
        }
        List list2 = type.inheritance();
        for (int i = 0; i < list2.sz(); ++i) {
            Type type2 = (Type)list2.get(i);
            if (hashMap.get(type2.qname()) != null) continue;
            hashMap.put(type2.qname(), type2);
            list.add(type2);
        }
    }

    public boolean is(Type type) {
        if (type instanceof NullableType) {
            type = ((NullableType)type).root;
        }
        if (type == this || type == Sys.ObjType && this != Sys.VoidType) {
            return true;
        }
        List list = this.inheritance();
        for (int i = 0; i < list.sz(); ++i) {
            if (list.get(i) != type) continue;
            return true;
        }
        return false;
    }

    public static Type common(Object[] objectArray, int n) {
        if (objectArray.length == 0) {
            return Sys.ObjType;
        }
        Type type = ClassType.typeof(objectArray[0]);
        for (int i = 1; i < n; ++i) {
            Object object = objectArray[i];
            if (object == null) continue;
            Type type2 = ClassType.typeof(object);
            while (!type2.is(type)) {
                if ((type = type.base()) != null) continue;
                return Sys.ObjType;
            }
        }
        return type;
    }

    public List facets() {
        if (this.inheritedFacets == null) {
            this.loadFacets();
        }
        return this.inheritedFacets.list();
    }

    public Facet facet(Type type, boolean bl) {
        if (this.inheritedFacets == null) {
            this.loadFacets();
        }
        return this.inheritedFacets.get(type, bl);
    }

    private void loadFacets() {
        this.reflect();
        Facets facets = this.myFacets.dup();
        List list = this.inheritance();
        for (int i = 0; i < list.sz(); ++i) {
            Object object = list.get(i);
            if (!(object instanceof ClassType)) continue;
            ClassType classType = (ClassType)object;
            facets.inherit(classType.reflect().myFacets);
        }
        this.inheritedFacets = facets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doc() {
        if (!this.docLoaded) {
            block6: {
                try {
                    FStore.Input input = this.pod.fpod.store.read("doc/" + this.name + ".apidoc");
                    if (input == null) break block6;
                    try {
                        new FDoc(input, this).read();
                    }
                    finally {
                        ((InputStream)input).close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.docLoaded = true;
        }
        return this.doc;
    }

    public void encode(ObjEncoder objEncoder) {
        objEncoder.w(this.qname).w("#");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ClassType reflect() {
        Object object = this.lock();
        synchronized (object) {
            if (this.slotsByName != null) {
                return this;
            }
            this.doReflect();
            return this;
        }
    }

    protected void doReflect() {
        FanObj fanObj;
        int n;
        if (this.ftype.hollow) {
            try {
                this.ftype.read();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw IOErr.make("Cannot read " + this.qname + " from pod", iOException);
            }
        }
        List list = new List(Sys.SlotType, 64);
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        for (int i = 0; i < this.mixins().sz(); ++i) {
            this.merge((Type)this.mixins.get(i), list, hashMap, hashMap2);
        }
        this.merge(this.base, list, hashMap, hashMap2);
        FPod fPod = this.pod.fpod;
        FType fType = this.ftype;
        for (n = 0; n < fType.fields.length; ++n) {
            fanObj = this.map(fPod, fType.fields[n]);
            this.merge((Slot)fanObj, list, hashMap, hashMap2);
        }
        for (n = 0; n < fType.methods.length; ++n) {
            fanObj = this.map(fPod, fType.methods[n]);
            this.merge((Slot)fanObj, list, hashMap, hashMap2);
        }
        List list2 = new List(Sys.FieldType, list.sz());
        fanObj = new List(Sys.MethodType, list.sz());
        for (int i = 0; i < list.sz(); ++i) {
            Slot slot = (Slot)list.get(i);
            if (slot instanceof Field) {
                list2.add(slot);
                continue;
            }
            ((List)fanObj).add(slot);
        }
        this.slots = list.trim();
        this.fields = list2.trim();
        this.methods = ((List)fanObj).trim();
        this.slotsByName = hashMap;
        this.myFacets = Facets.mapFacets(this.pod, fType.attrs.facets);
        this.lineNum = fType.attrs.lineNum;
        this.sourceFile = fType.attrs.sourceFile;
    }

    private void merge(Type type, List list, HashMap hashMap, HashMap hashMap2) {
        if (type == null) {
            return;
        }
        List list2 = type.reflect().slots();
        for (int i = 0; i < list2.sz(); ++i) {
            this.merge((Slot)list2.get(i), list, hashMap, hashMap2);
        }
    }

    private void merge(Slot slot, List list, HashMap hashMap, HashMap hashMap2) {
        if (slot.isCtor() && slot.parent != this) {
            return;
        }
        String string = slot.name;
        Long l = (Long)hashMap2.get(string);
        if (l != null) {
            if (slot.parent() == Sys.ObjType) {
                return;
            }
            Slot slot2 = (Slot)list.get(l);
            if (slot.parent() != this && slot.isAbstract() && !slot2.isAbstract()) {
                return;
            }
            if ((slot.flags & 0x4040) != 0) {
                Field field = (Field)list.get(l);
                if ((slot.flags & 0x40) != 0) {
                    field.getter = (Method)slot;
                } else {
                    field.setter = (Method)slot;
                }
                return;
            }
            hashMap.put(string, slot);
            list.set(l, slot);
        } else {
            hashMap.put(string, slot);
            list.add(slot);
            hashMap2.put(string, Long.valueOf(list.sz() - 1));
        }
    }

    private Field map(FPod fPod, FField fField) {
        String string = fField.name.intern();
        Type type = this.pod.type(fField.type);
        Facets facets = Facets.mapFacets(this.pod, fField.attrs.facets);
        return new Field(this, string, fField.flags, facets, fField.attrs.lineNum, type);
    }

    private Method map(FPod fPod, FMethod fMethod) {
        String string = fMethod.name.intern();
        Type type = this.pod.type(fMethod.ret);
        Type type2 = this.pod.type(fMethod.inheritedRet);
        List list = new List(Sys.ParamType, fMethod.paramCount);
        for (int i = 0; i < fMethod.paramCount; ++i) {
            FMethodVar fMethodVar = fMethod.vars[i];
            int n = fMethodVar.def == null ? 0 : 1;
            list.add(new Param(fMethodVar.name.intern(), this.pod.type(fMethodVar.type), n));
        }
        Facets facets = Facets.mapFacets(this.pod, fMethod.attrs.facets);
        return new Method(this, string, fMethod.flags, facets, fMethod.attrs.lineNum, type, type2, list);
    }

    public Class toClass() {
        return this.emit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class emit() {
        Object object = this.lock();
        synchronized (object) {
            if (this.cls == null) {
                this.reflect();
                String string = this.pod.name;
                if (string.equals("sys")) {
                    try {
                        this.javaRepr = FanUtil.isJavaRepresentation(this);
                        this.cls = Class.forName(FanUtil.toJavaImplClassName(string, this.name));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        throw Err.make("Cannot load precompiled class: " + this.qname, exception);
                    }
                }
                try {
                    Class[] classArray = Env.cur().loadTypeClasses(this);
                    this.cls = classArray[0];
                    if (classArray.length > 1) {
                        this.auxCls = classArray[1];
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw Err.make("Cannot emit: " + this.qname, exception);
                }
                this.ftype = null;
            }
            return this.cls;
        }
    }

    public void precompiled(Class clazz) {
        this.cls = clazz;
        try {
            if (this.isMixin()) {
                this.auxCls = clazz.getClassLoader().loadClass(clazz.getName() + "$");
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: Invalid precompiled class missing aux: " + this.qname);
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Object object = this.lock();
        synchronized (object) {
            if (this.finished) {
                return;
            }
            try {
                this.reflect();
                this.emit();
                this.finished = true;
                this.finishSlots(this.cls, false);
                if (this.isMixin()) {
                    this.finishSlots(this.auxCls, true);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw Err.make("Cannot emitFinish: " + this.qname + "." + this.finishing, throwable);
            }
            finally {
                this.finishing = null;
            }
        }
    }

    private void finishSlots(Class clazz, boolean bl) {
        java.lang.reflect.Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            this.finishField(fieldArray[i]);
        }
        java.lang.reflect.Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            this.finishMethod(methodArray[i], bl);
        }
    }

    private void finishField(java.lang.reflect.Field field) {
        this.finishing = field.getName();
        Slot slot = this.slot(field.getName(), false);
        if (slot == null || !(slot instanceof Field)) {
            return;
        }
        Field field2 = (Field)slot;
        if (field2.reflect != null) {
            return;
        }
        field.setAccessible(true);
        field2.reflect = field;
    }

    private void finishMethod(java.lang.reflect.Method method, boolean bl) {
        if (this.pod == Sys.sysPod && !Modifier.isPublic(method.getModifiers())) {
            return;
        }
        this.finishing = method.getName();
        String string = method.getName();
        Slot slot = this.slot(string, false);
        if (slot == null) {
            return;
        }
        if (slot.parent() != this) {
            return;
        }
        if (bl && !slot.isStatic()) {
            return;
        }
        method.setAccessible(true);
        if (slot instanceof Method) {
            int n;
            Method method2 = (Method)slot;
            if (method2.reflect == null) {
                int n2 = 1;
                for (n = method2.params().sz() - 1; n >= 0 && ((Param)method2.params().get(n)).hasDefault(); --n) {
                    ++n2;
                }
                method2.reflect = new java.lang.reflect.Method[n2];
            }
            Class[] classArray = method.getParameterTypes();
            n = classArray.length;
            if (this.pod == Sys.sysPod) {
                if (!this.checkAllFan(classArray)) {
                    return;
                }
                if (this.javaRepr) {
                    boolean bl2 = Modifier.isStatic(method.getModifiers());
                    if (!bl2) {
                        return;
                    }
                    if (!method2.isStatic() && !method2.isCtor()) {
                        --n;
                    }
                }
            }
            method2.reflect[method2.params().sz() - n] = method;
        } else {
            Field field = (Field)slot;
            if (method.getReturnType() == Void.TYPE) {
                field.setter.reflect = new java.lang.reflect.Method[]{method};
            } else {
                field.getter.reflect = new java.lang.reflect.Method[]{method};
            }
        }
    }

    public FTypeEmit[] emitToClassFiles() throws Exception {
        this.reflect();
        return FTypeEmit.emit(this, this.ftype);
    }

    boolean checkAllFan(Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            Type type;
            Class clazz = classArray[i];
            if (clazz.getName().startsWith("fan.") || (type = FanUtil.toFanType(clazz, false)) != null && !type.isJava()) continue;
            return false;
        }
        return true;
    }

    public boolean javaRepr() {
        return this.javaRepr;
    }

    private Object lock() {
        return this.pod.classLoader;
    }
}

