/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Facet;
import fan.sys.FacetMeta;
import fan.sys.IOErr;
import fan.sys.List;
import fan.sys.Pod;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.UnknownFacetErr;
import fanx.fcode.FAttrs;
import fanx.serial.ObjDecoder;
import java.util.HashMap;
import java.util.Map;

public final class Facets {
    private static Facets emptyVal;
    private static Facets transientVal;
    private HashMap map;
    private List list;

    public static Facets empty() {
        Facets facets = emptyVal;
        if (facets == null) {
            facets = emptyVal = new Facets(new HashMap());
        }
        return facets;
    }

    public static Facets makeTransient() {
        Facets facets = transientVal;
        if (facets == null) {
            HashMap<Type, String> hashMap = new HashMap<Type, String>();
            hashMap.put(Sys.TransientType, "");
            facets = transientVal = new Facets(hashMap);
        }
        return facets;
    }

    static Facets mapFacets(Pod pod, FAttrs.FFacet[] fFacetArray) {
        if (fFacetArray == null || fFacetArray.length == 0) {
            return Facets.empty();
        }
        HashMap<Type, String> hashMap = new HashMap<Type, String>(fFacetArray.length * 3);
        for (int i = 0; i < fFacetArray.length; ++i) {
            FAttrs.FFacet fFacet = fFacetArray[i];
            Type type = pod.type(fFacet.type);
            if (type.isJava()) continue;
            hashMap.put(type, fFacet.val);
        }
        return new Facets(hashMap);
    }

    private Facets(HashMap hashMap) {
        this.map = hashMap;
    }

    final synchronized List list() {
        if (this.list == null) {
            this.list = new List(Sys.FacetType, this.map.size());
            for (Type type : this.map.keySet()) {
                this.list.add(this.get(type, true));
            }
            this.list = (List)this.list.toImmutable();
        }
        return this.list;
    }

    final synchronized Facet get(Type type, boolean bl) {
        Object v = this.map.get(type);
        if (v instanceof Facet) {
            return (Facet)v;
        }
        if (v instanceof String) {
            Facet facet = this.decode(type, (String)v);
            this.map.put(type, facet);
            return facet;
        }
        if (bl) {
            throw UnknownFacetErr.make(type.qname());
        }
        return null;
    }

    final Facet decode(Type type, String string) {
        try {
            if (string.length() == 0) {
                return (Facet)type.make();
            }
            return (Facet)ObjDecoder.decode(string);
        }
        catch (Throwable throwable) {
            String string2 = "ERROR: Cannot decode facet " + type + ": " + string;
            System.out.println(string2);
            throwable.printStackTrace();
            this.map.remove(type);
            throw IOErr.make(string2);
        }
    }

    final Facets dup() {
        return new Facets((HashMap)this.map.clone());
    }

    final void inherit(Facets facets) {
        if (facets.map.size() == 0) {
            return;
        }
        this.list = null;
        for (Map.Entry entry : facets.map.entrySet()) {
            FacetMeta facetMeta;
            Type type = (Type)entry.getKey();
            if (this.map.get(type) != null || (facetMeta = (FacetMeta)type.facet(Sys.FacetMetaType, false)) == null || !facetMeta.inherited) continue;
            this.map.put(type, entry.getValue());
        }
    }
}

